/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.message.consumer;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;

public abstract class AbstractKafkaConsumer
implements InitializingBean {
    public static final int DEFAULT_POOL_SIZE = 1;
    protected Logger log = LoggerFactory.getLogger((String)"message");
    @Value(value="${media.kafka.group.id}")
    private String kafkaGroupId;
    @Value(value="${media.kafka.bootstrap.servers}")
    private String kafkaServers;
    private ExecutorService executorService;
    private boolean running;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMessageConsumer() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.kafkaServers);
        props.put("group.id", this.kafkaGroupId);
        props.put("enable.auto.commit", "false");
        props.put("session.timeout.ms", "30000");
        props.put("auto.offset.reset", "earliest");
        props.put("max.partition.fetch.bytes", "2048");
        props.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        props.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        props.put("max.poll.records", "10");
        consumer.subscribe(this.getTopics());
        try (KafkaConsumer consumer = new KafkaConsumer(props);){
            while (this.running) {
                ConsumerRecords records = consumer.poll(100L);
                for (TopicPartition pt : records.partitions()) {
                    for (ConsumerRecord record : records.records(pt)) {
                        try {
                            this.readMessage((ConsumerRecord<String, String>)record);
                            long lastOffset = record.offset();
                            consumer.commitSync(Collections.singletonMap(pt, new OffsetAndMetadata(lastOffset + 1L)));
                        }
                        catch (KafkaException e) {
                            this.log.error(String.format("Kafka Error, offset=[%s]", record.offset()), (Throwable)e);
                        }
                        catch (Exception e) {
                            this.log.error(String.format("Consumer Error, offset=[%s]", record.offset()), (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    public synchronized void start() throws TuiaMediaException {
        if (this.running) {
            return;
        }
        this.running = true;
        this.executorService = Executors.newFixedThreadPool(this.getPoolSize(), new ThreadFactory(){
            private int i = 0;

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, "Thread-" + this.getClass().getName() + "-Consumer-" + this.i++);
            }
        });
        for (int i = 0; i < this.getPoolSize(); ++i) {
            this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        AbstractKafkaConsumer.this.createMessageConsumer();
                    }
                    catch (Exception e) {
                        AbstractKafkaConsumer.this.log.error("error:", (Throwable)e);
                    }
                }
            });
        }
        this.log.info("Consumer started");
    }

    public synchronized void stop() {
        this.running = false;
        if (this.executorService != null) {
            this.executorService.shutdown();
            this.executorService = null;
        }
    }

    protected int getPoolSize() {
        return 1;
    }

    protected abstract List<String> getTopics();

    protected abstract void readMessage(ConsumerRecord<String, String> var1);

    public void afterPropertiesSet() throws Exception {
        this.start();
    }
}

