/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.remoteservice;

import cn.com.duiba.tuia.media.api.dto.AccountChangeDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqAccountChange;
import cn.com.duiba.tuia.media.api.dto.rsp.AccountChangeRsp;
import cn.com.duiba.tuia.media.api.dto.rsp.RspAccountChangeResult;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteAccountChangeBackendService;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.common.tool.DataTool;
import cn.com.duiba.tuia.media.dao.AccountChangeDAO;
import cn.com.duiba.tuia.media.remoteservice.BaseRemoteService;
import cn.com.duiba.tuia.media.service.AccountChangeService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

public class RemoteAccountChangeBackendServiceImpl
extends BaseRemoteService
implements RemoteAccountChangeBackendService {
    private static final String WORD_SEPARATOR = "\",\"";
    private static final String START_PREFIX = "\" ";
    private static final String END_POSTFIX = "\"\n";
    @Autowired
    private AccountChangeService accountChangeService;
    @Autowired
    private AccountChangeDAO accountChangeDAO;

    public DubboResult<Boolean> addAccountChange(AccountChangeDto accountChangeDto) {
        try {
            this.accountChangeService.insertAccountChange(accountChangeDto);
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            this.logger.error("RemoteAccountChangeBackendServiceImpl.addAccountChange is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<RspAccountChangeResult<AccountChangeRsp>> selectAccountChangeList(ReqAccountChange req) {
        try {
            return DubboResult.successResult(this.accountChangeService.selectAccountChangeList(req));
        }
        catch (Exception e) {
            this.logger.error("RemoteAccountChangeBackendServiceImpl.selectAccountChangeList is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> exportAccountChange(ReqAccountChange req, OutputStream out) {
        StringBuilder content = new StringBuilder();
        content.append(" \u65f6\u95f4 ,\u660e\u7ec6,\u91d1\u989d\uff08\u5143\uff09,\u4f59\u989d\uff08\u5143\uff09\n");
        try {
            List<AccountChangeDto> datas = this.accountChangeDAO.selectAccountChangeList(req);
            if (CollectionUtils.isEmpty(datas)) {
                this.doExportFile(out, content);
            }
            for (AccountChangeDto data : datas) {
                StringBuilder row = new StringBuilder();
                row.append(START_PREFIX);
                row.append(new DateTime((Object)data.getCurDate()).toString("yyyy-MM-dd HH:mm:ss"));
                row.append(WORD_SEPARATOR);
                row.append(data.getRemark());
                row.append(WORD_SEPARATOR);
                row.append("+" + DataTool.calculateFenToYuan((Long)data.getAmount()));
                row.append(WORD_SEPARATOR);
                row.append(DataTool.calculateFenToYuan((Long)data.getBalance()));
                row.append(END_POSTFIX);
                content.append((CharSequence)row);
            }
            this.doExportFile(out, content);
        }
        catch (TuiaMediaException e) {
            this.logger.error("exportAccountChange error!", (Throwable)e);
            DubboResult.failResult((String)ErrorCode.E0002006.getErrorCode(), (String)ErrorCode.E0002006.getDesc());
        }
        return DubboResult.successResult((Object)true);
    }

    private void doExportFile(OutputStream out, StringBuilder content) throws TuiaMediaException {
        try {
            out.write(content.toString().getBytes("GBK"));
            out.flush();
        }
        catch (Exception e) {
            this.logger.error("doExportFile error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002006, (Throwable)e);
        }
    }

    public DubboResult<AccountChangeDto> selectAccountChangeById(Long id) {
        try {
            return DubboResult.successResult((Object)this.accountChangeService.selectAccountChangeById(id));
        }
        catch (Exception e) {
            this.logger.error("RemoteAccountChangeBackendServiceImpl.selectAccountChangeById is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<AccountChangeDto> selectAccountChangeByMediaId(Long mediaId) {
        try {
            return DubboResult.successResult((Object)this.accountChangeService.selectAccountChangeByMediaId(mediaId));
        }
        catch (Exception e) {
            this.logger.error("RemoteAccountChangeBackendServiceImpl.selectAccountChangeByMediaId is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }
}

