/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.remoteservice;

import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqActivitySort;
import cn.com.duiba.tuia.media.api.dto.req.ReqIdAndType;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteActivitySortBackendService;
import cn.com.duiba.tuia.media.common.constants.ActivityStatusConstant;
import cn.com.duiba.tuia.media.common.constants.ActivityTypeConstant;
import cn.com.duiba.tuia.media.common.tool.DataTool;
import cn.com.duiba.tuia.media.common.utils.CollectionUtil;
import cn.com.duiba.tuia.media.domain.ActivityDto;
import cn.com.duiba.tuia.media.domain.ActivitySortDto;
import cn.com.duiba.tuia.media.domain.ActivityStatisticsDayDto;
import cn.com.duiba.tuia.media.remoteservice.BaseRemoteService;
import cn.com.duiba.tuia.media.service.ActivityService;
import cn.com.duiba.tuia.media.service.ActivitySortService;
import cn.com.duiba.tuia.media.service.ActivityStatisticsDayService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class RemoteActivitySortBackendServiceImpl
extends BaseRemoteService
implements RemoteActivitySortBackendService {
    private static final long TIME_DIFFER = 1000000L;
    @Autowired
    private ActivitySortService activitySortService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ActivityStatisticsDayService activityStatisticsDayService;

    public DubboResult<PageResultDto<RspActivityDto>> getByCondition(ReqActivitySort reqActivitySort) {
        try {
            List<ActivitySortDto> result = this.activitySortService.selectByCondition(reqActivitySort);
            if (CollectionUtils.isEmpty(result)) {
                return DubboResult.successResult((Object)new PageResultDto(0, new ArrayList(), reqActivitySort.getPageSize().intValue()));
            }
            List<ActivityDto> activityDtoList = this.activityService.selectByActivityIds(CollectionUtil.getFieldList(result, (String)"activityId"));
            HashMap<String, ActivityDto> activityMap = new HashMap<String, ActivityDto>(activityDtoList.size());
            for (ActivityDto activityDto : activityDtoList) {
                activityMap.put(activityDto.getActivityId() + activityDto.getActivityType().toString(), activityDto);
            }
            ArrayList<RspActivityDto> rspActivityDtoList = new ArrayList<RspActivityDto>(result.size());
            List<ActivityStatisticsDayDto> activityStatisticsDayDtoList = this.activityStatisticsDayService.selectExposureAndLaunchAdvert(CollectionUtil.getFieldList(result, (String)"activityId"), reqActivitySort.getAppId());
            HashMap<String, Long> spmMap = new HashMap<String, Long>(activityStatisticsDayDtoList.size());
            for (ActivityStatisticsDayDto activityStatisticsDayDto : activityStatisticsDayDtoList) {
                spmMap.put(activityStatisticsDayDto.getDuibaActivityId() + activityStatisticsDayDto.getDuibaActivityType().toString(), DataTool.calculateEcpm((Long)activityStatisticsDayDto.getLaunchAdvertCount(), (Long)activityStatisticsDayDto.getExposureCount()));
            }
            for (ActivitySortDto activitySortDto : result) {
                RspActivityDto rspActivityDto = new RspActivityDto();
                rspActivityDto.setId(activitySortDto.getActivityId());
                if (activityMap.get(activitySortDto.getActivityId() + activitySortDto.getActivityType().toString()) != null) {
                    rspActivityDto.setName(((ActivityDto)((Object)activityMap.get(activitySortDto.getActivityId() + activitySortDto.getActivityType().toString()))).getActivityName());
                    rspActivityDto.setStatus(ActivityStatusConstant.getStatusText((Integer)((ActivityDto)((Object)activityMap.get(activitySortDto.getActivityId() + activitySortDto.getActivityType().toString()))).getActivityStatus()));
                    rspActivityDto.setType(((ActivityDto)((Object)activityMap.get(activitySortDto.getActivityId() + activitySortDto.getActivityType().toString()))).getActivityType());
                    rspActivityDto.setTypeName(ActivityTypeConstant.getTypeText((Integer)((ActivityDto)((Object)activityMap.get(activitySortDto.getActivityId() + activitySortDto.getActivityType().toString()))).getActivityType()));
                    rspActivityDto.setSpm((Long)spmMap.get(activitySortDto.getActivityId() + activitySortDto.getActivityType().toString()));
                }
                rspActivityDtoList.add(rspActivityDto);
            }
            return DubboResult.successResult((Object)new PageResultDto(this.activitySortService.selectByConditionAmount(reqActivitySort), rspActivityDtoList, reqActivitySort.getPageSize().intValue()));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendServiceImpl.getByCondition is error");
            return this.exceptionFailure(e);
        }
    }

    public synchronized DubboResult<Boolean> addActivitySort(Long activityAppId, List<ReqIdAndType> idAndTypes) {
        try {
            Long sort = new Date().getTime();
            ActivitySortDto result = this.activitySortService.getMaxSortValueActivitySortDto(activityAppId);
            if (result != null && result.getActivitySort() >= sort) {
                sort = result.getActivitySort() + 1000000L;
            }
            ReqActivitySort reqActivitySort = new ReqActivitySort();
            reqActivitySort.setAppId(activityAppId);
            List<ActivitySortDto> existList = this.activitySortService.selectByCondition(reqActivitySort);
            HashMap<String, Long> map = new HashMap<String, Long>(existList.size());
            for (ActivitySortDto activitySortDto : existList) {
                map.put(activitySortDto.getActivityId() + activitySortDto.getActivityType().toString(), activitySortDto.getActivitySort());
            }
            List<ActivityDto> activityDtoList = this.activityService.selectByActivityIds(CollectionUtil.getFieldList(idAndTypes, (String)"id"));
            ArrayList<ActivitySortDto> activitySortDtoList = new ArrayList<ActivitySortDto>();
            for (ActivityDto activityDto : activityDtoList) {
                ReqIdAndType reqIdAndType = new ReqIdAndType();
                reqIdAndType.setId(activityDto.getActivityId());
                reqIdAndType.setType(activityDto.getActivityType());
                if (map.get(activityDto.getActivityId() + activityDto.getActivityType().toString()) != null || !this.contain(idAndTypes, reqIdAndType)) continue;
                ActivitySortDto activitySortDto = new ActivitySortDto();
                activitySortDto.setActivityAppId(activityAppId);
                activitySortDto.setActivityType(activityDto.getActivityType());
                activitySortDto.setActivityId(activityDto.getActivityId());
                activitySortDto.setActivitySort(sort);
                sort = sort + 1000000L;
                activitySortDtoList.add(activitySortDto);
            }
            if (activitySortDtoList.size() > 0) {
                this.activitySortService.insertBatchActivitySort(activitySortDtoList);
            }
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendServiceImpl.addActivitySort is error");
            return this.exceptionFailure(e);
        }
    }

    public synchronized DubboResult<Boolean> addDefaultActivitySort(Long activityAppId) {
        try {
            Long sort = new Date().getTime();
            ActivitySortDto result = this.activitySortService.getMaxSortValueActivitySortDto(activityAppId);
            if (result != null && result.getActivitySort() >= sort) {
                sort = result.getActivitySort() + 1000000L;
            }
            ReqActivitySort reqActivitySort = new ReqActivitySort();
            reqActivitySort.setAppId(activityAppId);
            List<ActivitySortDto> existList = this.activitySortService.selectByCondition(reqActivitySort);
            HashMap<String, Long> map = new HashMap<String, Long>(existList.size());
            for (ActivitySortDto activitySortDto : existList) {
                map.put(activitySortDto.getActivityId() + activitySortDto.getActivityType().toString(), activitySortDto.getActivitySort());
            }
            ReqActivitySort condition = new ReqActivitySort();
            condition.setAppId(Long.valueOf(0L));
            condition.setSort("activity_sort asc,gmt_modified desc");
            List<ActivitySortDto> needList = this.activitySortService.selectByCondition(condition);
            ArrayList<ActivitySortDto> activitySortDtoList = new ArrayList<ActivitySortDto>();
            for (ActivitySortDto activitySortDto : needList) {
                ReqIdAndType reqIdAndType = new ReqIdAndType();
                reqIdAndType.setId(activitySortDto.getActivityId());
                reqIdAndType.setType(activitySortDto.getActivityType());
                if (map.get(activitySortDto.getActivityId() + activitySortDto.getActivityType().toString()) != null) continue;
                ActivitySortDto sortDto = new ActivitySortDto();
                sortDto.setActivityAppId(activityAppId);
                sortDto.setActivityType(activitySortDto.getActivityType());
                sortDto.setActivityId(activitySortDto.getActivityId());
                sortDto.setActivitySort(sort);
                sort = sort + 1000000L;
                activitySortDtoList.add(sortDto);
            }
            if (activitySortDtoList.size() > 0) {
                this.activitySortService.insertBatchActivitySort(activitySortDtoList);
            }
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendServiceImpl.addDefaultActivitySort is error");
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> removeActivity(Long activityAppId, Long activityId, Integer activityType) {
        try {
            return DubboResult.successResult((Object)this.activitySortService.deleteActivity(activityAppId, activityId, activityType));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendServiceImpl.getByCondition is error");
            return this.exceptionFailure(e);
        }
    }

    public synchronized DubboResult<Boolean> sort(Long activityAppId, Long activityId, Integer activityType, int location) {
        try {
            return DubboResult.successResult((Object)this.activitySortService.sort(activityAppId, activityId, activityType, location));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendServiceImpl.sort is error");
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<RspActivityDto>> getActivityByApp(Long appId) {
        try {
            List<ActivitySortDto> list = this.activitySortService.getActivityForRecommendByApp(appId);
            ArrayList<RspActivityDto> result = new ArrayList<RspActivityDto>();
            if (!list.isEmpty()) {
                for (ActivitySortDto activitySortDto : list) {
                    RspActivityDto rspActivityDto = new RspActivityDto();
                    rspActivityDto.setId(activitySortDto.getActivityId());
                    rspActivityDto.setName(activitySortDto.getActivityName());
                    rspActivityDto.setType(activitySortDto.getActivityType());
                    result.add(rspActivityDto);
                }
            }
            return DubboResult.successResult(result);
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendServiceImpl.getActivityMapByApp is error");
            return this.exceptionFailure(e);
        }
    }

    private boolean contain(List<ReqIdAndType> reqIdAndTypeList, ReqIdAndType reqIdAndType) {
        for (ReqIdAndType idAndType : reqIdAndTypeList) {
            if (!idAndType.getId().equals(reqIdAndType.getId()) || !idAndType.getType().equals(reqIdAndType.getType())) continue;
            return true;
        }
        return false;
    }
}

