/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.tuia.media.api.dto.req.ReqActivitySort;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivityDAO;
import cn.com.duiba.tuia.media.dao.ActivitySortDAO;
import cn.com.duiba.tuia.media.domain.ActivitySortDto;
import cn.com.duiba.tuia.media.service.ActivitySortService;
import com.google.common.collect.Lists;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class ActivitySortServiceImpl
implements ActivitySortService {
    private static final long TIME_DIFFER = 1000000L;
    @Autowired
    private ActivitySortDAO activitySortDAO;
    @Autowired
    private ActivityDAO activityDAO;

    @Override
    public boolean insertBatchActivitySort(List<ActivitySortDto> activitySortDtoList) throws TuiaMediaException {
        return this.activitySortDAO.insertBatch(activitySortDtoList) > 0;
    }

    @Override
    public List<ActivitySortDto> selectByCondition(ReqActivitySort reqActivitySort) throws TuiaMediaException {
        if (!StringUtils.isEmpty((Object)reqActivitySort.getName()) || reqActivitySort.getType() != null) {
            List<Long> ids = this.activityDAO.selectByTypeAndName(reqActivitySort.getName(), reqActivitySort.getType());
            if (!ids.isEmpty()) {
                reqActivitySort.setActivityIds(ids);
            } else {
                reqActivitySort.setActivityIds((List)Lists.newArrayList((Object[])new Long[]{0L}));
            }
        }
        return this.activitySortDAO.selectByCondition(reqActivitySort);
    }

    @Override
    public int selectByConditionAmount(ReqActivitySort reqActivitySort) throws TuiaMediaException {
        return this.activitySortDAO.selectByConditionAmount(reqActivitySort);
    }

    @Override
    @Transactional
    public boolean deleteActivity(Long activityAppId, Long activityId, Integer activityType) throws TuiaMediaException {
        Long actAppId = activityAppId;
        if (actAppId == null || activityId == null || activityType == null) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        if (actAppId.equals(0L)) {
            actAppId = null;
        }
        return this.activitySortDAO.deleteActivity(actAppId, activityId, activityType) > 0;
    }

    @Override
    public ActivitySortDto getMaxSortValueActivitySortDto(Long activityAppId) throws TuiaMediaException {
        if (activityAppId == null) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        ReqActivitySort reqActivitySort = new ReqActivitySort();
        reqActivitySort.setAppId(activityAppId);
        reqActivitySort.setSort("activity_sort desc,gmt_modified asc");
        reqActivitySort.setRowStart(0);
        reqActivitySort.setPageSize(Integer.valueOf(1));
        List<ActivitySortDto> result = this.activitySortDAO.selectByCondition(reqActivitySort);
        if (result.isEmpty()) {
            return null;
        }
        return result.get(0);
    }

    @Override
    public boolean sort(Long activityAppId, Long activityId, Integer activityType, int location) throws TuiaMediaException {
        if (activityAppId == null || activityId == null || location <= 0) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        if (location == 1) {
            ActivitySortDto firstSortActivity = this.getFirstSortActivity(activityAppId);
            if (firstSortActivity.getActivityId() == activityId) {
                return true;
            }
            ReqActivitySort reqActivitySort = new ReqActivitySort();
            reqActivitySort.setAppId(activityAppId);
            reqActivitySort.setId(activityId);
            List<ActivitySortDto> result = this.activitySortDAO.selectByCondition(reqActivitySort);
            if (result.isEmpty()) {
                throw new TuiaMediaException(ErrorCode.E0501001);
            }
            ActivitySortDto activitySortDto = result.get(0);
            activitySortDto.setActivitySort(firstSortActivity.getActivitySort() - 1000000L);
            this.activitySortDAO.update(activitySortDto);
            return true;
        }
        List<ActivitySortDto> result = this.getLocationSortActivity(activityAppId, location);
        if (result.size() < 2) {
            throw new TuiaMediaException(ErrorCode.E0501002);
        }
        ReqActivitySort reqActivitySort = new ReqActivitySort();
        reqActivitySort.setAppId(activityAppId);
        reqActivitySort.setId(activityId);
        reqActivitySort.setType(activityType);
        List<ActivitySortDto> rst = this.activitySortDAO.selectByCondition(reqActivitySort);
        if (rst.isEmpty()) {
            throw new TuiaMediaException(ErrorCode.E0501001);
        }
        ActivitySortDto activitySortDto = rst.get(0);
        if (result.get(1).getActivitySort().equals(activitySortDto.getActivitySort()) && result.get(1).getActivityType().equals(activitySortDto.getActivityType())) {
            return true;
        }
        if (result.get(0).getActivitySort().equals(activitySortDto.getActivitySort()) && result.get(0).getActivityType().equals(activitySortDto.getActivityType())) {
            if (result.size() == 2) {
                activitySortDto.setActivitySort(result.get(1).getActivitySort() + 1000000L);
            } else {
                activitySortDto.setActivitySort((result.get(1).getActivitySort() + result.get(2).getActivitySort()) / 2L);
            }
        } else if (result.size() == 2) {
            if (activitySortDto.getActivitySort() < result.get(1).getActivitySort()) {
                activitySortDto.setActivitySort(result.get(1).getActivitySort() + 1000000L);
            } else {
                activitySortDto.setActivitySort(result.get(1).getActivitySort() - 1000000L);
            }
        } else if (activitySortDto.getActivitySort() < result.get(2).getActivitySort()) {
            activitySortDto.setActivitySort((result.get(1).getActivitySort() + result.get(2).getActivitySort()) / 2L);
        } else {
            activitySortDto.setActivitySort((result.get(0).getActivitySort() + result.get(1).getActivitySort()) / 2L);
        }
        this.activitySortDAO.update(activitySortDto);
        return true;
    }

    @Override
    public List<ActivitySortDto> getActivityForRecommendByApp(Long appId) throws TuiaMediaException {
        if (appId == null) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        return this.activitySortDAO.getActivityForRecommend(appId);
    }

    private ActivitySortDto getFirstSortActivity(Long activityAppId) throws TuiaMediaException {
        ReqActivitySort reqActivitySort = new ReqActivitySort();
        reqActivitySort.setAppId(activityAppId);
        reqActivitySort.setRowStart(0);
        reqActivitySort.setPageSize(Integer.valueOf(1));
        reqActivitySort.setSort("activity_sort asc,gmt_modified desc");
        List<ActivitySortDto> result = this.activitySortDAO.selectByCondition(reqActivitySort);
        if (!result.isEmpty()) {
            return result.get(0);
        }
        return null;
    }

    private List<ActivitySortDto> getLocationSortActivity(Long activityAppId, int location) throws TuiaMediaException {
        ReqActivitySort reqActivitySort = new ReqActivitySort();
        reqActivitySort.setAppId(activityAppId);
        reqActivitySort.setRowStart(location - 2);
        reqActivitySort.setPageSize(Integer.valueOf(3));
        reqActivitySort.setSort("activity_sort asc,gmt_modified desc");
        return this.activitySortDAO.selectByCondition(reqActivitySort);
    }
}

