/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jni;

public final class SSLExt {
    public static final int SSL_MODE_ENABLE_PARTIAL_WRITE = 1;
    public static final int SSL_MODE_ACCEPT_MOVING_WRITE_BUFFER = 2;
    static final int SSL_MODE_NO_AUTO_CHAIN = 8;
    public static final int SSL_MODE_RELEASE_BUFFERS = 16;

    public static native int setNPN(long var0, byte[] var2, int var3);

    public static native int getNPN(long var0, byte[] var2);

    public static native int debug(long var0);

    public static native byte[] getSessionData(long var0);

    public static native int setSessionData(long var0, byte[] var2, int var3);

    public static native int getTicket(long var0, byte[] var2);

    public static native int setTicket(long var0, byte[] var2, int var3);

    public static native int setTicketKeys(long var0, byte[] var2, int var3);

    public static native int setSNI(long var0, byte[] var2, int var3);

    public static native String sslErrReasonErrorString();

    public static native long sslCtxSetMode(long var0, long var2);

    public static native long sslSetMode(long var0, long var2);

    public static int setNPN(long sslContext, byte[] spdyNPN) {
        try {
            return SSLExt.setNPN(sslContext, spdyNPN, spdyNPN.length);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return -1;
        }
    }

    public static boolean checkNPN(long tcsocket, byte[] expected) {
        byte[] npn = new byte[expected.length + 1];
        int npnLen = 0;
        try {
            npnLen = SSLExt.getNPN(tcsocket, npn);
            if (npnLen != expected.length) {
                return false;
            }
        }
        catch (Throwable t) {
            return false;
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == npn[i]) continue;
            return false;
        }
        return true;
    }
}

