/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.web.controller;

import cn.com.duiba.tuia.media.api.dto.req.ReqAccountChange;
import cn.com.duiba.tuia.media.api.dto.rsp.AccountChangeRsp;
import cn.com.duiba.tuia.media.api.dto.rsp.RspAccountChangeResult;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteAccountChangeBackendService;
import cn.com.duiba.tuia.media.model.Result;
import cn.com.duiba.tuia.media.service.AccountChangeService;
import cn.com.duiba.tuia.media.utils.RequestLocal;
import cn.com.duiba.tuia.media.web.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/accountChange"})
@Api(value="\u8d26\u6237\u8d44\u91d1\u6d41\u6c34\u76f8\u5173api")
public class AccountChangeController
extends BaseController {
    private static final String YYYY_MM = "yyyy-MM";
    @Autowired
    private AccountChangeService accountChangeService;
    @Autowired
    private RemoteAccountChangeBackendService remoteAccountChangeBackendService;

    @ApiOperation(value="\u67e5\u8be2\u8d44\u91d1\u6d41\u6c34\u5217\u8868", httpMethod="GET", notes="\u67e5\u8be2\u8d44\u91d1\u6d41\u6c34\u5217\u8868")
    @ResponseBody
    @RequestMapping(value={"/getAccoutChangeList"}, method={RequestMethod.GET})
    public Result<RspAccountChangeResult<AccountChangeRsp>> getAccoutChangeList(@Valid @ModelAttribute ReqAccountChange req, BindingResult result) {
        try {
            this.checkParam(result);
            Long cid = RequestLocal.get().getCid();
            req.setEndDate(new DateTime((Object)req.getEndDate()).millisOfDay().withMaximumValue().toString("yyyy-MM-dd HH:mm:ss"));
            req.setMediaId(cid);
            req.setPageSize(Integer.valueOf(req.getPageSize() == null ? 50 : req.getPageSize()));
            req.setRowStart((req.getCurrentPage() - 1) * req.getPageSize());
            return this.successResult(this.accountChangeService.selectAccountChangeList(req));
        }
        catch (Exception e) {
            this.logger.error("AccountChangeController.getAccoutChangeList error!,the param=[{}]", (Object)req);
            return this.failResult(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u8d44\u91d1\u6d41\u6c34\u62a5\u8868\u5bfc\u51fa\u63a5\u53e3", httpMethod="GET")
    @ResponseBody
    @RequestMapping(value={"/exportReport"}, method={RequestMethod.GET})
    public void exportReport(@Valid @ModelAttribute ReqAccountChange req, HttpServletResponse response) {
        ServletOutputStream out = null;
        try {
            Long cid = RequestLocal.get().getCid();
            req.setMediaId(cid);
            req.setPageSize(Integer.valueOf(-1));
            this.setExportResponse(this.buildExportFile(new DateTime((Object)req.getStartDate()).toString(YYYY_MM), "-" + new DateTime((Object)req.getEndDate()).toString(YYYY_MM) + "_\u8d44\u91d1\u6d41\u6c34\u62a5\u8868\u6570\u636e"), response);
            out = response.getOutputStream();
            req.setEndDate(new DateTime((Object)req.getEndDate()).millisOfDay().withMaximumValue().toString("yyyy-MM-dd HH:mm:ss"));
            this.remoteAccountChangeBackendService.exportAccountChange(req, (OutputStream)out);
            this.successResult(true);
            this.closeOutputStream((OutputStream)out);
        }
        catch (Exception e) {
            this.logger.error("AccountChangeController.exportReport error!,the req=[{}]", (Object)req);
            this.failResult(e);
        }
        finally {
            this.closeOutputStream((OutputStream)out);
        }
    }

    private String buildExportFile(String currentDate, String title) {
        StringBuilder builder = new StringBuilder();
        builder.append(currentDate);
        builder.append(title);
        return builder.toString();
    }

    private void setExportResponse(String fileName, HttpServletResponse response) throws UnsupportedEncodingException {
        response.setContentType("text/csv");
        response.setContentType("application/csv;charset=UTF-8");
        response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName, "UTF-8") + ".csv");
    }

    private void closeOutputStream(OutputStream out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException e) {
            this.logger.error("close OutputStream failed", (Throwable)e);
        }
    }
}

