/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.web.filter;

import cn.com.duiba.tuia.media.api.dto.AccountDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.common.tool.RequestTool;
import cn.com.duiba.tuia.media.common.tool.TimeProfileTool;
import cn.com.duiba.tuia.media.common.utils.AjaxUtils;
import cn.com.duiba.tuia.media.service.AccountService;
import cn.com.duiba.tuia.media.service.BaseService;
import cn.com.duiba.tuia.media.utils.CookieUtil;
import cn.com.duiba.tuia.media.utils.RequestLocal;
import cn.com.duiba.tuia.media.utils.ResultUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="loginFilter")
public class LoginFilter
extends BaseService
implements Filter {
    private Logger log = LoggerFactory.getLogger(LoginFilter.class);
    private static List<String> notCheckUrlList = new ArrayList<String>();
    @Autowired
    private AccountService accountService;

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        TimeProfileTool.enter((String)"loginFilter.doFilter");
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        RequestTool.setRequestInThreadLocal((HttpServletRequest)request);
        RequestLocal.clear();
        RequestLocal.get().setRequest(request);
        RequestLocal.get().setResponse(response);
        this.doCheckPath(request, response);
        chain.doFilter(req, resp);
        TimeProfileTool.release();
    }

    private void doCheckPath(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Long cid = RequestLocal.get().getCid();
        String path = request.getServletPath();
        if (!(path.startsWith("/webjars") || path.startsWith("/swagger") || notCheckUrlList.contains(path))) {
            if (cid != null) {
                if ("/account/login".equals(path) || "/account/register".equals(path)) {
                    this.log.error("please enter the home page! the url is:" + path);
                    response.sendRedirect("/#/private");
                }
                try {
                    this.accountStatusAuth(cid);
                }
                catch (TuiaMediaException e) {
                    CookieUtil.deleteCookie((String)"dataxyz345");
                    this.log.error("please login again! the url is:" + path);
                    this.exceptionFailure(response, (Exception)((Object)e));
                }
            } else if ("/private".equals(path)) {
                response.sendRedirect("/#/signin");
            } else if (!notCheckUrlList.contains(path)) {
                this.log.error("please login again! the url is:" + path);
                AjaxUtils.renderJson((HttpServletResponse)response, (Object)ResultUtil.fail((ErrorCode)ErrorCode.E9999998), (String[])new String[0]);
            }
        }
    }

    private void accountStatusAuth(long mediaId) throws TuiaMediaException {
        AccountDto accountDto = this.accountService.selectByIdNotNull(Long.valueOf(mediaId));
        this.doCheckAudit(accountDto.getCheckStatus());
        this.doCheckFreeze(accountDto.getFreezeStatus());
    }

    private void doCheckFreeze(Integer freezeStatus) throws TuiaMediaException {
        if (1 == freezeStatus) {
            this.logger.error("the account is freeze, the freeze status=[{}]", (Object)freezeStatus);
            throw new TuiaMediaException(ErrorCode.E0102004);
        }
        if (0 != freezeStatus) {
            this.logger.error("the account freeze status is illegal,  the freeze status=[{}]", (Object)freezeStatus);
            throw new TuiaMediaException(ErrorCode.E0102005);
        }
    }

    private void doCheckAudit(Integer auditStatus) throws TuiaMediaException {
        if (0 == auditStatus) {
            this.logger.error("user account in review status, the audit status=[{}]", (Object)auditStatus);
            throw new TuiaMediaException(ErrorCode.E0102006);
        }
        if (2 == auditStatus) {
            this.logger.error("user account in refuse status, the audit status=[{}]", (Object)auditStatus);
            throw new TuiaMediaException(ErrorCode.E0102007);
        }
        if (1 != auditStatus) {
            this.logger.error("the account status is illegal, the audit status=[{}]", (Object)auditStatus);
            throw new TuiaMediaException(ErrorCode.E0102008);
        }
    }

    public void exceptionFailure(HttpServletResponse response, Exception e) {
        if (e instanceof TuiaMediaException) {
            AjaxUtils.renderJson((HttpServletResponse)response, (Object)ResultUtil.fail((String)((TuiaMediaException)((Object)e)).getResultCode(), (String)((TuiaMediaException)((Object)e)).getResultMessage()), (String[])new String[0]);
        } else {
            this.log.error("\u7cfb\u7edf\u9519\u8bef", (Throwable)e);
            AjaxUtils.renderJson((HttpServletResponse)response, (Object)ResultUtil.fail((ErrorCode)ErrorCode.E9999999), (String[])new String[0]);
        }
    }

    public void init(FilterConfig fc) throws ServletException {
        notCheckUrlList.add("/");
        notCheckUrlList.add("/private");
        notCheckUrlList.add("/index.html");
        notCheckUrlList.add("/favicon.ico");
        notCheckUrlList.add("/#/signin");
        notCheckUrlList.add("/private#/404");
        notCheckUrlList.add("/__webpack_hmr");
        notCheckUrlList.add("/swagger-ui.html");
        notCheckUrlList.add("/images/favicon-16x16.png");
        notCheckUrlList.add("/swagger-resources");
        notCheckUrlList.add("/v2/api-docs");
        notCheckUrlList.add("/images/favicon-32x32.png");
        notCheckUrlList.add("/images/favicon-16x16.png");
        notCheckUrlList.add("/configuration/security");
        notCheckUrlList.add("/configuration/ui");
        notCheckUrlList.add("/upload/index");
        notCheckUrlList.add("/account/resetPasswd/redirect");
        notCheckUrlList.add("/account/sendResetPasswdEmail");
        notCheckUrlList.add("/account/resetPasswd");
        notCheckUrlList.add("/account/isExists");
        notCheckUrlList.add("/account/isExistPhone");
        notCheckUrlList.add("/account/register");
        notCheckUrlList.add("/account/login");
        notCheckUrlList.add("/account/verifyEmail");
        notCheckUrlList.add("/account/repeatVerifyEmail");
        notCheckUrlList.add("/account/updateAuditData");
        notCheckUrlList.add("/account/getUncheckAccount");
        notCheckUrlList.add("/account/sendResetPdEmail");
        notCheckUrlList.add("/account/verifyResetPdCode");
        notCheckUrlList.add("/account/resetPassword");
        notCheckUrlList.add("/account/logout");
        notCheckUrlList.add("/sms/send");
        notCheckUrlList.add("/sms/verify");
        notCheckUrlList.add("/remoteTest/getListDetail");
        notCheckUrlList.add("/remoteTest/updateBatchSlotCache");
        notCheckUrlList.add("/remoteTest/updateStrategy");
        notCheckUrlList.add("/remoteTest/getSlot");
        notCheckUrlList.add("/remoteTest/updateSlot");
        notCheckUrlList.add("/remoteTest/getStrategy");
        notCheckUrlList.add("/remoteTest/isValidMediaApp");
        notCheckUrlList.add("/remoteTest/getMediaApp");
    }

    public void destroy() {
        this.log.info(" LoginFilter.destroy ");
    }
}

