/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.top.link.endpoint;

import com.taobao.top.link.DefaultLoggerFactory;
import com.taobao.top.link.LinkException;
import com.taobao.top.link.Logger;
import com.taobao.top.link.LoggerFactory;
import com.taobao.top.link.Text;
import com.taobao.top.link.channel.ChannelException;
import com.taobao.top.link.channel.ChannelSender;
import com.taobao.top.link.channel.ClientChannelSelector;
import com.taobao.top.link.channel.ClientChannelSharedSelector;
import com.taobao.top.link.channel.ServerChannel;
import com.taobao.top.link.endpoint.ClientChannelWrapper;
import com.taobao.top.link.endpoint.EndpointChannelHandler;
import com.taobao.top.link.endpoint.EndpointProxy;
import com.taobao.top.link.endpoint.Identity;
import com.taobao.top.link.endpoint.Message;
import com.taobao.top.link.endpoint.MessageHandler;
import com.taobao.top.link.endpoint.SendCallback;
import com.taobao.top.link.schedule.Scheduler;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Endpoint {
    protected static int TIMOUT = 5000;
    private Logger logger;
    private Identity identity;
    private List<ServerChannel> serverChannels = new ArrayList<ServerChannel>();
    private ClientChannelSelector channelSelector;
    private EndpointChannelHandler channelHandler;
    private MessageHandler messageHandler;
    private List<EndpointProxy> connected = new ArrayList<EndpointProxy>();

    public Endpoint(Identity identity) {
        this(DefaultLoggerFactory.getDefault(), identity);
    }

    public Endpoint(LoggerFactory loggerFactory, Identity identity) {
        this.logger = loggerFactory.create(this);
        this.identity = identity;
        this.setClientChannelSelector(new ClientChannelSharedSelector(loggerFactory));
        this.setChannelHandler(new EndpointChannelHandler(loggerFactory));
        if (this.identity == null) {
            throw new NullPointerException("identity");
        }
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public void setMessageHandler(MessageHandler handler) {
        this.messageHandler = handler;
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public void setChannelHandler(EndpointChannelHandler channelHandler) {
        this.channelHandler = channelHandler;
        this.channelHandler.setEndpoint(this);
        for (ServerChannel channel : this.serverChannels) {
            channel.setChannelHandler(this.channelHandler);
        }
    }

    public void setClientChannelSelector(ClientChannelSelector selector) {
        this.channelSelector = selector;
    }

    public void setScheduler(Scheduler<Identity> scheduler) {
        this.channelHandler.setScheduler(scheduler);
    }

    public void bind(ServerChannel channel) {
        channel.setChannelHandler(this.channelHandler);
        channel.run();
        this.serverChannels.add(channel);
    }

    public void unbindAll() {
        for (ServerChannel channel : this.serverChannels) {
            try {
                channel.stop();
            }
            catch (Exception e) {
                this.logger.error(Text.E_UNBIND_ERROR, e);
            }
        }
        this.serverChannels.clear();
    }

    public Iterator<EndpointProxy> getConnected() {
        return this.connected.iterator();
    }

    public synchronized EndpointProxy getEndpoint(Identity target, URI uri) throws LinkException {
        return this.getEndpoint(target, uri, null);
    }

    public synchronized EndpointProxy getEndpoint(Identity target, URI uri, Map<String, Object> extras) throws LinkException {
        Message msg = new Message();
        msg.messageType = 0;
        HashMap<String, Object> content = new HashMap<String, Object>();
        this.identity.render(content);
        if (extras != null) {
            content.putAll(extras);
        }
        msg.content = content;
        EndpointProxy e = this.getEndpoint(target);
        e.remove(uri);
        ClientChannelWrapper channel = new ClientChannelWrapper(this.channelSelector.getChannel(uri), msg.protocolVersion);
        channel.setChannelHandler(this.channelHandler);
        this.sendAndWait(e, channel, msg, TIMOUT);
        e.add(channel);
        return e;
    }

    public synchronized EndpointProxy getEndpoint(Identity target) throws LinkException {
        if (target.equals(this.identity)) {
            throw new LinkException(Text.E_ID_DUPLICATE);
        }
        for (EndpointProxy e : this.connected) {
            if (e.getIdentity() == null || !e.getIdentity().equals(target)) continue;
            return e;
        }
        EndpointProxy e = this.createProxy(target.toString());
        e.setIdentity(target);
        return e;
    }

    protected void send(ChannelSender sender, Message message) throws ChannelException {
        this.channelHandler.pending(message, sender);
    }

    protected boolean sendSync(ChannelSender sender, Message message, int timeout) throws ChannelException {
        return this.channelHandler.flush(message, sender, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> sendAndWait(EndpointProxy e, ChannelSender sender, Message message, int timeout) throws LinkException {
        SendCallback callback = new SendCallback(e);
        this.channelHandler.pending(message, sender, callback);
        try {
            callback.waitReturn(timeout);
        }
        finally {
            this.channelHandler.cancel(callback);
        }
        if (callback.getError() != null) {
            throw callback.getError();
        }
        return callback.getReturn();
    }

    private EndpointProxy createProxy(String reason) {
        EndpointProxy e = new EndpointProxy(this);
        this.connected.add(e);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Text.E_CREATE_NEW + ": " + reason);
        }
        return e;
    }
}

