/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j;

import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.CDATA;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.InvalidXPathException;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.NodeFilter;
import org.dom4j.ProcessingInstruction;
import org.dom4j.QName;
import org.dom4j.Text;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;
import org.dom4j.rule.Pattern;
import org.jaxen.VariableContext;

public class DocumentHelper {
    public static Attribute createAttribute(Element owner, String name, String value) {
        return DocumentFactory.getInstance().createAttribute(owner, name, value);
    }

    public static Attribute createAttribute(Element owner, QName qname, String value) {
        return DocumentFactory.getInstance().createAttribute(owner, qname, value);
    }

    public static CDATA createCDATA(String text) {
        return DocumentFactory.getInstance().createCDATA(text);
    }

    public static Comment createComment(String text) {
        return DocumentFactory.getInstance().createComment(text);
    }

    public static Document createDocument() {
        return DocumentFactory.getInstance().createDocument();
    }

    public static Document createDocument(Element rootElement) {
        return DocumentFactory.getInstance().createDocument(rootElement);
    }

    public static Element createElement(String name) {
        return DocumentFactory.getInstance().createElement(name);
    }

    public static Element createElement(QName qname) {
        return DocumentFactory.getInstance().createElement(qname);
    }

    public static Entity createEntity(String name, String text) {
        return DocumentFactory.getInstance().createEntity(name, text);
    }

    public static Namespace createNamespace(String prefix, String uri) {
        return DocumentFactory.getInstance().createNamespace(prefix, uri);
    }

    public static Pattern createPattern(String xpathPattern) {
        return DocumentFactory.getInstance().createPattern(xpathPattern);
    }

    public static ProcessingInstruction createProcessingInstruction(String target, String data) {
        return DocumentFactory.getInstance().createProcessingInstruction(target, data);
    }

    public static ProcessingInstruction createProcessingInstruction(String target, Map data) {
        return DocumentFactory.getInstance().createProcessingInstruction(target, data);
    }

    public static QName createQName(String localName) {
        return DocumentFactory.getInstance().createQName(localName);
    }

    public static QName createQName(String localName, Namespace namespace) {
        return DocumentFactory.getInstance().createQName(localName, namespace);
    }

    public static Text createText(String text) {
        return DocumentFactory.getInstance().createText(text);
    }

    public static XPath createXPath(String xpathExpression) throws InvalidXPathException {
        return DocumentFactory.getInstance().createXPath(xpathExpression);
    }

    public static XPath createXPath(String xpathExpression, VariableContext variableContext) throws InvalidXPathException {
        return DocumentFactory.getInstance().createXPath(xpathExpression, variableContext);
    }

    public static NodeFilter createXPathFilter(String xpathFilterExpression) {
        return DocumentFactory.getInstance().createXPathFilter(xpathFilterExpression);
    }

    public static Element makeElement(Branch source, String path) {
        String name;
        Element parent;
        StringTokenizer stringTokenizer = new StringTokenizer(path, "/");
        if (source instanceof Document) {
            Document document = (Document)source;
            parent = document.getRootElement();
            name = stringTokenizer.nextToken();
            if (parent == null) {
                parent = document.addElement(name);
            }
        } else {
            parent = (Element)source;
        }
        Element element = null;
        while (stringTokenizer.hasMoreTokens()) {
            name = stringTokenizer.nextToken();
            element = name.indexOf(58) > 0 ? parent.element(parent.getQName(name)) : parent.element(name);
            if (element == null) {
                element = parent.addElement(name);
            }
            parent = element;
        }
        return element;
    }

    public static Document parseText(String text) throws DocumentException {
        SAXReader reader = new SAXReader();
        return reader.read(new StringReader(text));
    }

    public static List selectNodes(String xpathFilterExpression, List nodes) {
        XPath xpath = DocumentHelper.createXPath(xpathFilterExpression);
        return xpath.selectNodes(nodes);
    }

    public static List selectNodes(String xpathFilterExpression, Node node) {
        XPath xpath = DocumentHelper.createXPath(xpathFilterExpression);
        return xpath.selectNodes(node);
    }

    public static void sort(List list, String xpathExpression) {
        XPath xpath = DocumentHelper.createXPath(xpathExpression);
        xpath.sort(list);
    }

    public static void sort(List list, String xpathExpression, boolean distinct) {
        XPath xpath = DocumentHelper.createXPath(xpathExpression);
        xpath.sort(list, distinct);
    }
}

