/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.core;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.target.EmptyTargetSource;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.Factory;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.objenesis.ObjenesisStd;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class DummyInvocationUtils {
    private static ObjenesisStd OBJENESIS = new ObjenesisStd();

    public static <T> T methodOn(Class<T> type, Object ... parameters) {
        Assert.notNull(type, (String)"Given type must not be null!");
        InvocationRecordingMethodInterceptor interceptor = new InvocationRecordingMethodInterceptor(type, parameters);
        return DummyInvocationUtils.getProxyWithInterceptor(type, interceptor, type.getClassLoader());
    }

    private static <T> T getProxyWithInterceptor(Class<?> type, InvocationRecordingMethodInterceptor interceptor, ClassLoader classLoader) {
        if (type.isInterface()) {
            ProxyFactory factory = new ProxyFactory((Object)EmptyTargetSource.INSTANCE);
            factory.addInterface(type);
            factory.addInterface(LastInvocationAware.class);
            factory.addAdvice((Advice)interceptor);
            return (T)factory.getProxy();
        }
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(type);
        enhancer.setInterfaces(new Class[]{LastInvocationAware.class});
        enhancer.setCallbackType(MethodInterceptor.class);
        enhancer.setClassLoader(classLoader);
        Factory factory = (Factory)OBJENESIS.newInstance(enhancer.createClass());
        factory.setCallbacks(new Callback[]{interceptor});
        return (T)factory;
    }

    static class SimpleMethodInvocation
    implements MethodInvocation {
        private final Class<?> targetType;
        private final Method method;
        private final Object[] arguments;

        private SimpleMethodInvocation(Class<?> targetType, Method method, Object[] arguments) {
            this.targetType = targetType;
            this.arguments = arguments;
            this.method = method;
        }

        @Override
        public Class<?> getTargetType() {
            return this.targetType;
        }

        @Override
        public Object[] getArguments() {
            return this.arguments;
        }

        @Override
        public Method getMethod() {
            return this.method;
        }
    }

    public static interface MethodInvocation {
        public Object[] getArguments();

        public Method getMethod();

        public Class<?> getTargetType();
    }

    private static class InvocationRecordingMethodInterceptor
    implements org.aopalliance.intercept.MethodInterceptor,
    LastInvocationAware,
    MethodInterceptor {
        private static final Method GET_INVOCATIONS = ReflectionUtils.findMethod(LastInvocationAware.class, (String)"getLastInvocation");
        private static final Method GET_OBJECT_PARAMETERS = ReflectionUtils.findMethod(LastInvocationAware.class, (String)"getObjectParameters");
        private final Class<?> targetType;
        private final Object[] objectParameters;
        private MethodInvocation invocation;

        public InvocationRecordingMethodInterceptor(Class<?> targetType, Object ... parameters) {
            this.targetType = targetType;
            this.objectParameters = (Object[])parameters.clone();
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) {
            if (GET_INVOCATIONS.equals(method)) {
                return this.getLastInvocation();
            }
            if (GET_OBJECT_PARAMETERS.equals(method)) {
                return this.getObjectParameters();
            }
            if (Object.class.equals(method.getDeclaringClass())) {
                return ReflectionUtils.invokeMethod((Method)method, (Object)obj, (Object[])args);
            }
            this.invocation = new SimpleMethodInvocation(this.targetType, method, args);
            Class<?> returnType = method.getReturnType();
            return returnType.cast(DummyInvocationUtils.getProxyWithInterceptor(returnType, this, obj.getClass().getClassLoader()));
        }

        public Object invoke(org.aopalliance.intercept.MethodInvocation invocation) throws Throwable {
            return this.intercept(invocation.getThis(), invocation.getMethod(), invocation.getArguments(), null);
        }

        @Override
        public MethodInvocation getLastInvocation() {
            return this.invocation;
        }

        @Override
        public Iterator<Object> getObjectParameters() {
            return Arrays.asList(this.objectParameters).iterator();
        }
    }

    public static interface LastInvocationAware {
        public Iterator<Object> getObjectParameters();

        public MethodInvocation getLastInvocation();
    }
}

