/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.web.controller;

import cn.com.duiba.tuia.media.api.dto.SlotTypeParamDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqUpdateSlot;
import cn.com.duiba.tuia.media.api.dto.rsp.RspSlotDetailDto;
import cn.com.duiba.tuia.media.bo.SlotBackendBo;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.constants.InformationStreamPictureSizeEnmu;
import cn.com.duiba.tuia.media.common.constants.SlotPictureSizeEnmu;
import cn.com.duiba.tuia.media.common.constants.UserDefinedPictureSizeEnmu;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.model.Result;
import cn.com.duiba.tuia.media.model.req.ReqCreateSlot;
import cn.com.duiba.tuia.media.model.req.ReqEditSlotEnableStatus;
import cn.com.duiba.tuia.media.model.req.ReqSlotList;
import cn.com.duiba.tuia.media.model.rsp.RspPageResult;
import cn.com.duiba.tuia.media.model.rsp.RspSlot;
import cn.com.duiba.tuia.media.service.SlotService;
import cn.com.duiba.tuia.media.utils.RequestLocal;
import cn.com.duiba.tuia.media.web.aop.LogWrite;
import cn.com.duiba.tuia.media.web.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/slot"})
@Api(value="\u5e7f\u544a\u4f4d\u76f8\u5173\u63a5\u53e3")
public class SlotController
extends BaseController {
    @Autowired
    private SlotService slotService;
    @Autowired
    private SlotBackendBo slotBackendBo;

    @LogWrite(modelName="\u5e7f\u544a\u4f4d\u6a21\u5757", option="\u521b\u5efa\u5e7f\u544a\u4f4d")
    @ResponseBody
    @ApiOperation(value="\u521b\u5efa\u5e7f\u544a\u4f4d", httpMethod="POST", notes="\u521b\u5efa\u5e7f\u544a\u4f4d\u63a5\u53e3")
    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public Result<Boolean> createSlot(@Valid @RequestBody ReqCreateSlot req, BindingResult result) {
        try {
            this.checkParam(result);
            RequestLocal rl = RequestLocal.get();
            req.setMediaId(rl.getCid());
            Integer slotType = req.getSlotType();
            this.checkSlotType(req, slotType);
            return this.successResult(this.slotService.insert(req));
        }
        catch (Exception e) {
            this.logger.error("SlotController.createSlot error! the param=[{}]", (Object)req);
            return this.failResult(e);
        }
    }

    private void checkSlotType(ReqCreateSlot req, Integer slotType) throws TuiaMediaException {
        if (2 == slotType) {
            if (req.getFlowType() == null || InformationStreamPictureSizeEnmu.getSizeIdByType((Long)req.getFlowType()) == null) {
                throw new TuiaMediaException(ErrorCode.E0001005.getErrorCode(), "\u4fe1\u606f\u6d41,\u5fc5\u987b\u6709\u5e7f\u544a\u4f4d\u5c3a\u5bf8\uff01");
            }
            int pictureSize = Integer.parseInt(InformationStreamPictureSizeEnmu.getSizeIdByType((Long)req.getFlowType()).toString());
            req.setPictureSize(Integer.valueOf(pictureSize));
        } else if (0 == slotType) {
            req.setPictureSize(Integer.valueOf(SlotPictureSizeEnmu.SIZE_41.getSizeId()));
        } else if (1 == slotType) {
            req.setPictureSize(Integer.valueOf(SlotPictureSizeEnmu.SIZE_61.getSizeId()));
        } else if (3 == slotType) {
            req.setPictureSize(Integer.valueOf(SlotPictureSizeEnmu.SIZE_81.getSizeId()));
        } else if (4 == slotType || 5 == slotType) {
            req.setPictureSize(Integer.valueOf(SlotPictureSizeEnmu.SIZE_21.getSizeId()));
        } else if (6 == slotType) {
            req.setPictureSize(Integer.valueOf(SlotPictureSizeEnmu.SIZE_91.getSizeId()));
        } else if (7 == slotType) {
            if (req.getFlowType() == null || UserDefinedPictureSizeEnmu.getSizeIdByType((Long)req.getFlowType()) == null) {
                throw new TuiaMediaException(ErrorCode.E0001005.getErrorCode(), "\u81ea\u5b9a\u4e49\u7c7b\u578b,\u5fc5\u987b\u6709\u5e7f\u544a\u4f4d\u5c3a\u5bf8\uff01");
            }
            int pictureSize = Integer.parseInt(UserDefinedPictureSizeEnmu.getSizeIdByType((Long)req.getFlowType()).toString());
            req.setPictureSize(Integer.valueOf(pictureSize));
        } else if (8 != slotType) {
            throw new TuiaMediaException(ErrorCode.E0001005.getErrorCode(), "\u5e7f\u544a\u4f4d\u7c7b\u578b\u672a\u77e5");
        }
    }

    @ResponseBody
    @ApiOperation(value="\u67e5\u8be2\u5e7f\u544a\u4f4d\u5217\u8868", httpMethod="GET", notes="\u67e5\u8be2\u5e7f\u544a\u4f4d\u5217\u8868")
    @RequestMapping(value={"/getList"}, method={RequestMethod.GET})
    public Result<RspPageResult<RspSlot>> getList(@ModelAttribute ReqSlotList param) {
        try {
            RequestLocal rl = RequestLocal.get();
            param.setMediaId(rl.getCid());
            param.setPageSize(Integer.valueOf(50));
            param.setRowStart((param.getCurrentPage() - 1) * param.getPageSize());
            return this.successResult(this.slotService.selectListByPage(param));
        }
        catch (Exception e) {
            this.logger.error("SlotController.getList error! the param=[{}]", (Object)param);
            return this.failResult(e);
        }
    }

    @ApiOperation(value="\u67e5\u770b\u5e7f\u544a\u4f4d\u8be6\u60c5", httpMethod="GET", notes="\u67e5\u770b\u5e7f\u544a\u4f4d\u8be6\u60c5\u63a5\u53e3")
    @ApiImplicitParam(name="slotId", value="\u5e7f\u544a\u4f4dID", required=true, dataType="Long", paramType="query")
    @ResponseBody
    @RequestMapping(value={"/getDetail"})
    public Result<RspSlotDetailDto> getDetail(@RequestParam Long slotId) {
        try {
            if (slotId == null) {
                this.logger.error("slotIds can not be null");
                throw new TuiaMediaException(ErrorCode.E0001005);
            }
            return this.successResult(this.slotBackendBo.getSlotDetailById(slotId));
        }
        catch (Exception e) {
            this.logger.error("slotController getDetail error! the slotId=[{}]", (Object)slotId);
            return this.failResult(e);
        }
    }

    @LogWrite(modelName="\u5e7f\u544a\u4f4d\u6a21\u5757", option="\u7f16\u8f91\u5e7f\u544a\u4f4d")
    @ResponseBody
    @ApiOperation(value="\u7f16\u8f91\u5e7f\u544a\u4f4d", httpMethod="POST", notes="\u7f16\u8f91\u5e7f\u544a\u4f4d")
    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public Result<Boolean> update(@Valid @RequestBody ReqUpdateSlot param, BindingResult result) {
        try {
            this.checkParam(result);
            RequestLocal rl = RequestLocal.get();
            param.setMediaId(rl.getCid());
            return this.successResult(this.slotService.update(param));
        }
        catch (Exception e) {
            this.logger.error("SlotController.update error! the param=[{}]", (Object)param);
            return this.failResult(e);
        }
    }

    @LogWrite(modelName="\u5e7f\u544a\u4f4d\u6a21\u5757", option="\u5e7f\u544a\u4f4d\u5f00\u542f/\u5173\u95ed")
    @ResponseBody
    @ApiOperation(value="\u5e7f\u544a\u4f4d\u5f00\u542f/\u5173\u95ed", httpMethod="POST", notes="\u5e7f\u544a\u4f4d\u5f00\u542f/\u5173\u95ed")
    @RequestMapping(value={"/updateEnableStatus"}, method={RequestMethod.POST})
    public Result<Boolean> updateEnableStatus(@Valid @RequestBody ReqEditSlotEnableStatus param, BindingResult result) {
        try {
            this.checkParam(result);
            RequestLocal rl = RequestLocal.get();
            param.setMediaId(rl.getCid());
            return this.successResult(this.slotService.updateEnableStatus(param));
        }
        catch (Exception e) {
            this.logger.error("SlotController.updateEnableStatus error! the param=[{}]", (Object)param);
            return this.failResult(e);
        }
    }

    @ResponseBody
    @ApiOperation(value="\u67e5\u8be2\u5e7f\u544a\u7c7b\u578b\u53c2\u6570", httpMethod="GET", notes="\u67e5\u8be2\u5e7f\u544a\u7c7b\u578b\u53c2\u6570")
    @RequestMapping(value={"/getSlotTypeParam"}, method={RequestMethod.GET})
    public Result<List<SlotTypeParamDto>> getSlotTypeParam() {
        try {
            return this.successResult(this.slotBackendBo.buildSoltTypeParam());
        }
        catch (Exception e) {
            this.logger.error("slotController getDetail error!");
            return this.failResult(e);
        }
    }
}

