/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.web.controller;

import cn.com.duiba.tuia.media.model.Result;
import cn.com.duiba.tuia.media.model.req.ReqSendSMS;
import cn.com.duiba.tuia.media.model.req.ReqVerifySMS;
import cn.com.duiba.tuia.media.service.SmsService;
import cn.com.duiba.tuia.media.web.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/sms"})
@Api(value="\u77ed\u4fe1\u76f8\u5173api")
public class SmsController
extends BaseController {
    @Autowired
    private SmsService smsService;

    @ResponseBody
    @ApiOperation(value="\u53d1\u9001\u624b\u673a\u77ed\u4fe1\u9a8c\u8bc1\u7801", httpMethod="POST", notes="\u53d1\u9001\u624b\u673a\u77ed\u4fe1\u9a8c\u8bc1\u7801\u63a5\u53e3")
    @RequestMapping(value={"/send"}, method={RequestMethod.POST})
    public Result<Boolean> send(@Valid @RequestBody ReqSendSMS req, BindingResult result) {
        try {
            this.checkParam(result);
            return this.successResult(this.smsService.send(req));
        }
        catch (Exception e) {
            this.logger.error("SmsController.send error!");
            return this.failResult(e);
        }
    }

    @ResponseBody
    @ApiOperation(value="\u53d1\u9001\u624b\u673a\u77ed\u4fe1\u9a8c\u8bc1\u7801", httpMethod="POST", notes="\u53d1\u9001\u624b\u673a\u77ed\u4fe1\u9a8c\u8bc1\u7801\u63a5\u53e3")
    @RequestMapping(value={"/verify"}, method={RequestMethod.POST})
    public Result<Boolean> verify(@Valid @ModelAttribute ReqVerifySMS req, BindingResult result) {
        try {
            this.checkParam(result);
            return this.successResult(this.smsService.verify(req.getType().intValue(), req.getPhone(), req.getCode()));
        }
        catch (Exception e) {
            this.logger.error("SmsController.send error!");
            return this.failResult(e);
        }
    }
}

