/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.tuia.media.api.dto.SlotCacheDto;
import cn.com.duiba.tuia.media.api.dto.SlotDto;
import cn.com.duiba.tuia.media.api.dto.StrategyCacheDto;
import cn.com.duiba.tuia.media.api.utils.CacheKeyUtils;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.constants.SlotPictureSizeEnmu;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ShieldStrategyDAO;
import cn.com.duiba.tuia.media.dao.SlotDAO;
import cn.com.duiba.tuia.media.domain.ShieldStrategyDto;
import cn.com.duiba.tuia.media.service.impl.BaseCacheService;
import cn.com.duiba.tuia.media.utils.StringTool;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SlotCacheService
extends BaseCacheService {
    @Autowired
    private SlotDAO slotDAO;
    @Autowired
    private ShieldStrategyDAO shieldStrategyDAO;

    public SlotCacheDto getSlot(long slotId) throws TuiaMediaException {
        String strSlot = this.redisClient.get(CacheKeyUtils.getSlotKey((long)slotId));
        SlotCacheDto slotCacheDto = StringUtils.isEmpty((String)strSlot) ? this.updateSlotById(slotId) : (SlotCacheDto)JSONObject.parseObject((String)strSlot, SlotCacheDto.class);
        if (slotCacheDto == null) {
            throw new TuiaMediaException(ErrorCode.E0304008);
        }
        return slotCacheDto;
    }

    public void updateSlotCache(final long slotId) {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    SlotCacheService.this.updateSlotById(slotId);
                }
                catch (TuiaMediaException e) {
                    SlotCacheService.this.logger.error("updateSlotCache error", (Throwable)e);
                }
            }
        });
    }

    public void updateBatchSlotCache(final List<Long> slotIds) {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    if (CollectionUtils.isNotEmpty((Collection)slotIds)) {
                        for (Long slotId : slotIds) {
                            SlotCacheService.this.updateSlotById(slotId);
                        }
                    }
                }
                catch (TuiaMediaException e) {
                    SlotCacheService.this.logger.error("updateSlotCache error", (Throwable)e);
                }
            }
        });
    }

    public SlotCacheDto updateSlotById(long slotId) throws TuiaMediaException {
        SlotDto slotDto = this.slotDAO.selectById(slotId);
        SlotCacheDto slotCacheDto = null;
        if (slotDto != null) {
            if (slotDto.getPictureSize() != null) {
                SlotPictureSizeEnmu.PictureSize pictureSize = SlotPictureSizeEnmu.getPictureSizeById((int)slotDto.getPictureSize());
                if (pictureSize == null) {
                    this.logger.error(" the slot=[{}] pictureSizeId=[{}] non-existent", (Object)slotId, (Object)slotDto.getPictureSize());
                    return null;
                }
                String pictureType = null;
                if (SlotPictureSizeEnmu.SIZE_42.getSizeId() == slotDto.getPictureSize().intValue()) {
                    pictureType = "alpha0";
                }
                slotCacheDto = new SlotCacheDto(Long.valueOf(slotId), slotDto.getSlotType(), pictureSize.getWidth(), pictureSize.getHeight(), slotDto.getStrategyId(), pictureType);
            } else {
                slotCacheDto = new SlotCacheDto(Long.valueOf(slotId), slotDto.getSlotType(), 0, 0, slotDto.getStrategyId(), null);
            }
            slotCacheDto.setValid(1 == slotDto.getCheckStatus() && 1 == slotDto.getEnableStatus());
            slotCacheDto.setVisibleOfCloseButton(slotDto.isVisibleOfCloseButton());
            slotCacheDto.setVisibleOfIco(slotDto.isVisibleOfIco());
            slotCacheDto.setActivityTargetUrl(slotDto.getActivityTargetUrl());
            slotCacheDto.setSlotExposeLimit(slotDto.getSlotExposeLimit());
            slotCacheDto.setActivityExposeLimit(slotDto.getActivityExposeLimit());
            this.redisClient.setex(CacheKeyUtils.getSlotKey((long)slotId), 604800, JSONObject.toJSONString((Object)slotCacheDto));
        }
        return slotCacheDto;
    }

    public StrategyCacheDto getStrategy(long slotId) throws TuiaMediaException {
        Long strategyId = this.getSlot(slotId).getStrategyId();
        if (strategyId == null) {
            return null;
        }
        String strategy = this.redisClient.get(CacheKeyUtils.getStrategyKey((long)strategyId));
        StrategyCacheDto strategyDto = StringUtils.isEmpty((String)strategy) ? this.updateStrategyById(strategyId) : (StrategyCacheDto)JSONObject.parseObject((String)strategy, StrategyCacheDto.class);
        return strategyDto;
    }

    public StrategyCacheDto updateStrategy(long slotId) throws TuiaMediaException {
        Long strategyId = this.getSlot(slotId).getStrategyId();
        if (strategyId == null) {
            return null;
        }
        return this.updateStrategyById(strategyId);
    }

    public StrategyCacheDto updateStrategyById(long strategyId) throws TuiaMediaException {
        StrategyCacheDto strategyDto = null;
        ShieldStrategyDto shieldStrategyDto = this.shieldStrategyDAO.selectById(strategyId);
        if (shieldStrategyDto != null) {
            strategyDto = new StrategyCacheDto(shieldStrategyDto.getId(), StringTool.getStringListByStr(shieldStrategyDto.getShieldIndustries()), StringTool.getStringListByStr(shieldStrategyDto.getShieldUrls()), StringTool.getStringListByStr(shieldStrategyDto.getAdvertTagNums()));
            this.redisClient.setex(CacheKeyUtils.getStrategyKey((long)strategyId), 604800, JSONObject.toJSONString((Object)strategyDto));
        } else {
            this.logger.error("the strategyId=[{}] is non-existent!", (Object)strategyId);
        }
        return strategyDto;
    }

    public void deleteStrategyCache(long strategyId) {
        this.redisClient.del(CacheKeyUtils.getStrategyKey((long)strategyId));
    }
}

