/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.top.link.channel;

import com.taobao.top.link.DefaultLoggerFactory;
import com.taobao.top.link.LoggerFactory;
import com.taobao.top.link.ResetableTimer;
import com.taobao.top.link.channel.ChannelException;
import com.taobao.top.link.channel.ClientChannel;
import com.taobao.top.link.channel.ClientChannelSelector;
import com.taobao.top.link.channel.websocket.WebSocketClient;
import java.net.URI;
import java.util.Hashtable;

public class ClientChannelSharedSelector
implements ClientChannelSelector {
    private static final int CONNECT_TIMEOUT = 5000;
    private Hashtable<String, ClientChannel> channels;
    private LoggerFactory loggerFactory;
    private Object lockObject;
    private int heartbeatInterval;

    public ClientChannelSharedSelector() {
        this(DefaultLoggerFactory.getDefault());
    }

    public ClientChannelSharedSelector(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.channels = new Hashtable();
        this.lockObject = new Object();
    }

    public void setHeartbeat(int interval) {
        this.heartbeatInterval = interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientChannel getChannel(URI uri) throws ChannelException {
        String url = uri.toString();
        if (this.channels.get(url) == null || !this.channels.get(url).isConnected()) {
            Object object = this.lockObject;
            synchronized (object) {
                if (this.channels.get(url) == null || !this.channels.get(url).isConnected()) {
                    this.channels.put(url, this.wrapChannel(this.connect(this.loggerFactory, uri, 5000)));
                }
            }
        }
        return this.channels.get(url);
    }

    public void returnChannel(ClientChannel channel) {
    }

    protected ClientChannel connect(LoggerFactory loggerFactory, URI uri, int timeout) throws ChannelException {
        return WebSocketClient.connect(loggerFactory, uri, timeout);
    }

    private ClientChannel wrapChannel(ClientChannel channel) {
        if (this.heartbeatInterval > 0) {
            channel.setHeartbeatTimer(new ResetableTimer(this.heartbeatInterval));
        }
        return channel;
    }
}

