/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.top.link.embedded.websocket.impl;

import com.taobao.top.link.embedded.websocket.WebSocket;
import com.taobao.top.link.embedded.websocket.exception.ErrorCode;
import com.taobao.top.link.embedded.websocket.exception.WebSocketException;
import com.taobao.top.link.embedded.websocket.frame.Frame;
import com.taobao.top.link.embedded.websocket.frame.FrameHeader;
import com.taobao.top.link.embedded.websocket.frame.FrameParser;
import com.taobao.top.link.embedded.websocket.frame.rfc6455.BinaryFrame;
import com.taobao.top.link.embedded.websocket.frame.rfc6455.CloseFrame;
import com.taobao.top.link.embedded.websocket.frame.rfc6455.FrameBuilderRfc6455;
import com.taobao.top.link.embedded.websocket.frame.rfc6455.FrameHeaderRfc6455;
import com.taobao.top.link.embedded.websocket.frame.rfc6455.TextFrame;
import com.taobao.top.link.embedded.websocket.handler.MaskFrameStreamHandler;
import com.taobao.top.link.embedded.websocket.handler.StreamHandlerAdapter;
import com.taobao.top.link.embedded.websocket.handler.StreamHandlerChain;
import com.taobao.top.link.embedded.websocket.handler.WebSocketHandler;
import com.taobao.top.link.embedded.websocket.handler.WebSocketPipeline;
import com.taobao.top.link.embedded.websocket.handshake.Handshake;
import com.taobao.top.link.embedded.websocket.impl.WebSocketBase;
import com.taobao.top.link.embedded.websocket.proxy.Proxy;
import com.taobao.top.link.embedded.websocket.util.Base64;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class WebSocketImpl
extends WebSocketBase {
    private static final int VERSION = 13;
    protected Set<String> extensions = new HashSet<String>();
    protected String[] serverExtentions;

    public WebSocketImpl(String url, String origin, WebSocketHandler handler, String ... protocols) throws WebSocketException {
        super(url, origin, handler, protocols);
    }

    public WebSocketImpl(String url, WebSocketHandler handler, String ... protocols) throws WebSocketException {
        super(url, handler, protocols);
    }

    public WebSocketImpl(String url, String origin, Proxy proxy, WebSocketHandler handler, String ... protocols) throws WebSocketException {
        super(url, origin, proxy, handler, protocols);
    }

    public WebSocketImpl(String url, Proxy proxy, WebSocketHandler handler, String ... protocols) throws WebSocketException {
        super(url, proxy, handler, protocols);
    }

    protected void initializePipeline(WebSocketPipeline pipeline) throws WebSocketException {
        pipeline.addStreamHandler(new MaskFrameStreamHandler());
        super.initializePipeline(pipeline);
        pipeline.addStreamHandler(new StreamHandlerAdapter(){

            public void nextDownstreamHandler(WebSocket ws, ByteBuffer buffer, Frame frame, StreamHandlerChain chain) throws WebSocketException {
                if (frame instanceof CloseFrame) {
                    if (WebSocketImpl.this.state == WebSocketBase.State.WAIT) {
                        chain.nextUpstreamHandler(ws, null, frame);
                    }
                    CloseFrame closeFrame = (CloseFrame)frame;
                    WebSocketImpl.this.handler.onCloseFrame(ws, closeFrame.getStatusCode(), closeFrame.getReasonText());
                    WebSocketImpl.this.transitionTo(WebSocketBase.State.CLOSED);
                } else {
                    WebSocketImpl.this.handler.onMessage(ws, frame);
                }
            }

            public void nextHandshakeDownstreamHandler(WebSocket ws, ByteBuffer buffer, StreamHandlerChain chain) throws WebSocketException {
                WebSocketImpl.this.responseHeader = WebSocketImpl.this.getHandshake().getResponseHeader();
                WebSocketImpl.this.responseStatus = WebSocketImpl.this.getHandshake().getResponseStatus();
                WebSocketImpl.this.transitionTo(WebSocketBase.State.WAIT);
                WebSocketImpl.this.handler.onOpen(WebSocketImpl.this);
            }
        });
    }

    protected Handshake newHandshakeInstance() {
        return new Handshake(){

            public ByteBuffer createHandshakeRequest() throws WebSocketException {
                StringBuilder sb = new StringBuilder();
                sb.append("GET " + WebSocketImpl.this.path + " HTTP/1.1\r\n");
                WebSocketBase.addHeader(sb, "Host", WebSocketImpl.this.endpointAddress.getHostName());
                WebSocketBase.addHeader(sb, "Upgrade", "websocket");
                WebSocketBase.addHeader(sb, "Connection", "Upgrade");
                WebSocketBase.addHeader(sb, "Sec-WebSocket-Key", WebSocketImpl.this.generateWebSocketKey());
                if (WebSocketImpl.this.origin != null) {
                    WebSocketBase.addHeader(sb, "Origin", WebSocketImpl.this.origin);
                }
                if (WebSocketImpl.this.protocols != null && WebSocketImpl.this.protocols.length > 0) {
                    WebSocketBase.addHeader(sb, "Sec-WebSocket-Protocol", WebSocketBase.join(",", WebSocketImpl.this.protocols));
                }
                if (WebSocketImpl.this.extensions.size() > 0) {
                    WebSocketBase.addHeader(sb, "Sec-WebSocket-Extensions", WebSocketBase.join(",", WebSocketImpl.this.extensions));
                }
                WebSocketBase.addHeader(sb, "Sec-WebSocket-Version", String.valueOf(WebSocketImpl.this.getWebSocketVersion()));
                if (WebSocketImpl.this.requestHeader != null) {
                    for (String h : WebSocketImpl.this.requestHeader.getHeaderNames()) {
                        WebSocketBase.addHeader(sb, h, WebSocketImpl.this.requestHeader.getHeaderValue(h));
                    }
                }
                sb.append("\r\n");
                return ByteBuffer.wrap(sb.toString().getBytes());
            }

            protected boolean parseHandshakeResponseHeader(ByteBuffer buffer) throws WebSocketException {
                String extensionsStr;
                if (!super.parseHandshakeResponseHeader(buffer)) {
                    return false;
                }
                if (!"websocket".equalsIgnoreCase(this.getResponseHeader().getHeaderValue("upgrade"))) {
                    throw new WebSocketException(ErrorCode.E3600, WebSocketImpl.this.responseHeader.getHeaderValue("upgrade"));
                }
                if (!"upgrade".equalsIgnoreCase(this.getResponseHeader().getHeaderValue("connection"))) {
                    throw new WebSocketException(ErrorCode.E3601, WebSocketImpl.this.responseHeader.getHeaderValue("connection"));
                }
                if (!this.getResponseHeader().containsHeader("sec-websocket-accept")) {
                    throw new WebSocketException(ErrorCode.E3602);
                }
                String protocolStr = this.getResponseHeader().getHeaderValue("sec-websocket-protocol");
                if (protocolStr != null) {
                    WebSocketImpl.this.serverProtocols = protocolStr.split(",");
                }
                if ((extensionsStr = this.getResponseHeader().getHeaderValue("sec-websocket-extensions")) != null) {
                    WebSocketImpl.this.serverExtentions = extensionsStr.split(",");
                }
                return true;
            }
        };
    }

    private String generateWebSocketKey() {
        UUID uuid = UUID.randomUUID();
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return Base64.encodeToString(bb.array(), false);
    }

    protected FrameParser newFrameParserInstance() {
        return new FrameParser(){
            private FrameHeaderRfc6455 previousCreatedFrameHeader;

            protected FrameHeader createFrameHeader(ByteBuffer chunkData) {
                FrameHeaderRfc6455 header = FrameBuilderRfc6455.createFrameHeader(chunkData, this.previousCreatedFrameHeader);
                if (header != null && !header.isContinuation()) {
                    this.previousCreatedFrameHeader = header;
                }
                return header;
            }

            protected Frame createFrame(FrameHeader h, byte[] bodyData) {
                return FrameBuilderRfc6455.createFrame((FrameHeaderRfc6455)h, bodyData);
            }
        };
    }

    public Frame createFrame(byte[] bytes) throws WebSocketException {
        return new BinaryFrame(bytes);
    }

    public Frame createFrame(String str) throws WebSocketException {
        return new TextFrame(str);
    }

    protected int getWebSocketVersion() {
        return 13;
    }

    public void addExtension(String extension) {
        this.extensions.add(extension);
    }

    public void removeExtension(String extension) {
        this.extensions.remove(extension);
    }

    protected void closeWebSocket() throws WebSocketException {
        this.transitionTo(WebSocketBase.State.CLOSING);
        this.pipeline.sendUpstream(this, null, new CloseFrame());
    }
}

