/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.top.link.remoting;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.taobao.top.link.remoting.FormatterException;
import com.taobao.top.link.remoting.MethodCall;
import com.taobao.top.link.remoting.MethodCallWrapper;
import com.taobao.top.link.remoting.MethodReturn;
import com.taobao.top.link.remoting.MethodReturnWrapper;
import com.taobao.top.link.remoting.Serializer;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrossLanguageJsonSerializer
implements Serializer {
    private static final SerializerFeature[] features = new SerializerFeature[]{SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteNullBooleanAsFalse};

    @Override
    public String getName() {
        return "json";
    }

    @Override
    public byte[] serializeMethodCall(MethodCall methodCall) throws FormatterException {
        MethodCallWrapper wrapper = new MethodCallWrapper(methodCall);
        wrapper.Args = methodCall.Args;
        wrapper.MethodSignature = new String[methodCall.MethodSignature != null ? methodCall.MethodSignature.length : 0];
        for (int i = 0; i < methodCall.MethodSignature.length; ++i) {
            wrapper.MethodSignature[i] = this.parseTypeName(methodCall.MethodSignature[i]);
        }
        return JSON.toJSONBytes((Object)wrapper, (SerializerFeature[])features);
    }

    @Override
    public MethodCall deserializeMethodCall(byte[] input) throws FormatterException {
        JSONArray args;
        JSONObject obj = (JSONObject)JSON.parse((byte[])input, (Feature[])new Feature[0]);
        MethodCall methodCall = new MethodCall();
        methodCall.MethodName = obj.getString("MethodName");
        methodCall.TypeName = obj.getString("TypeName");
        methodCall.Uri = obj.getString("Uri");
        JSONArray methodSignature = obj.getJSONArray("MethodSignature");
        if (methodSignature != null) {
            methodCall.MethodSignature = new Class[methodSignature.size()];
            for (int i = 0; i < methodCall.MethodSignature.length; ++i) {
                try {
                    methodCall.MethodSignature[i] = this.parseType(methodSignature.getString(i));
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new FormatterException("parse MethodSignature error", e);
                }
            }
        }
        if ((args = obj.getJSONArray("Args")) != null) {
            methodCall.Args = new Object[args.size()];
            for (int i = 0; i < methodCall.Args.length; ++i) {
                methodCall.Args[i] = methodCall.MethodSignature[i].equals(HashMap.class) ? JSON.parseObject((String)args.getJSONObject(i).toJSONString(), (TypeReference)new TypeReference<HashMap<Object, Object>>(){}, (Feature[])new Feature[0]) : args.getObject(i, methodCall.MethodSignature[i]);
            }
        }
        return methodCall;
    }

    @Override
    public byte[] serializeMethodReturn(MethodReturn methodReturn) throws FormatterException {
        MethodReturnWrapper wrapper = new MethodReturnWrapper();
        wrapper.ReturnValue = methodReturn.ReturnValue;
        wrapper.Exception = methodReturn.Exception != null ? methodReturn.Exception.toString() : null;
        return JSON.toJSONBytes((Object)wrapper, (SerializerFeature[])features);
    }

    @Override
    public MethodReturn deserializeMethodReturn(byte[] input, Class<?> returnType) throws FormatterException {
        JSONObject obj = (JSONObject)JSON.parse((byte[])input, (Feature[])new Feature[0]);
        MethodReturn methodReturn = new MethodReturn();
        methodReturn.ReturnValue = obj.get((Object)"ReturnValue") != null ? obj.getObject("ReturnValue", returnType) : null;
        String exception = obj.getString("Exception");
        if (exception != null && !exception.equals("")) {
            methodReturn.Exception = new Exception(exception);
            methodReturn.Exception.setStackTrace(new StackTraceElement[0]);
        }
        return methodReturn;
    }

    private String parseTypeName(Class<?> type) {
        if (String.class.equals(type)) {
            return "";
        }
        if (Byte.TYPE.equals(type)) {
            return "b";
        }
        if (Byte.class.equals(type)) {
            return "B";
        }
        if (Double.TYPE.equals(type)) {
            return "d";
        }
        if (Double.class.equals(type)) {
            return "D";
        }
        if (Float.TYPE.equals(type)) {
            return "f";
        }
        if (Float.class.equals(type)) {
            return "F";
        }
        if (Integer.TYPE.equals(type)) {
            return "i";
        }
        if (Integer.class.equals(type)) {
            return "I";
        }
        if (Long.TYPE.equals(type)) {
            return "l";
        }
        if (Long.class.equals(type)) {
            return "L";
        }
        if (Short.TYPE.equals(type)) {
            return "s";
        }
        if (Short.class.equals(type)) {
            return "S";
        }
        if (Date.class.equals(type)) {
            return "t";
        }
        if (Map.class.equals(type) || Map.class.isAssignableFrom(type)) {
            return "m";
        }
        if (type.isArray()) {
            return String.format("[%s", this.parseTypeName(type.getComponentType()));
        }
        return type.getName();
    }

    private Class<?> parseType(String typeName) throws ClassNotFoundException {
        if ("".equalsIgnoreCase(typeName)) {
            return String.class;
        }
        if ("b".equalsIgnoreCase(typeName)) {
            return Byte.TYPE;
        }
        if ("B".equalsIgnoreCase(typeName)) {
            return Byte.class;
        }
        if ("d".equalsIgnoreCase(typeName)) {
            return Double.TYPE;
        }
        if ("D".equalsIgnoreCase(typeName)) {
            return Double.class;
        }
        if ("f".equalsIgnoreCase(typeName)) {
            return Float.TYPE;
        }
        if ("F".equalsIgnoreCase(typeName)) {
            return Float.class;
        }
        if ("i".equalsIgnoreCase(typeName)) {
            return Integer.TYPE;
        }
        if ("I".equalsIgnoreCase(typeName)) {
            return Integer.class;
        }
        if ("l".equalsIgnoreCase(typeName)) {
            return Long.TYPE;
        }
        if ("L".equalsIgnoreCase(typeName)) {
            return Long.class;
        }
        if ("s".equalsIgnoreCase(typeName)) {
            return Short.TYPE;
        }
        if ("S".equalsIgnoreCase(typeName)) {
            return Short.class;
        }
        if ("t".equalsIgnoreCase(typeName)) {
            return Date.class;
        }
        if ("m".equalsIgnoreCase(typeName)) {
            return HashMap.class;
        }
        if (typeName.charAt(0) == '[') {
            typeName = String.format("[L%s;", this.parseType(this.getComponentTypeName(typeName)).getName());
        }
        return Class.forName(typeName, false, this.getClass().getClassLoader());
    }

    private String getComponentTypeName(String typeName) {
        return typeName.substring(1);
    }
}

