/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.top.link.schedule;

import com.taobao.top.link.DefaultLoggerFactory;
import com.taobao.top.link.LinkException;
import com.taobao.top.link.Logger;
import com.taobao.top.link.LoggerFactory;
import com.taobao.top.link.Text;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scheduler<T> {
    protected int max = 100;
    protected Logger logger;
    private Object lock;
    private Semaphore semaphore;
    private Thread dispatcher;
    protected boolean running;
    private Timer checker;
    private Map<T, Queue<Runnable>> tasks;
    private ExecutorService threadPool;

    public Scheduler() {
        this(DefaultLoggerFactory.getDefault());
    }

    public Scheduler(LoggerFactory loggerFactory) {
        this.logger = loggerFactory.create(this);
        this.lock = new Object();
        this.semaphore = new Semaphore(0);
        this.tasks = this.createStore();
        this.setThreadPool(Executors.newCachedThreadPool());
    }

    public void setUserMaxPendingCount(int max) {
        this.max = max;
    }

    public void setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    public void start() {
        if (this.dispatcher != null) {
            return;
        }
        this.running = true;
        this.dispatcher = new Thread(new Runnable(){

            public void run() {
                while (Scheduler.this.running) {
                    block3: {
                        try {
                            Scheduler.this.semaphore.tryAcquire(1L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException e) {
                            if (!Scheduler.this.logger.isDebugEnabled()) break block3;
                            Scheduler.this.logger.debug(e);
                        }
                    }
                    Scheduler.this.dispatch();
                }
            }
        });
        this.dispatcher.start();
        this.prepareChecker(10000L, 10000L);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Text.SCHEDULE_START);
        }
    }

    public void stop() throws InterruptedException {
        if (this.dispatcher == null) {
            return;
        }
        this.stopChecker();
        this.checker = null;
        this.disposeDispatcher();
        this.dispatcher = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Text.SCHEDULE_STOP);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(T t, Runnable task) throws LinkException {
        Queue<Runnable> queue;
        if (this.canRunImmediately(t, task)) {
            try {
                this.threadPool.execute(task);
                return;
            }
            catch (RejectedExecutionException e) {
                // empty catch block
            }
        }
        if ((queue = this.tasks.get(t)) == null) {
            Object object = this.lock;
            synchronized (object) {
                queue = this.tasks.get(t);
                if (queue == null) {
                    queue = this.createTaskQueue(t);
                    this.tasks.put(t, queue);
                }
            }
        }
        if (this.haveReachMaxPendingCount(t, queue, task)) {
            throw new LinkException(String.format(Text.SCHEDULE_GOT_MAX, this.max));
        }
        try {
            queue.add(task);
        }
        catch (Exception e) {
            throw new LinkException(Text.SCHEDULE_TASK_REFUSED, e);
        }
        this.semaphore.release();
    }

    public void drop(T t) {
        if (this.tasks.get(t) == null) {
            return;
        }
        this.tasks.get(t).clear();
        this.tasks.remove(t);
    }

    protected Map<T, Queue<Runnable>> createStore() {
        return new HashMap();
    }

    protected Queue<Runnable> createTaskQueue(T t) {
        return new ArrayBlockingQueue<Runnable>(this.max, false);
    }

    protected boolean canRunImmediately(T t, Runnable task) {
        return false;
    }

    protected boolean haveReachMaxPendingCount(T t, Queue<Runnable> queue, Runnable task) {
        return queue.size() >= this.max;
    }

    protected final void dispatch() {
        boolean flag;
        int c = 0;
        block4: do {
            flag = false;
            Iterator<Map.Entry<T, Queue<Runnable>>> iterator = this.tasks.entrySet().iterator();
            while (iterator.hasNext()) {
                Queue<Runnable> queue;
                Map.Entry<T, Queue<Runnable>> entry;
                try {
                    entry = iterator.next();
                }
                catch (Exception e) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(e);
                    }
                    flag = true;
                    continue block4;
                }
                if (entry == null || (queue = entry.getValue()) == null) continue;
                Runnable task = this.peek(queue);
                boolean bl = flag ? flag : (flag = queue.size() - 1 > 0);
                if (task == null) continue;
                try {
                    this.threadPool.execute(task);
                    this.poll(queue);
                    ++c;
                }
                catch (RejectedExecutionException e) {
                    if (!this.logger.isDebugEnabled()) continue block4;
                    this.logger.debug(e);
                    continue block4;
                }
            }
        } while (flag);
        if (this.logger.isDebugEnabled() && c > 0) {
            this.logger.debug(Text.SCHEDULE_TASK_DISPATCHED, c);
        }
    }

    protected Runnable peek(Queue<Runnable> queue) {
        return queue.peek();
    }

    protected void poll(Queue<Runnable> queue) {
        queue.poll();
    }

    protected final void disposeDispatcher() throws InterruptedException {
        this.running = false;
        this.semaphore.release();
        this.dispatcher.join();
    }

    protected final void prepareChecker(long delay, long period) {
        this.stopChecker();
        this.checker = new Timer();
        this.checker.schedule(new TimerTask(){

            public void run() {
                if (!Scheduler.this.running || Scheduler.this.dispatcher.isAlive()) {
                    return;
                }
                Scheduler.this.logger.fatal(Text.SCHEDULE_DISPATCHER_DOWN);
                try {
                    Scheduler.this.stop();
                    Scheduler.this.start();
                }
                catch (Exception e) {
                    Scheduler.this.logger.error(e);
                }
            }
        }, delay, period);
    }

    protected final void stopChecker() {
        if (this.checker == null) {
            return;
        }
        this.checker.cancel();
    }
}

