/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.common.tool;

import cn.com.duiba.tuia.media.common.tool.RequestTool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeProfileTool {
    private static Logger log = LoggerFactory.getLogger(TimeProfileTool.class);
    private static ThreadLocal<Stack<TimeProfileStack>> stack = new ThreadLocal();
    private static ThreadLocal<List<TimeProfileStack>> logs = new ThreadLocal();
    public static final ThreadLocal<HttpServletRequest> REQUEST = new ThreadLocal();
    public static final int THRESHOLD = 500;
    private static final String LOGSTR = "TimeProfile timeout ";
    private TimeProfileTool timeProTool;

    public TimeProfileTool getTimeProfileTool() {
        if (this.timeProTool == null) {
            this.timeProTool = new TimeProfileTool();
        }
        return this.timeProTool;
    }

    public static void enter() {
        TimeProfileTool.enter("");
    }

    public static void enter(String tag) {
        if (stack.get() == null) {
            return;
        }
        TimeProfileStack t = new TimeProfileStack();
        t.setEnterTime(new Date());
        t.setTag(tag);
        t.setDeep(stack.get().size());
        t.index = logs.get().size() + stack.get().size();
        stack.get().push(t);
    }

    public static void release() {
        if (stack.get() == null) {
            return;
        }
        TimeProfileStack t = stack.get().pop();
        t.setReleaseTime(new Date());
        logs.get().add(t);
    }

    public static void start() {
        stack.set(new Stack());
        logs.set(new ArrayList());
        TimeProfileTool.enter();
    }

    public static void end() {
        TimeProfileStack t;
        TimeProfileStack timeProfileStack = t = stack.get() == null ? null : stack.get().pop();
        if (t == null) {
            return;
        }
        t.setReleaseTime(new Date());
        logs.get().add(t);
        Long timeconsume = t.getReleaseTime().getTime() - t.getEnterTime().getTime();
        if (timeconsume > 500L) {
            StringBuilder sb = new StringBuilder();
            if (REQUEST.get() != null) {
                String url = RequestTool.getRequestUrl(REQUEST.get());
                sb.append(LOGSTR).append(timeconsume).append("ms >").append(500).append("ms, url=").append(url);
            } else {
                sb.append(LOGSTR).append(timeconsume).append("ms ");
            }
            ArrayList list = new ArrayList(logs.get());
            Collections.sort(list, new Comparator<TimeProfileStack>(){

                @Override
                public int compare(TimeProfileStack o1, TimeProfileStack o2) {
                    if (o1.index > o2.index) {
                        return 1;
                    }
                    if (o1.index < o2.index) {
                        return -1;
                    }
                    return 0;
                }
            });
            for (TimeProfileStack s : list) {
                sb.append("\r\n\t");
                for (int i = 0; i < s.getDeep(); ++i) {
                    sb.append("-");
                }
                Long consume = s.getReleaseTime().getTime() - s.getEnterTime().getTime();
                sb.append(consume * 100L / timeconsume).append("% ").append(consume).append("ms");
                if (s.getTag() != null) {
                    sb.append("  ").append(s.getTag());
                }
                if (s.getStackTraceElement() == null) continue;
                StackTraceElement ste = s.getStackTraceElement();
                sb.append("  ").append(ste.getClassName()).append(".").append(ste.getMethodName()).append(" line:").append(ste.getLineNumber());
            }
            log.info(sb.toString());
        }
        REQUEST.set(null);
        stack.set(null);
        logs.set(null);
    }

    public static String dump(long ms) {
        if (logs.get() == null) {
            return null;
        }
        TimeProfileStack t = stack.get().pop();
        t.setReleaseTime(new Date());
        logs.get().add(t);
        Long timeconsume = 0L;
        for (TimeProfileStack s : logs.get()) {
            if (s.deep != 0) continue;
            timeconsume = timeconsume + (s.getReleaseTime().getTime() - s.getEnterTime().getTime());
        }
        if (timeconsume < ms) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(LOGSTR).append(timeconsume).append("ms ");
        ArrayList list = new ArrayList(logs.get());
        Collections.sort(list, new Comparator<TimeProfileStack>(){

            @Override
            public int compare(TimeProfileStack o1, TimeProfileStack o2) {
                if (o1.index > o2.index) {
                    return 1;
                }
                if (o1.index < o2.index) {
                    return -1;
                }
                return 0;
            }
        });
        for (TimeProfileStack s : list) {
            Long consume = s.getReleaseTime().getTime() - s.getEnterTime().getTime();
            if (consume == 0L) continue;
            sb.append("\r\n\t");
            for (int i = 0; i < s.getDeep(); ++i) {
                sb.append("  ");
            }
            sb.append("-").append(consume * 100L / timeconsume).append("%").append("  ").append(consume).append("ms");
            if (s.getTag() != null) {
                sb.append("  ").append(s.getTag());
            }
            if (s.getStackTraceElement() == null) continue;
            StackTraceElement ste = s.getStackTraceElement();
            sb.append("  ").append(ste.getClassName()).append(".").append(ste.getMethodName()).append(" line:").append(ste.getLineNumber());
        }
        REQUEST.set(null);
        stack.set(null);
        logs.set(null);
        return sb.toString();
    }

    public static class TimeProfileStack {
        private Date enterTime;
        private Date releaseTime;
        private int deep;
        private String tag;
        int index;
        private StackTraceElement stackTraceElement;

        public Date getEnterTime() {
            return this.enterTime;
        }

        public void setEnterTime(Date enterTime) {
            this.enterTime = enterTime;
        }

        public Date getReleaseTime() {
            return this.releaseTime;
        }

        public void setReleaseTime(Date releaseTime) {
            this.releaseTime = releaseTime;
        }

        public int getDeep() {
            return this.deep;
        }

        public void setDeep(int deep) {
            this.deep = deep;
        }

        public String getTag() {
            return this.tag;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }

        public StackTraceElement getStackTraceElement() {
            return this.stackTraceElement;
        }

        public void setStackTraceElement(StackTraceElement stackTraceElement) {
            this.stackTraceElement = stackTraceElement;
        }
    }
}

