/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.common.utils;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AESUtils {
    private static Logger logger = LoggerFactory.getLogger(AESUtils.class);
    private static final byte[] INIT_VECTOR = new byte[]{49, 55, 54, 53, 52, 51, 50, 49, 56, 39, 54, 53, 51, 35, 50, 51};
    private AESUtils au;

    public AESUtils getAESUtils() {
        if (this.au == null) {
            this.au = new AESUtils();
        }
        return this.au;
    }

    public static String encrypt(String content, String apiKey) throws TuiaMediaException {
        if (apiKey == null) {
            throw new IllegalArgumentException("Key cannot be null!");
        }
        byte[] keyBytes = apiKey.getBytes();
        if (keyBytes.length != 32 && keyBytes.length != 24 && keyBytes.length != 16) {
            throw new IllegalArgumentException("Key length must be 128/192/256 bits!");
        }
        byte[] encryptedBytes = AESUtils.encrypt(content.getBytes(), keyBytes, INIT_VECTOR);
        String encrypted = new String(Hex.encode((byte[])encryptedBytes));
        return encrypted;
    }

    public static String decrypt(String content, String apiKey) throws TuiaMediaException {
        if (apiKey == null) {
            throw new IllegalArgumentException("Key cannot be null!");
        }
        byte[] encryptedContent = Hex.decode((String)content);
        byte[] keyBytes = apiKey.getBytes();
        if (keyBytes.length != 32 && keyBytes.length != 24 && keyBytes.length != 16) {
            throw new IllegalArgumentException("Key length must be 128/192/256 bits!");
        }
        byte[] decryptedBytes = AESUtils.decrypt(encryptedContent, keyBytes, INIT_VECTOR);
        String decrypted = new String(decryptedBytes);
        return decrypted;
    }

    private static byte[] encrypt(byte[] plain, byte[] key, byte[] iv) throws TuiaMediaException {
        PaddedBufferedBlockCipher aes = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESFastEngine()));
        ParametersWithIV ivAndKey = new ParametersWithIV((CipherParameters)new KeyParameter(key), iv);
        aes.init(true, (CipherParameters)ivAndKey);
        return AESUtils.cipherData(aes, plain);
    }

    private static byte[] decrypt(byte[] cipher, byte[] key, byte[] iv) throws TuiaMediaException {
        PaddedBufferedBlockCipher aes = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESFastEngine()));
        ParametersWithIV ivAndKey = new ParametersWithIV((CipherParameters)new KeyParameter(key), iv);
        aes.init(false, (CipherParameters)ivAndKey);
        return AESUtils.cipherData(aes, cipher);
    }

    private static byte[] cipherData(PaddedBufferedBlockCipher cipher, byte[] data) throws TuiaMediaException {
        try {
            int minSize = cipher.getOutputSize(data.length);
            byte[] outBuf = new byte[minSize];
            int length1 = cipher.processBytes(data, 0, data.length, outBuf, 0);
            int length2 = cipher.doFinal(outBuf, length1);
            int actualLength = length1 + length2;
            byte[] result = new byte[actualLength];
            System.arraycopy(outBuf, 0, result, 0, result.length);
            return result;
        }
        catch (Exception e) {
            logger.error("AESUtils.cipherData happen error! the cipher=[{}],the data=[{}], the e = [{}]", new Object[]{cipher, data, e});
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
    }
}

