/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.core.OrderComparator;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.ui.context.ThemeSource;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.async.WebAsyncManager;
import org.springframework.web.context.request.async.WebAsyncUtils;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.servlet.FlashMap;
import org.springframework.web.servlet.FlashMapManager;
import org.springframework.web.servlet.FrameworkServlet;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.LocaleContextResolver;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.ModelAndViewDefiningException;
import org.springframework.web.servlet.NoHandlerFoundException;
import org.springframework.web.servlet.RequestToViewNameTranslator;
import org.springframework.web.servlet.ThemeResolver;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.util.NestedServletException;
import org.springframework.web.util.WebUtils;

public class DispatcherServlet
extends FrameworkServlet {
    public static final String MULTIPART_RESOLVER_BEAN_NAME = "multipartResolver";
    public static final String LOCALE_RESOLVER_BEAN_NAME = "localeResolver";
    public static final String THEME_RESOLVER_BEAN_NAME = "themeResolver";
    public static final String HANDLER_MAPPING_BEAN_NAME = "handlerMapping";
    public static final String HANDLER_ADAPTER_BEAN_NAME = "handlerAdapter";
    public static final String HANDLER_EXCEPTION_RESOLVER_BEAN_NAME = "handlerExceptionResolver";
    public static final String REQUEST_TO_VIEW_NAME_TRANSLATOR_BEAN_NAME = "viewNameTranslator";
    public static final String VIEW_RESOLVER_BEAN_NAME = "viewResolver";
    public static final String FLASH_MAP_MANAGER_BEAN_NAME = "flashMapManager";
    public static final String WEB_APPLICATION_CONTEXT_ATTRIBUTE = DispatcherServlet.class.getName() + ".CONTEXT";
    public static final String LOCALE_RESOLVER_ATTRIBUTE = DispatcherServlet.class.getName() + ".LOCALE_RESOLVER";
    public static final String THEME_RESOLVER_ATTRIBUTE = DispatcherServlet.class.getName() + ".THEME_RESOLVER";
    public static final String THEME_SOURCE_ATTRIBUTE = DispatcherServlet.class.getName() + ".THEME_SOURCE";
    public static final String INPUT_FLASH_MAP_ATTRIBUTE = DispatcherServlet.class.getName() + ".INPUT_FLASH_MAP";
    public static final String OUTPUT_FLASH_MAP_ATTRIBUTE = DispatcherServlet.class.getName() + ".OUTPUT_FLASH_MAP";
    public static final String FLASH_MAP_MANAGER_ATTRIBUTE = DispatcherServlet.class.getName() + ".FLASH_MAP_MANAGER";
    public static final String EXCEPTION_ATTRIBUTE = DispatcherServlet.class.getName() + ".EXCEPTION";
    public static final String PAGE_NOT_FOUND_LOG_CATEGORY = "org.springframework.web.servlet.PageNotFound";
    private static final String DEFAULT_STRATEGIES_PATH = "DispatcherServlet.properties";
    protected static final Log pageNotFoundLogger = LogFactory.getLog((String)"org.springframework.web.servlet.PageNotFound");
    private static final Properties defaultStrategies;
    private boolean detectAllHandlerMappings = true;
    private boolean detectAllHandlerAdapters = true;
    private boolean detectAllHandlerExceptionResolvers = true;
    private boolean detectAllViewResolvers = true;
    private boolean throwExceptionIfNoHandlerFound = false;
    private boolean cleanupAfterInclude = true;
    private MultipartResolver multipartResolver;
    private LocaleResolver localeResolver;
    private ThemeResolver themeResolver;
    private List<HandlerMapping> handlerMappings;
    private List<HandlerAdapter> handlerAdapters;
    private List<HandlerExceptionResolver> handlerExceptionResolvers;
    private RequestToViewNameTranslator viewNameTranslator;
    private FlashMapManager flashMapManager;
    private List<ViewResolver> viewResolvers;

    public DispatcherServlet() {
    }

    public DispatcherServlet(WebApplicationContext webApplicationContext) {
        super(webApplicationContext);
    }

    public void setDetectAllHandlerMappings(boolean detectAllHandlerMappings) {
        this.detectAllHandlerMappings = detectAllHandlerMappings;
    }

    public void setDetectAllHandlerAdapters(boolean detectAllHandlerAdapters) {
        this.detectAllHandlerAdapters = detectAllHandlerAdapters;
    }

    public void setDetectAllHandlerExceptionResolvers(boolean detectAllHandlerExceptionResolvers) {
        this.detectAllHandlerExceptionResolvers = detectAllHandlerExceptionResolvers;
    }

    public void setDetectAllViewResolvers(boolean detectAllViewResolvers) {
        this.detectAllViewResolvers = detectAllViewResolvers;
    }

    public void setThrowExceptionIfNoHandlerFound(boolean throwExceptionIfNoHandlerFound) {
        this.throwExceptionIfNoHandlerFound = throwExceptionIfNoHandlerFound;
    }

    public void setCleanupAfterInclude(boolean cleanupAfterInclude) {
        this.cleanupAfterInclude = cleanupAfterInclude;
    }

    @Override
    protected void onRefresh(ApplicationContext context) {
        this.initStrategies(context);
    }

    protected void initStrategies(ApplicationContext context) {
        this.initMultipartResolver(context);
        this.initLocaleResolver(context);
        this.initThemeResolver(context);
        this.initHandlerMappings(context);
        this.initHandlerAdapters(context);
        this.initHandlerExceptionResolvers(context);
        this.initRequestToViewNameTranslator(context);
        this.initViewResolvers(context);
        this.initFlashMapManager(context);
    }

    private void initMultipartResolver(ApplicationContext context) {
        block3: {
            try {
                this.multipartResolver = (MultipartResolver)context.getBean(MULTIPART_RESOLVER_BEAN_NAME, MultipartResolver.class);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Using MultipartResolver [" + this.multipartResolver + "]"));
                }
            }
            catch (NoSuchBeanDefinitionException ex) {
                this.multipartResolver = null;
                if (!this.logger.isDebugEnabled()) break block3;
                this.logger.debug((Object)"Unable to locate MultipartResolver with name 'multipartResolver': no multipart request handling provided");
            }
        }
    }

    private void initLocaleResolver(ApplicationContext context) {
        block3: {
            try {
                this.localeResolver = (LocaleResolver)context.getBean(LOCALE_RESOLVER_BEAN_NAME, LocaleResolver.class);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Using LocaleResolver [" + this.localeResolver + "]"));
                }
            }
            catch (NoSuchBeanDefinitionException ex) {
                this.localeResolver = this.getDefaultStrategy(context, LocaleResolver.class);
                if (!this.logger.isDebugEnabled()) break block3;
                this.logger.debug((Object)("Unable to locate LocaleResolver with name 'localeResolver': using default [" + this.localeResolver + "]"));
            }
        }
    }

    private void initThemeResolver(ApplicationContext context) {
        block3: {
            try {
                this.themeResolver = (ThemeResolver)context.getBean(THEME_RESOLVER_BEAN_NAME, ThemeResolver.class);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Using ThemeResolver [" + this.themeResolver + "]"));
                }
            }
            catch (NoSuchBeanDefinitionException ex) {
                this.themeResolver = this.getDefaultStrategy(context, ThemeResolver.class);
                if (!this.logger.isDebugEnabled()) break block3;
                this.logger.debug((Object)("Unable to locate ThemeResolver with name 'themeResolver': using default [" + this.themeResolver + "]"));
            }
        }
    }

    private void initHandlerMappings(ApplicationContext context) {
        this.handlerMappings = null;
        if (this.detectAllHandlerMappings) {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, HandlerMapping.class, (boolean)true, (boolean)false);
            if (!matchingBeans.isEmpty()) {
                this.handlerMappings = new ArrayList(matchingBeans.values());
                OrderComparator.sort(this.handlerMappings);
            }
        } else {
            try {
                HandlerMapping hm = (HandlerMapping)context.getBean(HANDLER_MAPPING_BEAN_NAME, HandlerMapping.class);
                this.handlerMappings = Collections.singletonList(hm);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        if (this.handlerMappings == null) {
            this.handlerMappings = this.getDefaultStrategies(context, HandlerMapping.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No HandlerMappings found in servlet '" + this.getServletName() + "': using default"));
            }
        }
    }

    private void initHandlerAdapters(ApplicationContext context) {
        this.handlerAdapters = null;
        if (this.detectAllHandlerAdapters) {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, HandlerAdapter.class, (boolean)true, (boolean)false);
            if (!matchingBeans.isEmpty()) {
                this.handlerAdapters = new ArrayList(matchingBeans.values());
                OrderComparator.sort(this.handlerAdapters);
            }
        } else {
            try {
                HandlerAdapter ha = (HandlerAdapter)context.getBean(HANDLER_ADAPTER_BEAN_NAME, HandlerAdapter.class);
                this.handlerAdapters = Collections.singletonList(ha);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        if (this.handlerAdapters == null) {
            this.handlerAdapters = this.getDefaultStrategies(context, HandlerAdapter.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No HandlerAdapters found in servlet '" + this.getServletName() + "': using default"));
            }
        }
    }

    private void initHandlerExceptionResolvers(ApplicationContext context) {
        this.handlerExceptionResolvers = null;
        if (this.detectAllHandlerExceptionResolvers) {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, HandlerExceptionResolver.class, (boolean)true, (boolean)false);
            if (!matchingBeans.isEmpty()) {
                this.handlerExceptionResolvers = new ArrayList(matchingBeans.values());
                OrderComparator.sort(this.handlerExceptionResolvers);
            }
        } else {
            try {
                HandlerExceptionResolver her = (HandlerExceptionResolver)context.getBean(HANDLER_EXCEPTION_RESOLVER_BEAN_NAME, HandlerExceptionResolver.class);
                this.handlerExceptionResolvers = Collections.singletonList(her);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        if (this.handlerExceptionResolvers == null) {
            this.handlerExceptionResolvers = this.getDefaultStrategies(context, HandlerExceptionResolver.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No HandlerExceptionResolvers found in servlet '" + this.getServletName() + "': using default"));
            }
        }
    }

    private void initRequestToViewNameTranslator(ApplicationContext context) {
        block3: {
            try {
                this.viewNameTranslator = (RequestToViewNameTranslator)context.getBean(REQUEST_TO_VIEW_NAME_TRANSLATOR_BEAN_NAME, RequestToViewNameTranslator.class);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Using RequestToViewNameTranslator [" + this.viewNameTranslator + "]"));
                }
            }
            catch (NoSuchBeanDefinitionException ex) {
                this.viewNameTranslator = this.getDefaultStrategy(context, RequestToViewNameTranslator.class);
                if (!this.logger.isDebugEnabled()) break block3;
                this.logger.debug((Object)("Unable to locate RequestToViewNameTranslator with name 'viewNameTranslator': using default [" + this.viewNameTranslator + "]"));
            }
        }
    }

    private void initViewResolvers(ApplicationContext context) {
        this.viewResolvers = null;
        if (this.detectAllViewResolvers) {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, ViewResolver.class, (boolean)true, (boolean)false);
            if (!matchingBeans.isEmpty()) {
                this.viewResolvers = new ArrayList(matchingBeans.values());
                OrderComparator.sort(this.viewResolvers);
            }
        } else {
            try {
                ViewResolver vr = (ViewResolver)context.getBean(VIEW_RESOLVER_BEAN_NAME, ViewResolver.class);
                this.viewResolvers = Collections.singletonList(vr);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        if (this.viewResolvers == null) {
            this.viewResolvers = this.getDefaultStrategies(context, ViewResolver.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No ViewResolvers found in servlet '" + this.getServletName() + "': using default"));
            }
        }
    }

    private void initFlashMapManager(ApplicationContext context) {
        block3: {
            try {
                this.flashMapManager = (FlashMapManager)context.getBean(FLASH_MAP_MANAGER_BEAN_NAME, FlashMapManager.class);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Using FlashMapManager [" + this.flashMapManager + "]"));
                }
            }
            catch (NoSuchBeanDefinitionException ex) {
                this.flashMapManager = this.getDefaultStrategy(context, FlashMapManager.class);
                if (!this.logger.isDebugEnabled()) break block3;
                this.logger.debug((Object)("Unable to locate FlashMapManager with name 'flashMapManager': using default [" + this.flashMapManager + "]"));
            }
        }
    }

    public final ThemeSource getThemeSource() {
        if (this.getWebApplicationContext() instanceof ThemeSource) {
            return (ThemeSource)this.getWebApplicationContext();
        }
        return null;
    }

    public final MultipartResolver getMultipartResolver() {
        return this.multipartResolver;
    }

    protected <T> T getDefaultStrategy(ApplicationContext context, Class<T> strategyInterface) {
        List<T> strategies = this.getDefaultStrategies(context, strategyInterface);
        if (strategies.size() != 1) {
            throw new BeanInitializationException("DispatcherServlet needs exactly 1 strategy for interface [" + strategyInterface.getName() + "]");
        }
        return strategies.get(0);
    }

    protected <T> List<T> getDefaultStrategies(ApplicationContext context, Class<T> strategyInterface) {
        String key = strategyInterface.getName();
        String value = defaultStrategies.getProperty(key);
        if (value != null) {
            String[] classNames = StringUtils.commaDelimitedListToStringArray((String)value);
            ArrayList<Object> strategies = new ArrayList<Object>(classNames.length);
            for (String className : classNames) {
                try {
                    Class clazz = ClassUtils.forName((String)className, (ClassLoader)DispatcherServlet.class.getClassLoader());
                    Object strategy = this.createDefaultStrategy(context, clazz);
                    strategies.add(strategy);
                }
                catch (ClassNotFoundException ex) {
                    throw new BeanInitializationException("Could not find DispatcherServlet's default strategy class [" + className + "] for interface [" + key + "]", (Throwable)ex);
                }
                catch (LinkageError err) {
                    throw new BeanInitializationException("Error loading DispatcherServlet's default strategy class [" + className + "] for interface [" + key + "]: problem with class file or dependent class", (Throwable)err);
                }
            }
            return strategies;
        }
        return new LinkedList();
    }

    protected Object createDefaultStrategy(ApplicationContext context, Class<?> clazz) {
        return context.getAutowireCapableBeanFactory().createBean(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doService(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.logger.isDebugEnabled()) {
            String resumed = WebAsyncUtils.getAsyncManager((ServletRequest)request).hasConcurrentResult() ? " resumed" : "";
            this.logger.debug((Object)("DispatcherServlet with name '" + this.getServletName() + "'" + resumed + " processing " + request.getMethod() + " request for [" + DispatcherServlet.getRequestUri(request) + "]"));
        }
        HashMap<String, Object> attributesSnapshot = null;
        if (WebUtils.isIncludeRequest((ServletRequest)request)) {
            attributesSnapshot = new HashMap<String, Object>();
            Enumeration attrNames = request.getAttributeNames();
            while (attrNames.hasMoreElements()) {
                String attrName = (String)attrNames.nextElement();
                if (!this.cleanupAfterInclude && !attrName.startsWith("org.springframework.web.servlet")) continue;
                attributesSnapshot.put(attrName, request.getAttribute(attrName));
            }
        }
        request.setAttribute(WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)this.getWebApplicationContext());
        request.setAttribute(LOCALE_RESOLVER_ATTRIBUTE, (Object)this.localeResolver);
        request.setAttribute(THEME_RESOLVER_ATTRIBUTE, (Object)this.themeResolver);
        request.setAttribute(THEME_SOURCE_ATTRIBUTE, (Object)this.getThemeSource());
        FlashMap inputFlashMap = this.flashMapManager.retrieveAndUpdate(request, response);
        if (inputFlashMap != null) {
            request.setAttribute(INPUT_FLASH_MAP_ATTRIBUTE, Collections.unmodifiableMap(inputFlashMap));
        }
        request.setAttribute(OUTPUT_FLASH_MAP_ATTRIBUTE, (Object)new FlashMap());
        request.setAttribute(FLASH_MAP_MANAGER_ATTRIBUTE, (Object)this.flashMapManager);
        try {
            this.doDispatch(request, response);
        }
        finally {
            if (!WebAsyncUtils.getAsyncManager((ServletRequest)request).isConcurrentHandlingStarted() && attributesSnapshot != null) {
                this.restoreAttributesAfterInclude(request, attributesSnapshot);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDispatch(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpServletRequest processedRequest = request;
        HandlerExecutionChain mappedHandler = null;
        boolean multipartRequestParsed = false;
        WebAsyncManager asyncManager = WebAsyncUtils.getAsyncManager((ServletRequest)request);
        try {
            Exception dispatchException;
            ModelAndView mv;
            block23: {
                mv = null;
                dispatchException = null;
                processedRequest = this.checkMultipart(request);
                multipartRequestParsed = processedRequest != request;
                mappedHandler = this.getHandler(processedRequest);
                if (mappedHandler != null && mappedHandler.getHandler() != null) break block23;
                this.noHandlerFound(processedRequest, response);
                return;
            }
            HandlerAdapter ha = this.getHandlerAdapter(mappedHandler.getHandler());
            String method = request.getMethod();
            boolean isGet = "GET".equals(method);
            if (isGet || "HEAD".equals(method)) {
                long lastModified = ha.getLastModified(request, mappedHandler.getHandler());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Last-Modified value for [" + DispatcherServlet.getRequestUri(request) + "] is: " + lastModified));
                }
                if (new ServletWebRequest(request, response).checkNotModified(lastModified) && isGet) {
                    return;
                }
            }
            if (!mappedHandler.applyPreHandle(processedRequest, response)) {
                return;
            }
            mv = ha.handle(processedRequest, response, mappedHandler.getHandler());
            if (asyncManager.isConcurrentHandlingStarted()) {
                return;
            }
            try {
                this.applyDefaultViewName(request, mv);
                mappedHandler.applyPostHandle(processedRequest, response, mv);
            }
            catch (Exception ex) {
                dispatchException = ex;
            }
            this.processDispatchResult(processedRequest, response, mappedHandler, mv, dispatchException);
        }
        catch (Exception ex) {
            this.triggerAfterCompletion(processedRequest, response, mappedHandler, ex);
        }
        catch (Error err) {
            this.triggerAfterCompletionWithError(processedRequest, response, mappedHandler, err);
        }
        finally {
            if (asyncManager.isConcurrentHandlingStarted()) {
                if (mappedHandler != null) {
                    mappedHandler.applyAfterConcurrentHandlingStarted(processedRequest, response);
                }
            } else if (multipartRequestParsed) {
                this.cleanupMultipart(processedRequest);
            }
        }
    }

    private void applyDefaultViewName(HttpServletRequest request, ModelAndView mv) throws Exception {
        if (mv != null && !mv.hasView()) {
            mv.setViewName(this.getDefaultViewName(request));
        }
    }

    private void processDispatchResult(HttpServletRequest request, HttpServletResponse response, HandlerExecutionChain mappedHandler, ModelAndView mv, Exception exception) throws Exception {
        boolean errorView = false;
        if (exception != null) {
            if (exception instanceof ModelAndViewDefiningException) {
                this.logger.debug((Object)"ModelAndViewDefiningException encountered", (Throwable)exception);
                mv = ((ModelAndViewDefiningException)((Object)exception)).getModelAndView();
            } else {
                Object handler = mappedHandler != null ? mappedHandler.getHandler() : null;
                mv = this.processHandlerException(request, response, handler, exception);
                boolean bl = errorView = mv != null;
            }
        }
        if (mv != null && !mv.wasCleared()) {
            this.render(mv, request, response);
            if (errorView) {
                WebUtils.clearErrorRequestAttributes((HttpServletRequest)request);
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Null ModelAndView returned to DispatcherServlet with name '" + this.getServletName() + "': assuming HandlerAdapter completed request handling"));
        }
        if (WebAsyncUtils.getAsyncManager((ServletRequest)request).isConcurrentHandlingStarted()) {
            return;
        }
        if (mappedHandler != null) {
            mappedHandler.triggerAfterCompletion(request, response, null);
        }
    }

    @Override
    protected LocaleContext buildLocaleContext(final HttpServletRequest request) {
        if (this.localeResolver instanceof LocaleContextResolver) {
            return ((LocaleContextResolver)this.localeResolver).resolveLocaleContext(request);
        }
        return new LocaleContext(){

            public Locale getLocale() {
                return DispatcherServlet.this.localeResolver.resolveLocale(request);
            }
        };
    }

    protected HttpServletRequest checkMultipart(HttpServletRequest request) throws MultipartException {
        if (this.multipartResolver != null && this.multipartResolver.isMultipart(request)) {
            if (WebUtils.getNativeRequest((ServletRequest)request, MultipartHttpServletRequest.class) != null) {
                this.logger.debug((Object)"Request is already a MultipartHttpServletRequest - if not in a forward, this typically results from an additional MultipartFilter in web.xml");
            } else if (request.getAttribute("javax.servlet.error.exception") instanceof MultipartException) {
                this.logger.debug((Object)"Multipart resolution failed for current request before - skipping re-resolution for undisturbed error rendering");
            } else {
                return this.multipartResolver.resolveMultipart(request);
            }
        }
        return request;
    }

    protected void cleanupMultipart(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)WebUtils.getNativeRequest((ServletRequest)request, MultipartHttpServletRequest.class);
        if (multipartRequest != null) {
            this.multipartResolver.cleanupMultipart(multipartRequest);
        }
    }

    protected HandlerExecutionChain getHandler(HttpServletRequest request) throws Exception {
        for (HandlerMapping hm : this.handlerMappings) {
            HandlerExecutionChain handler;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Testing handler map [" + hm + "] in DispatcherServlet with name '" + this.getServletName() + "'"));
            }
            if ((handler = hm.getHandler(request)) == null) continue;
            return handler;
        }
        return null;
    }

    protected void noHandlerFound(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (pageNotFoundLogger.isWarnEnabled()) {
            pageNotFoundLogger.warn((Object)("No mapping found for HTTP request with URI [" + DispatcherServlet.getRequestUri(request) + "] in DispatcherServlet with name '" + this.getServletName() + "'"));
        }
        if (this.throwExceptionIfNoHandlerFound) {
            ServletServerHttpRequest sshr = new ServletServerHttpRequest(request);
            throw new NoHandlerFoundException(sshr.getMethod().name(), sshr.getServletRequest().getRequestURI(), sshr.getHeaders());
        }
        response.sendError(404);
    }

    protected HandlerAdapter getHandlerAdapter(Object handler) throws ServletException {
        for (HandlerAdapter ha : this.handlerAdapters) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Testing handler adapter [" + ha + "]"));
            }
            if (!ha.supports(handler)) continue;
            return ha;
        }
        throw new ServletException("No adapter for handler [" + handler + "]: The DispatcherServlet configuration needs to include a HandlerAdapter that supports this handler");
    }

    protected ModelAndView processHandlerException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        HandlerExceptionResolver handlerExceptionResolver;
        ModelAndView exMv = null;
        Iterator<HandlerExceptionResolver> iterator = this.handlerExceptionResolvers.iterator();
        while (iterator.hasNext() && (exMv = (handlerExceptionResolver = iterator.next()).resolveException(request, response, handler, ex)) == null) {
        }
        if (exMv != null) {
            if (exMv.isEmpty()) {
                request.setAttribute(EXCEPTION_ATTRIBUTE, (Object)ex);
                return null;
            }
            if (!exMv.hasView()) {
                exMv.setViewName(this.getDefaultViewName(request));
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Handler execution resulted in exception - forwarding to resolved error view: " + exMv), (Throwable)ex);
            }
            WebUtils.exposeErrorRequestAttributes((HttpServletRequest)request, (Throwable)ex, (String)this.getServletName());
            return exMv;
        }
        throw ex;
    }

    protected void render(ModelAndView mv, HttpServletRequest request, HttpServletResponse response) throws Exception {
        View view;
        Locale locale = this.localeResolver.resolveLocale(request);
        response.setLocale(locale);
        if (mv.isReference()) {
            view = this.resolveViewName(mv.getViewName(), mv.getModelInternal(), locale, request);
            if (view == null) {
                throw new ServletException("Could not resolve view with name '" + mv.getViewName() + "' in servlet with name '" + this.getServletName() + "'");
            }
        } else {
            view = mv.getView();
            if (view == null) {
                throw new ServletException("ModelAndView [" + mv + "] neither contains a view name nor a " + "View object in servlet with name '" + this.getServletName() + "'");
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Rendering view [" + view + "] in DispatcherServlet with name '" + this.getServletName() + "'"));
        }
        try {
            view.render(mv.getModelInternal(), request, response);
        }
        catch (Exception ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Error rendering view [" + view + "] in DispatcherServlet with name '" + this.getServletName() + "'"), (Throwable)ex);
            }
            throw ex;
        }
    }

    protected String getDefaultViewName(HttpServletRequest request) throws Exception {
        return this.viewNameTranslator.getViewName(request);
    }

    protected View resolveViewName(String viewName, Map<String, Object> model, Locale locale, HttpServletRequest request) throws Exception {
        for (ViewResolver viewResolver : this.viewResolvers) {
            View view = viewResolver.resolveViewName(viewName, locale);
            if (view == null) continue;
            return view;
        }
        return null;
    }

    private void triggerAfterCompletion(HttpServletRequest request, HttpServletResponse response, HandlerExecutionChain mappedHandler, Exception ex) throws Exception {
        if (mappedHandler != null) {
            mappedHandler.triggerAfterCompletion(request, response, ex);
        }
        throw ex;
    }

    private void triggerAfterCompletionWithError(HttpServletRequest request, HttpServletResponse response, HandlerExecutionChain mappedHandler, Error error) throws Exception {
        NestedServletException ex = new NestedServletException("Handler processing failed", (Throwable)error);
        if (mappedHandler != null) {
            mappedHandler.triggerAfterCompletion(request, response, (Exception)ex);
        }
        throw ex;
    }

    private void restoreAttributesAfterInclude(HttpServletRequest request, Map<?, ?> attributesSnapshot) {
        HashSet<String> attrsToCheck = new HashSet<String>();
        Enumeration attrNames = request.getAttributeNames();
        while (attrNames.hasMoreElements()) {
            String attrName = (String)attrNames.nextElement();
            if (!this.cleanupAfterInclude && !attrName.startsWith("org.springframework.web.servlet")) continue;
            attrsToCheck.add(attrName);
        }
        attrsToCheck.addAll(attributesSnapshot.keySet());
        for (String attrName : attrsToCheck) {
            Object attrValue = attributesSnapshot.get(attrName);
            if (attrValue == null) {
                request.removeAttribute(attrName);
                continue;
            }
            if (attrValue == request.getAttribute(attrName)) continue;
            request.setAttribute(attrName, attrValue);
        }
    }

    private static String getRequestUri(HttpServletRequest request) {
        String uri = (String)request.getAttribute("javax.servlet.include.request_uri");
        if (uri == null) {
            uri = request.getRequestURI();
        }
        return uri;
    }

    static {
        try {
            ClassPathResource resource = new ClassPathResource(DEFAULT_STRATEGIES_PATH, DispatcherServlet.class);
            defaultStrategies = PropertiesLoaderUtils.loadProperties((Resource)resource);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Could not load 'DispatcherServlet.properties': " + ex.getMessage());
        }
    }
}

