/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import redis.clients.jedis.Client;
import redis.clients.jedis.MultiKeyPipelineBase;
import redis.clients.jedis.Response;
import redis.clients.jedis.exceptions.JedisDataException;

public class Transaction
extends MultiKeyPipelineBase
implements Closeable {
    protected boolean inTransaction = true;

    protected Transaction() {
    }

    public Transaction(Client client) {
        this.client = client;
    }

    @Override
    protected Client getClient(String key) {
        return this.client;
    }

    @Override
    protected Client getClient(byte[] key) {
        return this.client;
    }

    public void clear() {
        if (this.inTransaction) {
            this.discard();
        }
    }

    public List<Object> exec() {
        this.client.exec();
        this.client.getAll(1);
        this.inTransaction = false;
        List<Object> unformatted = this.client.getObjectMultiBulkReply();
        if (unformatted == null) {
            return null;
        }
        ArrayList<Object> formatted = new ArrayList<Object>();
        for (Object o : unformatted) {
            try {
                formatted.add(this.generateResponse(o).get());
            }
            catch (JedisDataException e) {
                formatted.add(e);
            }
        }
        return formatted;
    }

    public List<Response<?>> execGetResponse() {
        this.client.exec();
        this.client.getAll(1);
        this.inTransaction = false;
        List<Object> unformatted = this.client.getObjectMultiBulkReply();
        if (unformatted == null) {
            return null;
        }
        ArrayList response = new ArrayList();
        for (Object o : unformatted) {
            response.add(this.generateResponse(o));
        }
        return response;
    }

    public String discard() {
        this.client.discard();
        this.client.getAll(1);
        this.inTransaction = false;
        this.clean();
        return this.client.getStatusCodeReply();
    }

    @Override
    public void close() throws IOException {
        this.clear();
    }
}

