/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.Request;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.codec.binary.Base64;

public class BasicAuthenticator
extends AuthenticatorBase {
    private static final Log log = LogFactory.getLog(BasicAuthenticator.class);

    @Override
    public boolean authenticate(Request request, HttpServletResponse response) throws IOException {
        block10: {
            MessageBytes authorization;
            Principal principal = request.getUserPrincipal();
            String ssoId = (String)request.getNote("org.apache.catalina.request.SSOID");
            if (principal != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Already authenticated '" + principal.getName() + "'"));
                }
                if (ssoId != null) {
                    this.associate(ssoId, request.getSessionInternal(true));
                }
                return true;
            }
            if (ssoId != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("SSO Id " + ssoId + " set; attempting " + "reauthentication"));
                }
                if (this.reauthenticateFromSSO(ssoId, request)) {
                    return true;
                }
            }
            if ((authorization = request.getCoyoteRequest().getMimeHeaders().getValue("authorization")) != null) {
                authorization.toBytes();
                ByteChunk authorizationBC = authorization.getByteChunk();
                BasicCredentials credentials = null;
                try {
                    credentials = new BasicCredentials(authorizationBC);
                    String username = credentials.getUsername();
                    String password = credentials.getPassword();
                    principal = this.context.getRealm().authenticate(username, password);
                    if (principal != null) {
                        this.register(request, response, principal, "BASIC", username, password);
                        return true;
                    }
                }
                catch (IllegalArgumentException iae) {
                    if (!log.isDebugEnabled()) break block10;
                    log.debug((Object)("Invalid Authorization" + iae.getMessage()));
                }
            }
        }
        StringBuilder value = new StringBuilder(16);
        value.append("Basic realm=\"");
        value.append(BasicAuthenticator.getRealmName(this.context));
        value.append('\"');
        response.setHeader("WWW-Authenticate", value.toString());
        response.sendError(401);
        return false;
    }

    @Override
    protected String getAuthMethod() {
        return "BASIC";
    }

    protected static class BasicCredentials {
        private static final String METHOD = "basic ";
        private ByteChunk authorization;
        private int initialOffset;
        private int base64blobOffset;
        private int base64blobLength;
        private String username = null;
        private String password = null;

        public BasicCredentials(ByteChunk input) throws IllegalArgumentException {
            this.authorization = input;
            this.initialOffset = input.getOffset();
            this.parseMethod();
            byte[] decoded = this.parseBase64();
            this.parseCredentials(decoded);
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        private void parseMethod() throws IllegalArgumentException {
            if (!this.authorization.startsWithIgnoreCase(METHOD, 0)) {
                throw new IllegalArgumentException("Authorization header method is not \"Basic\"");
            }
            this.base64blobOffset = this.initialOffset + METHOD.length();
            this.base64blobLength = this.authorization.getLength() - METHOD.length();
        }

        private byte[] parseBase64() throws IllegalArgumentException {
            byte[] decoded = Base64.decodeBase64(this.authorization.getBuffer(), this.base64blobOffset, this.base64blobLength);
            this.authorization.setOffset(this.initialOffset);
            if (decoded == null) {
                throw new IllegalArgumentException("Basic Authorization credentials are not Base64");
            }
            return decoded;
        }

        private void parseCredentials(byte[] decoded) throws IllegalArgumentException {
            int colon = -1;
            for (int i = 0; i < decoded.length; ++i) {
                if (decoded[i] != 58) continue;
                colon = i;
                break;
            }
            if (colon < 0) {
                this.username = new String(decoded, StandardCharsets.ISO_8859_1);
            } else {
                this.username = new String(decoded, 0, colon, StandardCharsets.ISO_8859_1);
                this.password = new String(decoded, colon + 1, decoded.length - colon - 1, StandardCharsets.ISO_8859_1);
                if (this.password.length() > 1) {
                    this.password = this.password.trim();
                }
            }
            if (this.username.length() > 1) {
                this.username = this.username.trim();
            }
        }
    }
}

