/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ErrorState;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.http11.AbstractHttp11Processor;
import org.apache.coyote.http11.AbstractInputBuffer;
import org.apache.coyote.http11.AbstractOutputBuffer;
import org.apache.coyote.http11.InputFilter;
import org.apache.coyote.http11.InternalNio2InputBuffer;
import org.apache.coyote.http11.InternalNio2OutputBuffer;
import org.apache.coyote.http11.OutputFilter;
import org.apache.coyote.http11.filters.BufferedInputFilter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.Nio2Channel;
import org.apache.tomcat.util.net.Nio2Endpoint;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SecureNio2Channel;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class Http11Nio2Processor
extends AbstractHttp11Processor<Nio2Channel> {
    private static final Log log = LogFactory.getLog(Http11Nio2Processor.class);
    protected SSLSupport sslSupport;
    protected Nio2Endpoint.SendfileData sendfileData = null;

    @Override
    protected Log getLog() {
        return log;
    }

    public Http11Nio2Processor(int maxHttpHeaderSize, Nio2Endpoint endpoint, int maxTrailerSize, int maxExtensionSize, int maxSwallowSize) {
        super(endpoint);
        this.inputBuffer = new InternalNio2InputBuffer(this.request, maxHttpHeaderSize);
        this.request.setInputBuffer(this.inputBuffer);
        this.outputBuffer = new InternalNio2OutputBuffer(this.response, maxHttpHeaderSize);
        this.response.setOutputBuffer(this.outputBuffer);
        this.initializeFilters(maxTrailerSize, maxExtensionSize, maxSwallowSize);
    }

    @Override
    public AbstractEndpoint.Handler.SocketState event(SocketStatus status) throws IOException {
        long soTimeout = this.endpoint.getSoTimeout();
        RequestInfo rp = this.request.getRequestProcessor();
        try {
            rp.setStage(3);
            if (!this.getAdapter().event(this.request, this.response, status)) {
                this.setErrorState(ErrorState.CLOSE_NOW, null);
            }
            if (!this.getErrorState().isError() && this.socketWrapper != null) {
                this.socketWrapper.setComet(this.comet);
                if (this.comet) {
                    Integer comettimeout = (Integer)this.request.getAttribute("org.apache.tomcat.comet.timeout");
                    if (comettimeout != null) {
                        this.socketWrapper.setTimeout(comettimeout.longValue());
                    }
                } else if (this.keepAlive) {
                    this.socketWrapper.setTimeout(this.keepAliveTimeout);
                } else {
                    this.socketWrapper.setTimeout(soTimeout);
                }
            }
        }
        catch (InterruptedIOException e) {
            this.setErrorState(ErrorState.CLOSE_NOW, e);
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            this.response.setStatus(500);
            this.setErrorState(ErrorState.CLOSE_NOW, t);
            this.getAdapter().log(this.request, this.response, 0L);
            log.error((Object)sm.getString("http11processor.request.process"), t);
        }
        rp.setStage(7);
        if (this.getErrorState().isError() || status == SocketStatus.STOP) {
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        if (!this.comet) {
            if (this.keepAlive) {
                this.inputBuffer.nextRequest();
                this.outputBuffer.nextRequest();
                if (((InternalNio2InputBuffer)this.inputBuffer).isPending()) {
                    return AbstractEndpoint.Handler.SocketState.LONG;
                }
                return AbstractEndpoint.Handler.SocketState.OPEN;
            }
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        return AbstractEndpoint.Handler.SocketState.LONG;
    }

    @Override
    public AbstractEndpoint.Handler.SocketState asyncDispatch(SocketStatus status) {
        AbstractEndpoint.Handler.SocketState state = super.asyncDispatch(status);
        if (state == AbstractEndpoint.Handler.SocketState.OPEN && ((InternalNio2InputBuffer)this.inputBuffer).isPending()) {
            return AbstractEndpoint.Handler.SocketState.LONG;
        }
        return state;
    }

    @Override
    protected void registerForEvent(boolean read, boolean write) {
        if (read) {
            ((InternalNio2InputBuffer)this.inputBuffer).registerReadInterest();
        }
        if (write) {
            ((InternalNio2OutputBuffer)this.outputBuffer).registerWriteInterest();
        }
    }

    @Override
    protected void resetTimeouts() {
        if (!this.getErrorState().isError() && this.socketWrapper != null && this.asyncStateMachine.isAsyncDispatching()) {
            long soTimeout = this.endpoint.getSoTimeout();
            if (this.keepAlive) {
                this.socketWrapper.setTimeout(this.keepAliveTimeout);
            } else {
                this.socketWrapper.setTimeout(soTimeout);
            }
        }
    }

    @Override
    protected boolean disableKeepAlive() {
        return false;
    }

    @Override
    protected void setRequestLineReadTimeout() throws IOException {
    }

    @Override
    protected boolean handleIncompleteRequestLineRead() {
        this.openSocket = true;
        if (((InternalNio2InputBuffer)this.inputBuffer).getParsingRequestLinePhase() < 1) {
            if (this.socketWrapper.getLastAccess() > -1L || this.keptAlive) {
                this.socketWrapper.setTimeout(this.endpoint.getKeepAliveTimeout());
            }
        } else {
            if (this.request.getStartTime() < 0L) {
                this.request.setStartTime(System.currentTimeMillis());
            }
            if (this.endpoint.isPaused()) {
                this.response.setStatus(503);
                this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                this.getAdapter().log(this.request, this.response, 0L);
                return false;
            }
            this.readComplete = false;
            this.socketWrapper.setTimeout(this.endpoint.getSoTimeout());
        }
        return true;
    }

    @Override
    protected void setSocketTimeout(int timeout) throws IOException {
        this.socketWrapper.setTimeout(timeout);
    }

    @Override
    protected void setCometTimeouts(SocketWrapper<Nio2Channel> socketWrapper) {
        if (socketWrapper != null) {
            Integer comettimeout;
            socketWrapper.setComet(this.comet);
            if (this.comet && (comettimeout = (Integer)this.request.getAttribute("org.apache.tomcat.comet.timeout")) != null) {
                socketWrapper.setTimeout(comettimeout.longValue());
            }
        }
    }

    @Override
    protected boolean breakKeepAliveLoop(SocketWrapper<Nio2Channel> socketWrapper) {
        this.openSocket = this.keepAlive;
        if (this.sendfileData != null && !this.getErrorState().isError()) {
            ((Nio2Endpoint.Nio2SocketWrapper)socketWrapper).setSendfileData(this.sendfileData);
            this.sendfileData.keepAlive = this.keepAlive;
            switch (((Nio2Endpoint)this.endpoint).processSendfile((Nio2Endpoint.Nio2SocketWrapper)socketWrapper)) {
                case DONE: {
                    return false;
                }
                case ERROR: {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("http11processor.sendfile.error"));
                    }
                    this.setErrorState(ErrorState.CLOSE_NOW, null);
                    return true;
                }
                case PENDING: {
                    this.sendfileInProgress = true;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void recycleInternal() {
        this.socketWrapper = null;
        this.sendfileData = null;
    }

    @Override
    public void actionInternal(ActionCode actionCode, Object param) {
        switch (actionCode) {
            case REQ_HOST_ADDR_ATTRIBUTE: {
                if (this.socketWrapper == null || this.socketWrapper.getSocket() == null) {
                    this.request.remoteAddr().recycle();
                    break;
                }
                if (this.socketWrapper.getRemoteAddr() == null) {
                    InetAddress inetAddr = null;
                    try {
                        inetAddr = ((InetSocketAddress)((Nio2Channel)this.socketWrapper.getSocket()).getIOChannel().getRemoteAddress()).getAddress();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    if (inetAddr != null) {
                        this.socketWrapper.setRemoteAddr(inetAddr.getHostAddress());
                    }
                }
                this.request.remoteAddr().setString(this.socketWrapper.getRemoteAddr());
                break;
            }
            case REQ_LOCAL_NAME_ATTRIBUTE: {
                if (this.socketWrapper == null || this.socketWrapper.getSocket() == null) {
                    this.request.localName().recycle();
                    break;
                }
                if (this.socketWrapper.getLocalName() == null) {
                    InetAddress inetAddr = null;
                    try {
                        inetAddr = ((InetSocketAddress)((Nio2Channel)this.socketWrapper.getSocket()).getIOChannel().getLocalAddress()).getAddress();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    if (inetAddr != null) {
                        this.socketWrapper.setLocalName(inetAddr.getHostName());
                    }
                }
                this.request.localName().setString(this.socketWrapper.getLocalName());
                break;
            }
            case REQ_HOST_ATTRIBUTE: {
                if (this.socketWrapper == null || this.socketWrapper.getSocket() == null) {
                    this.request.remoteHost().recycle();
                    break;
                }
                if (this.socketWrapper.getRemoteHost() == null) {
                    InetAddress inetAddr = null;
                    try {
                        inetAddr = ((InetSocketAddress)((Nio2Channel)this.socketWrapper.getSocket()).getIOChannel().getRemoteAddress()).getAddress();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    if (inetAddr != null) {
                        this.socketWrapper.setRemoteHost(inetAddr.getHostName());
                    }
                    if (this.socketWrapper.getRemoteHost() == null) {
                        if (this.socketWrapper.getRemoteAddr() == null && inetAddr != null) {
                            this.socketWrapper.setRemoteAddr(inetAddr.getHostAddress());
                        }
                        if (this.socketWrapper.getRemoteAddr() != null) {
                            this.socketWrapper.setRemoteHost(this.socketWrapper.getRemoteAddr());
                        }
                    }
                }
                this.request.remoteHost().setString(this.socketWrapper.getRemoteHost());
                break;
            }
            case REQ_LOCAL_ADDR_ATTRIBUTE: {
                if (this.socketWrapper == null || this.socketWrapper.getSocket() == null) {
                    this.request.localAddr().recycle();
                    break;
                }
                if (this.socketWrapper.getLocalAddr() == null) {
                    try {
                        this.socketWrapper.setLocalAddr(((InetSocketAddress)((Nio2Channel)this.socketWrapper.getSocket()).getIOChannel().getLocalAddress()).getAddress().getHostAddress());
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                this.request.localAddr().setString(this.socketWrapper.getLocalAddr());
                break;
            }
            case REQ_REMOTEPORT_ATTRIBUTE: {
                if (this.socketWrapper == null || this.socketWrapper.getSocket() == null) {
                    this.request.setRemotePort(0);
                    break;
                }
                if (this.socketWrapper.getRemotePort() == -1) {
                    try {
                        this.socketWrapper.setRemotePort(((InetSocketAddress)((Nio2Channel)this.socketWrapper.getSocket()).getIOChannel().getRemoteAddress()).getPort());
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                this.request.setRemotePort(this.socketWrapper.getRemotePort());
                break;
            }
            case REQ_LOCALPORT_ATTRIBUTE: {
                if (this.socketWrapper == null || this.socketWrapper.getSocket() == null) {
                    this.request.setLocalPort(0);
                    break;
                }
                if (this.socketWrapper.getLocalPort() == -1) {
                    try {
                        this.socketWrapper.setLocalPort(((InetSocketAddress)((Nio2Channel)this.socketWrapper.getSocket()).getIOChannel().getLocalAddress()).getPort());
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                this.request.setLocalPort(this.socketWrapper.getLocalPort());
                break;
            }
            case REQ_SSL_ATTRIBUTE: {
                try {
                    if (this.sslSupport == null) break;
                    Object sslO = this.sslSupport.getCipherSuite();
                    if (sslO != null) {
                        this.request.setAttribute("javax.servlet.request.cipher_suite", sslO);
                    }
                    if ((sslO = this.sslSupport.getPeerCertificateChain(false)) != null) {
                        this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                    }
                    if ((sslO = this.sslSupport.getKeySize()) != null) {
                        this.request.setAttribute("javax.servlet.request.key_size", sslO);
                    }
                    if ((sslO = this.sslSupport.getSessionId()) != null) {
                        this.request.setAttribute("javax.servlet.request.ssl_session_id", sslO);
                    }
                    this.request.setAttribute("javax.servlet.request.ssl_session_mgr", this.sslSupport);
                }
                catch (Exception e) {
                    log.warn((Object)sm.getString("http11processor.socket.ssl"), (Throwable)e);
                }
                break;
            }
            case REQ_SSL_CERTIFICATE: {
                if (this.sslSupport == null || this.socketWrapper.getSocket() == null) break;
                InputFilter[] inputFilters = this.inputBuffer.getFilters();
                ((BufferedInputFilter)inputFilters[3]).setLimit(this.maxSavePostSize);
                this.inputBuffer.addActiveFilter(inputFilters[3]);
                SecureNio2Channel sslChannel = (SecureNio2Channel)this.socketWrapper.getSocket();
                SSLEngine engine = sslChannel.getSslEngine();
                if (!engine.getNeedClientAuth()) {
                    engine.setNeedClientAuth(true);
                    try {
                        sslChannel.rehandshake();
                        this.sslSupport = ((Nio2Endpoint)this.endpoint).getHandler().getSslImplementation().getSSLSupport(engine.getSession());
                    }
                    catch (IOException ioe) {
                        log.warn((Object)sm.getString("http11processor.socket.sslreneg"), (Throwable)ioe);
                    }
                }
                try {
                    X509Certificate[] sslO = this.sslSupport.getPeerCertificateChain(false);
                    if (sslO == null) break;
                    this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                }
                catch (Exception e) {
                    log.warn((Object)sm.getString("http11processor.socket.ssl"), (Throwable)e);
                }
                break;
            }
            case COMET_BEGIN: {
                this.comet = true;
                break;
            }
            case COMET_END: {
                this.comet = false;
                break;
            }
            case COMET_CLOSE: {
                if (this.socketWrapper == null || this.socketWrapper.getSocket() == null) {
                    return;
                }
                RequestInfo rp = this.request.getRequestProcessor();
                if (rp.getStage() == 3) break;
                this.endpoint.processSocket(this.socketWrapper, SocketStatus.OPEN_READ, true);
                break;
            }
            case COMET_SETTIMEOUT: {
                if (param == null) {
                    return;
                }
                if (this.socketWrapper == null) {
                    return;
                }
                long timeout = (Long)param;
                RequestInfo rp = this.request.getRequestProcessor();
                if (rp.getStage() == 3) break;
                this.socketWrapper.setTimeout(timeout);
                break;
            }
        }
    }

    @Override
    protected void prepareRequestInternal() {
        this.sendfileData = null;
    }

    @Override
    protected boolean prepareSendfile(OutputFilter[] outputFilters) {
        String fileName = (String)this.request.getAttribute("org.apache.tomcat.sendfile.filename");
        if (fileName != null) {
            this.outputBuffer.addActiveFilter(outputFilters[2]);
            this.contentDelimitation = true;
            this.sendfileData = new Nio2Endpoint.SendfileData();
            this.sendfileData.fileName = fileName;
            this.sendfileData.pos = (Long)this.request.getAttribute("org.apache.tomcat.sendfile.start");
            this.sendfileData.length = (Long)this.request.getAttribute("org.apache.tomcat.sendfile.end") - this.sendfileData.pos;
            return true;
        }
        return false;
    }

    @Override
    protected AbstractInputBuffer<Nio2Channel> getInputBuffer() {
        return this.inputBuffer;
    }

    @Override
    protected AbstractOutputBuffer<Nio2Channel> getOutputBuffer() {
        return this.outputBuffer;
    }

    @Override
    public void setSslSupport(SSLSupport sslSupport) {
        this.sslSupport = sslSupport;
    }
}

