/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.model;

import com.aliyun.oss.internal.OSSUtils;

public class ListObjectsRequest {
    private String bucketName;
    private String prefix;
    private String marker;
    private Integer maxKeys;
    private String delimiter;

    public ListObjectsRequest() {
    }

    public ListObjectsRequest(String bucketName) {
        this(bucketName, null, null, null, null);
    }

    public ListObjectsRequest(String bucketName, String prefix, String marker, String delimiter, Integer maxKeys) {
        this.setBucketName(bucketName);
        this.setPrefix(prefix);
        this.setMarker(marker);
        this.setDelimiter(delimiter);
        if (maxKeys != null) {
            this.setMaxKeys(maxKeys);
        }
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        if (bucketName == null) {
            throw new NullPointerException();
        }
        if (!OSSUtils.validateBucketName(bucketName)) {
            throw new IllegalArgumentException();
        }
        this.bucketName = bucketName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public Integer getMaxKeys() {
        return this.maxKeys;
    }

    public void setMaxKeys(Integer maxKeys) {
        if (maxKeys < 0 || maxKeys > 1000) {
            throw new IllegalArgumentException(OSSUtils.OSS_RESOURCE_MANAGER.getString("MaxKeysOutOfRange"));
        }
        this.maxKeys = maxKeys;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }
}

