/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.remoting.transport.codec;

import com.alibaba.dubbo.common.serialize.ObjectInput;
import com.alibaba.dubbo.common.serialize.ObjectOutput;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.remoting.Channel;
import com.alibaba.dubbo.remoting.transport.AbstractCodec;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TransportCodec
extends AbstractCodec {
    public void encode(Channel channel, OutputStream output, Object message) throws IOException {
        ObjectOutput objectOutput = this.getSerialization(channel).serialize(channel.getUrl(), output);
        this.encodeData(channel, objectOutput, message);
        objectOutput.flushBuffer();
    }

    public Object decode(Channel channel, InputStream input) throws IOException {
        return this.decodeData(channel, this.getSerialization(channel).deserialize(channel.getUrl(), input));
    }

    protected void encodeData(Channel channel, ObjectOutput output, Object message) throws IOException {
        this.encodeData(output, message);
    }

    protected Object decodeData(Channel channel, ObjectInput input) throws IOException {
        return this.decodeData(input);
    }

    protected void encodeData(ObjectOutput output, Object message) throws IOException {
        output.writeObject(message);
    }

    protected Object decodeData(ObjectInput input) throws IOException {
        try {
            return input.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException("ClassNotFoundException: " + StringUtils.toString(e));
        }
    }
}

