/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public class TransmittableThreadLocal<T>
extends InheritableThreadLocal<T> {
    static InheritableThreadLocal<Map<TransmittableThreadLocal<?>, ?>> holder = new InheritableThreadLocal<Map<TransmittableThreadLocal<?>, ?>>(){

        @Override
        protected Map<TransmittableThreadLocal<?>, ?> initialValue() {
            return new WeakHashMap();
        }

        @Override
        protected Map<TransmittableThreadLocal<?>, ?> childValue(Map<TransmittableThreadLocal<?>, ?> parentValue) {
            return new WeakHashMap(parentValue);
        }
    };

    protected T copy(T parentValue) {
        return parentValue;
    }

    protected void beforeExecute() {
    }

    protected void afterExecute() {
    }

    @Override
    public final T get() {
        Object value = super.get();
        if (null != value) {
            this.addValue();
        }
        return value;
    }

    @Override
    public final void set(T value) {
        super.set(value);
        if (null == value) {
            this.removeValue();
        } else {
            this.addValue();
        }
    }

    @Override
    public final void remove() {
        this.removeValue();
        super.remove();
    }

    void superRemove() {
        super.remove();
    }

    T copyValue() {
        return this.copy(this.get());
    }

    void addValue() {
        if (!((Map)holder.get()).containsKey(this)) {
            ((Map)holder.get()).put(this, null);
        }
    }

    void removeValue() {
        ((Map)holder.get()).remove(this);
    }

    static Map<TransmittableThreadLocal<?>, Object> copy() {
        HashMap copy = new HashMap();
        for (TransmittableThreadLocal threadLocal : ((Map)holder.get()).keySet()) {
            copy.put(threadLocal, threadLocal.copyValue());
        }
        return copy;
    }

    static Map<TransmittableThreadLocal<?>, Object> backupAndSetToCopied(Map<TransmittableThreadLocal<?>, Object> copied) {
        TransmittableThreadLocal<?> threadLocal;
        HashMap backup = new HashMap();
        Iterator iterator = ((Map)holder.get()).entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            threadLocal = (TransmittableThreadLocal<?>)next.getKey();
            backup.put(threadLocal, threadLocal.get());
            if (copied.containsKey(threadLocal)) continue;
            iterator.remove();
            threadLocal.superRemove();
        }
        for (Map.Entry<TransmittableThreadLocal<?>, Object> entry : copied.entrySet()) {
            threadLocal = entry.getKey();
            threadLocal.set(entry.getValue());
        }
        TransmittableThreadLocal.doExecuteCallback(true);
        return backup;
    }

    static void restoreBackup(Map<TransmittableThreadLocal<?>, Object> backup) {
        TransmittableThreadLocal<?> threadLocal;
        TransmittableThreadLocal.doExecuteCallback(false);
        Iterator iterator = ((Map)holder.get()).entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            threadLocal = (TransmittableThreadLocal<?>)next.getKey();
            if (backup.containsKey(threadLocal)) continue;
            iterator.remove();
            threadLocal.superRemove();
        }
        for (Map.Entry<TransmittableThreadLocal<?>, Object> entry : backup.entrySet()) {
            threadLocal = entry.getKey();
            threadLocal.set(entry.getValue());
        }
    }

    private static void doExecuteCallback(boolean isBefore) {
        for (Map.Entry entry : ((Map)holder.get()).entrySet()) {
            TransmittableThreadLocal threadLocal = (TransmittableThreadLocal)entry.getKey();
            try {
                if (isBefore) {
                    threadLocal.beforeExecute();
                    continue;
                }
                threadLocal.afterExecute();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    static void dump(String title) {
        if (title != null && title.length() > 0) {
            System.out.printf("Start TransmittableThreadLocal[%s] Dump...\n", title);
        } else {
            System.out.println("Start TransmittableThreadLocal Dump...");
        }
        for (Map.Entry entry : ((Map)holder.get()).entrySet()) {
            TransmittableThreadLocal key = (TransmittableThreadLocal)entry.getKey();
            System.out.println(key.get());
        }
        System.out.println("TransmittableThreadLocal Dump end!");
    }

    static void dump() {
        TransmittableThreadLocal.dump(null);
    }
}

