/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.srp;

import com.google.common.base.Charsets;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.connection.DefaultTuple;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.util.Assert;
import redis.client.RedisException;
import redis.reply.BulkReply;
import redis.reply.IntegerReply;
import redis.reply.MultiBulkReply;
import redis.reply.Reply;
import redis.reply.StatusReply;

@Deprecated
abstract class SrpUtils {
    private static final byte[] ONE = new byte[]{49};
    private static final byte[] ZERO = new byte[]{48};
    private static final byte[] BEFORE = "BEFORE".getBytes(Charsets.UTF_8);
    private static final byte[] AFTER = "AFTER".getBytes(Charsets.UTF_8);
    static final byte[] WITHSCORES = "WITHSCORES".getBytes(Charsets.UTF_8);
    private static final byte[] SPACE = " ".getBytes(Charsets.UTF_8);
    private static final byte[] BY = "BY".getBytes(Charsets.UTF_8);
    private static final byte[] GET = "GET".getBytes(Charsets.UTF_8);
    private static final byte[] ALPHA = "ALPHA".getBytes(Charsets.UTF_8);
    private static final byte[] STORE = "STORE".getBytes(Charsets.UTF_8);

    SrpUtils() {
    }

    static DataAccessException convertSRedisAccessException(RuntimeException ex) {
        if (ex instanceof RedisException) {
            return new RedisSystemException("redis exception", ex);
        }
        return null;
    }

    static Properties info(BulkReply reply) {
        Properties info = new Properties();
        StringReader stringReader = new StringReader(new String(reply.data(), Charsets.UTF_8));
        try {
            info.load(stringReader);
        }
        catch (Exception ex) {
            throw new RedisSystemException("Cannot read Redis info", ex);
        }
        finally {
            stringReader.close();
        }
        return info;
    }

    static List<byte[]> toBytesList(Reply[] replies) {
        if (replies == null) {
            return null;
        }
        ArrayList<byte[]> list = new ArrayList<byte[]>(replies.length);
        for (Reply reply : replies) {
            Object data = reply.data();
            if (data == null) {
                list.add(null);
                continue;
            }
            if (data instanceof byte[]) {
                list.add((byte[])data);
                continue;
            }
            throw new IllegalArgumentException("array contains more then just nulls and bytes -> " + data);
        }
        return list;
    }

    static List<String> asStatusList(Reply[] replies) {
        ArrayList<String> statuses = new ArrayList<String>();
        for (Reply reply : replies) {
            statuses.add(((StatusReply)reply).data());
        }
        return statuses;
    }

    static <T> List<T> toList(T[] byteArrays) {
        return Arrays.asList(byteArrays);
    }

    static Set<byte[]> toSet(Reply[] byteArrays) {
        return new LinkedHashSet<byte[]>(SrpUtils.toBytesList(byteArrays));
    }

    static byte[][] convert(Map<byte[], byte[]> hgetAll) {
        byte[][] result = new byte[hgetAll.size() * 2][];
        int index = 0;
        for (Map.Entry<byte[], byte[]> entry : hgetAll.entrySet()) {
            result[index++] = entry.getKey();
            result[index++] = entry.getValue();
        }
        return result;
    }

    static byte[] asBit(boolean value) {
        return value ? ONE : ZERO;
    }

    static byte[] convertPosition(RedisListCommands.Position where) {
        Assert.notNull((Object)"list positions are mandatory");
        return RedisListCommands.Position.AFTER.equals((Object)where) ? AFTER : BEFORE;
    }

    static Double toDouble(byte[] bytes) {
        return bytes == null || bytes.length == 0 ? null : Double.valueOf(new String(bytes, Charsets.UTF_8));
    }

    static Long toLong(Object[] bytes) {
        return bytes == null || bytes.length == 0 ? null : Long.valueOf(new String((byte[])bytes[0], Charsets.UTF_8));
    }

    static Set<RedisZSetCommands.Tuple> convertTuple(MultiBulkReply zrange) {
        return SrpUtils.convertTuple(zrange.data());
    }

    static Set<RedisZSetCommands.Tuple> convertTuple(Reply[] byteArrays) {
        LinkedHashSet<RedisZSetCommands.Tuple> tuples = new LinkedHashSet<RedisZSetCommands.Tuple>(byteArrays.length / 2 + 1);
        for (int i = 0; i < byteArrays.length; ++i) {
            byte[] value = (byte[])byteArrays[i].data();
            Double score = SrpUtils.toDouble((byte[])byteArrays[++i].data());
            tuples.add(new DefaultTuple(value, score));
        }
        return tuples;
    }

    static Object[] convert(int timeout, byte[] ... keys) {
        int length = keys != null ? keys.length + 1 : 1;
        Object[] args = new Object[length];
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                args[i] = keys[i];
            }
        }
        args[length - 1] = String.valueOf(timeout).getBytes();
        return args;
    }

    static Map<byte[], byte[]> toMap(Reply[] byteArrays) {
        LinkedHashMap<byte[], byte[]> map = new LinkedHashMap<byte[], byte[]>(byteArrays.length / 2);
        for (int i = 0; i < byteArrays.length; ++i) {
            map.put((byte[])byteArrays[i++].data(), (byte[])byteArrays[i].data());
        }
        return map;
    }

    static Boolean asBoolean(IntegerReply reply) {
        if (reply == null) {
            return null;
        }
        return Long.valueOf(1L).equals(reply.data());
    }

    static byte[] limit(long offset, long count) {
        return ("LIMIT " + offset + " " + count).getBytes(Charsets.UTF_8);
    }

    static Object[] limitParams(long offset, long count) {
        return new Object[]{"LIMIT".getBytes(Charsets.UTF_8), String.valueOf(offset).getBytes(Charsets.UTF_8), String.valueOf(count).getBytes(Charsets.UTF_8)};
    }

    static byte[] sort(SortParameters params) {
        return SrpUtils.sort(params, null);
    }

    /*
     * WARNING - void declaration
     */
    static byte[] sort(SortParameters params, byte[] sortKey) {
        void var6_9;
        Object[] sortParams;
        ArrayList<byte[]> arrays = new ArrayList<byte[]>();
        Object[] arr$ = sortParams = SrpUtils.sortParams(params, sortKey);
        int len$ = arr$.length;
        boolean bl = false;
        while (var6_9 < len$) {
            Object param = arr$[var6_9];
            arrays.add((byte[])param);
            arrays.add(SPACE);
            ++var6_9;
        }
        arrays.remove(arrays.size() - 1);
        int size = 0;
        for (Object e : arrays) {
            size += ((byte[])e).length;
        }
        byte[] result = new byte[size];
        boolean bl2 = false;
        for (byte[] bs : arrays) {
            void var6_12;
            System.arraycopy(bs, 0, result, (int)var6_12, bs.length);
            var6_12 += bs.length;
        }
        return result;
    }

    static Object[] sortParams(SortParameters params) {
        return SrpUtils.sortParams(params, null);
    }

    static Object[] sortParams(SortParameters params, byte[] sortKey) {
        ArrayList<byte[]> arrays = new ArrayList<byte[]>();
        if (params != null) {
            Boolean isAlpha;
            if (params.getByPattern() != null) {
                arrays.add(BY);
                arrays.add(params.getByPattern());
            }
            if (params.getLimit() != null) {
                arrays.add(SrpUtils.limit(params.getLimit().getStart(), params.getLimit().getCount()));
            }
            if (params.getGetPattern() != null) {
                byte[][] pattern;
                for (byte[] bs : pattern = params.getGetPattern()) {
                    arrays.add(GET);
                    arrays.add(bs);
                }
            }
            if (params.getOrder() != null) {
                arrays.add(params.getOrder().name().getBytes(Charsets.UTF_8));
            }
            if ((isAlpha = params.isAlphabetic()) != null && isAlpha.booleanValue()) {
                arrays.add(ALPHA);
            }
        }
        if (sortKey != null) {
            arrays.add(STORE);
            arrays.add(sortKey);
        }
        return arrays.toArray();
    }

    static byte[] bitOp(RedisStringCommands.BitOperation op) {
        Assert.notNull((Object)((Object)op), (String)"The bit operation is required");
        return op.name().toUpperCase().getBytes(Charsets.UTF_8);
    }

    static String asShasum(Reply reply) {
        Object data = reply.data();
        return data instanceof String ? (String)data : new String((byte[])data, Charsets.UTF_8);
    }

    static List<Boolean> asBooleanList(Reply reply) {
        if (!(reply instanceof MultiBulkReply)) {
            throw new IllegalArgumentException();
        }
        ArrayList<Boolean> results = new ArrayList<Boolean>();
        for (Reply r : ((MultiBulkReply)reply).data()) {
            results.add(SrpUtils.asBoolean((IntegerReply)r));
        }
        return results;
    }

    static List<Long> asIntegerList(Reply[] replies) {
        ArrayList<Long> results = new ArrayList<Long>();
        for (Reply reply : replies) {
            results.add(((IntegerReply)reply).data());
        }
        return results;
    }

    static List<Object> asList(MultiBulkReply genericReply) {
        Reply[] replies = genericReply.data();
        ArrayList<Object> results = new ArrayList<Object>();
        for (Reply reply : replies) {
            results.add(reply.data());
        }
        return results;
    }

    static Object convertScriptReturn(ReturnType returnType, Reply reply) {
        if (reply instanceof MultiBulkReply) {
            return SrpUtils.asList((MultiBulkReply)reply);
        }
        if (returnType == ReturnType.BOOLEAN) {
            if (reply.data() == null) {
                return Boolean.FALSE;
            }
            return (Long)reply.data() == 1L;
        }
        return reply.data();
    }
}

