/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.BoundListOperations;
import org.springframework.data.redis.core.DefaultBoundKeyOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisOperations;

class DefaultBoundListOperations<K, V>
extends DefaultBoundKeyOperations<K>
implements BoundListOperations<K, V> {
    private final ListOperations<K, V> ops;

    public DefaultBoundListOperations(K key, RedisOperations<K, V> operations) {
        super(key, operations);
        this.ops = operations.opsForList();
    }

    @Override
    public RedisOperations<K, V> getOperations() {
        return this.ops.getOperations();
    }

    @Override
    public V index(long index) {
        return this.ops.index(this.getKey(), index);
    }

    @Override
    public V leftPop() {
        return this.ops.leftPop(this.getKey());
    }

    @Override
    public V leftPop(long timeout, TimeUnit unit) {
        return this.ops.leftPop(this.getKey(), timeout, unit);
    }

    @Override
    public Long leftPush(V value) {
        return this.ops.leftPush(this.getKey(), value);
    }

    @Override
    public Long leftPushAll(V ... values) {
        return this.ops.leftPushAll(this.getKey(), values);
    }

    @Override
    public Long leftPushIfPresent(V value) {
        return this.ops.leftPushIfPresent(this.getKey(), value);
    }

    @Override
    public Long leftPush(V pivot, V value) {
        return this.ops.leftPush(this.getKey(), pivot, value);
    }

    @Override
    public Long size() {
        return this.ops.size(this.getKey());
    }

    @Override
    public List<V> range(long start, long end) {
        return this.ops.range(this.getKey(), start, end);
    }

    @Override
    public Long remove(long i, Object value) {
        return this.ops.remove(this.getKey(), i, value);
    }

    @Override
    public V rightPop() {
        return this.ops.rightPop(this.getKey());
    }

    @Override
    public V rightPop(long timeout, TimeUnit unit) {
        return this.ops.rightPop(this.getKey(), timeout, unit);
    }

    @Override
    public Long rightPushIfPresent(V value) {
        return this.ops.rightPushIfPresent(this.getKey(), value);
    }

    @Override
    public Long rightPush(V value) {
        return this.ops.rightPush(this.getKey(), value);
    }

    @Override
    public Long rightPushAll(V ... values) {
        return this.ops.rightPushAll(this.getKey(), values);
    }

    @Override
    public Long rightPush(V pivot, V value) {
        return this.ops.rightPush(this.getKey(), pivot, value);
    }

    @Override
    public void trim(long start, long end) {
        this.ops.trim(this.getKey(), start, end);
    }

    @Override
    public void set(long index, V value) {
        this.ops.set(this.getKey(), index, value);
    }

    @Override
    public DataType getType() {
        return DataType.LIST;
    }
}

