/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.operation;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.swagger.annotations.ApiOperation;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import springfox.documentation.service.Tags;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spring.web.readers.operation.DefaultTagsProvider;
import springfox.documentation.swagger.annotations.Annotations;

@Component
@Order(value=-2147482648)
public class SwaggerOperationTagsReader
implements OperationBuilderPlugin {
    private final DefaultTagsProvider tagsProvider;

    @Autowired
    public SwaggerOperationTagsReader(DefaultTagsProvider tagsProvider) {
        this.tagsProvider = tagsProvider;
    }

    public void apply(OperationContext context) {
        ImmutableSet defaultTags = this.tagsProvider.tags(context);
        HandlerMethod handlerMethod = context.getHandlerMethod();
        Optional<ApiOperation> annotation = Annotations.findApiOperationAnnotation(handlerMethod.getMethod());
        Set tags = (Set)annotation.transform(this.toTags()).or((Object)Sets.newHashSet());
        if (tags.isEmpty()) {
            context.operationBuilder().tags((Set)defaultTags);
        } else {
            context.operationBuilder().tags(tags);
        }
    }

    private Function<ApiOperation, Set<String>> toTags() {
        return new Function<ApiOperation, Set<String>>(){

            public Set<String> apply(ApiOperation input) {
                TreeSet tags = Sets.newTreeSet();
                tags.addAll(FluentIterable.from((Iterable)Lists.newArrayList((Object[])input.tags())).filter(Tags.emptyTags()).toSet());
                return tags;
            }
        };
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }
}

