/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.web;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.swagger.annotations.Api;
import java.util.Set;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import springfox.documentation.service.Tags;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ApiListingBuilderPlugin;
import springfox.documentation.spi.service.contexts.ApiListingContext;
import springfox.documentation.swagger.common.SwaggerPluginSupport;

@Component
public class ApiListingTagReader
implements ApiListingBuilderPlugin {
    public void apply(ApiListingContext apiListingContext) {
        Class controllerClass = apiListingContext.getGroup().getControllerClass();
        Set tagSet = (Set)Optional.fromNullable((Object)AnnotationUtils.findAnnotation((Class)controllerClass, Api.class)).transform(this.tags()).or((Object)Sets.newTreeSet());
        if (tagSet.isEmpty()) {
            tagSet.add(apiListingContext.getGroup().getGroupName());
        }
        apiListingContext.apiListingBuilder().tags(tagSet);
    }

    private Function<Api, Set<String>> tags() {
        return new Function<Api, Set<String>>(){

            public Set<String> apply(Api input) {
                return Sets.newTreeSet((Iterable)FluentIterable.from((Iterable)Lists.newArrayList((Object[])input.tags())).filter(Tags.emptyTags()).toSet());
            }
        };
    }

    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }
}

