/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.logger;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.io.ClassPathResource;

@Configuration
@ConditionalOnClass(value={LoggerContext.class})
@ConditionalOnResource(resources={"/logback/loginsight-logback.xml"})
public class LoggerAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(LoggerAutoConfiguration.class);

    @Bean
    public ApplicationListener loggerConfiguar() {
        return new ApplicationListener<ContextRefreshedEvent>(){
            private boolean flag = true;

            public void onApplicationEvent(ContextRefreshedEvent applicationStartedEvent) {
                if (this.flag) {
                    try {
                        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
                        JoranConfigurator configurator = new JoranConfigurator();
                        configurator.setContext((Context)loggerContext);
                        configurator.doConfigure(new ClassPathResource("/logback/loginsight-logback.xml").getInputStream());
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    this.flag = false;
                }
            }
        };
    }
}

