/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.utils.hibernate;

import com.googlecode.hibernate.memcached.LoggingMemcacheExceptionHandler;
import com.googlecode.hibernate.memcached.Memcache;
import com.googlecode.hibernate.memcached.MemcacheExceptionHandler;
import com.googlecode.hibernate.memcached.utils.StringUtils;
import java.util.Arrays;
import java.util.Map;
import net.rubyeye.xmemcached.MemcachedClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xmemcache
implements Memcache {
    private static final Logger log = LoggerFactory.getLogger(Xmemcache.class);
    private MemcacheExceptionHandler exceptionHandler = new LoggingMemcacheExceptionHandler();
    private final MemcachedClient memcachedClient;

    public Xmemcache(MemcachedClient memcachedClient) {
        this.memcachedClient = memcachedClient;
    }

    public Object get(String key) {
        try {
            log.debug("MemcachedClient.get({})", (Object)key);
            return this.memcachedClient.get(key);
        }
        catch (Exception e) {
            this.exceptionHandler.handleErrorOnGet(key, e);
            return null;
        }
    }

    public Map<String, Object> getMulti(String ... keys) {
        try {
            return this.memcachedClient.get(Arrays.asList(keys));
        }
        catch (Exception e) {
            this.exceptionHandler.handleErrorOnGet(StringUtils.join((Object[])keys, (String)", "), e);
            return null;
        }
    }

    public void set(String key, int cacheTimeSeconds, Object o) {
        log.debug("MemcachedClient.set({})", (Object)key);
        try {
            this.memcachedClient.set(key, cacheTimeSeconds, o);
        }
        catch (Exception e) {
            this.exceptionHandler.handleErrorOnSet(key, cacheTimeSeconds, o, e);
        }
    }

    public void delete(String key) {
        try {
            this.memcachedClient.delete(key);
        }
        catch (Exception e) {
            this.exceptionHandler.handleErrorOnDelete(key, e);
        }
    }

    public void incr(String key, int factor, int startingValue) {
        try {
            this.memcachedClient.incr(key, factor, startingValue);
        }
        catch (Exception e) {
            this.exceptionHandler.handleErrorOnIncr(key, factor, startingValue, e);
        }
    }

    public void shutdown() {
        log.debug("Shutting down XMemcachedClient");
        try {
            this.memcachedClient.shutdown();
        }
        catch (Exception e) {
            log.error("Shut down XMemcachedClient error", (Throwable)e);
        }
    }

    public void setExceptionHandler(MemcacheExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }
}

