/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client.match;

import java.io.IOException;
import java.text.ParseException;
import org.hamcrest.Matcher;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.mock.http.client.MockClientHttpRequest;
import org.springframework.test.util.JsonPathExpectationsHelper;
import org.springframework.test.web.client.RequestMatcher;

public class JsonPathRequestMatchers {
    private JsonPathExpectationsHelper jsonPathHelper;

    protected JsonPathRequestMatchers(String expression, Object ... args) {
        this.jsonPathHelper = new JsonPathExpectationsHelper(expression, args);
    }

    public <T> RequestMatcher value(final Matcher<T> matcher) {
        return new AbstractJsonPathRequestMatcher(){

            @Override
            protected void matchInternal(MockClientHttpRequest request) throws IOException, ParseException {
                JsonPathRequestMatchers.this.jsonPathHelper.assertValue(request.getBodyAsString(), matcher);
            }
        };
    }

    public RequestMatcher value(final Object expectedValue) {
        return new AbstractJsonPathRequestMatcher(){

            @Override
            protected void matchInternal(MockClientHttpRequest request) throws IOException, ParseException {
                JsonPathRequestMatchers.this.jsonPathHelper.assertValue(request.getBodyAsString(), expectedValue);
            }
        };
    }

    public RequestMatcher exists() {
        return new AbstractJsonPathRequestMatcher(){

            @Override
            protected void matchInternal(MockClientHttpRequest request) throws IOException, ParseException {
                JsonPathRequestMatchers.this.jsonPathHelper.exists(request.getBodyAsString());
            }
        };
    }

    public RequestMatcher doesNotExist() {
        return new AbstractJsonPathRequestMatcher(){

            @Override
            protected void matchInternal(MockClientHttpRequest request) throws IOException, ParseException {
                JsonPathRequestMatchers.this.jsonPathHelper.doesNotExist(request.getBodyAsString());
            }
        };
    }

    public RequestMatcher isArray() {
        return new AbstractJsonPathRequestMatcher(){

            @Override
            protected void matchInternal(MockClientHttpRequest request) throws IOException, ParseException {
                JsonPathRequestMatchers.this.jsonPathHelper.assertValueIsArray(request.getBodyAsString());
            }
        };
    }

    private static abstract class AbstractJsonPathRequestMatcher
    implements RequestMatcher {
        private AbstractJsonPathRequestMatcher() {
        }

        @Override
        public final void match(ClientHttpRequest request) throws IOException, AssertionError {
            try {
                MockClientHttpRequest mockRequest = (MockClientHttpRequest)request;
                this.matchInternal(mockRequest);
            }
            catch (ParseException e) {
                throw new AssertionError((Object)("Failed to parse JSON request content: " + e.getMessage()));
            }
        }

        protected abstract void matchInternal(MockClientHttpRequest var1) throws IOException, ParseException;
    }
}

