/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.tuia.media.api.dto.req.ReqActivityDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqIdAndType;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspMaterialSpecificationItemContentDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivityDAO;
import cn.com.duiba.tuia.media.dao.MaterialSpecificationItemContentDAO;
import cn.com.duiba.tuia.media.dataobject.MaterialSpecificationItemContentDO;
import cn.com.duiba.tuia.media.domain.ActivityDto;
import cn.com.duiba.tuia.media.parser.ActivityDtoParser;
import cn.com.duiba.tuia.media.service.ActivityService;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="activityNewService")
public class ActivityServiceImpl
implements ActivityService {
    @Autowired
    private ActivityDAO activityDAO;
    @Autowired
    private MaterialSpecificationItemContentDAO materialSpecificationItemContentDAO;

    @Override
    public List<RspActivityDto> getPlanList(ReqActivityDto req) throws TuiaMediaException {
        List<ActivityDto> result = this.activityDAO.getList(req);
        ArrayList<RspActivityDto> list = new ArrayList<RspActivityDto>();
        for (ActivityDto activityDto : result) {
            list.add(ActivityDtoParser.parseToRspActivityDto(activityDto));
        }
        return list;
    }

    @Override
    @Transactional
    public Boolean addActivityPlan(List<ReqIdAndType> activities) throws TuiaMediaException {
        if (!CollectionUtils.isEmpty(activities)) {
            for (ReqIdAndType idAndType : activities) {
                ActivityDto activityDto = new ActivityDto();
                activityDto.setActivityId(idAndType.getId());
                activityDto.setActivityType(idAndType.getType());
                activityDto.setIsPublish(1);
                this.activityDAO.update(activityDto);
            }
        }
        return true;
    }

    @Override
    @Transactional
    public Boolean updateActivityPlan(ReqActivityDto reqActivityDto) throws TuiaMediaException {
        List activityMsIdList = reqActivityDto.getActivityMsIdList();
        ActivityDto activityDto = new ActivityDto();
        activityDto.setActivityId(reqActivityDto.getId());
        activityDto.setActivityType(reqActivityDto.getType());
        activityDto.setActivityMsList(Joiner.on((String)",").appendTo(new StringBuilder(), (Iterable)activityMsIdList).toString());
        this.activityDAO.update(activityDto);
        List itemContentDtoList = reqActivityDto.getItemContentList();
        this.materialSpecificationItemContentDAO.delete(reqActivityDto.getId(), reqActivityDto.getType());
        if (!CollectionUtils.isEmpty((Collection)itemContentDtoList)) {
            ArrayList<MaterialSpecificationItemContentDO> msItemContentList = new ArrayList<MaterialSpecificationItemContentDO>();
            for (RspMaterialSpecificationItemContentDto msItemContent : itemContentDtoList) {
                MaterialSpecificationItemContentDO itemContentDO = new MaterialSpecificationItemContentDO();
                BeanUtils.copyProperties((Object)msItemContent, (Object)itemContentDO);
                msItemContentList.add(itemContentDO);
            }
            this.materialSpecificationItemContentDAO.insertBatch(msItemContentList);
        }
        return true;
    }

    @Override
    public RspActivityDto getActivityPlanDetail(Long activityId, Integer activityType) throws TuiaMediaException {
        ActivityDto activityDto = this.activityDAO.getDetail(activityId, activityType);
        if (activityDto == null) {
            throw new TuiaMediaException(ErrorCode.E0501004);
        }
        RspActivityDto rspActivityDto = ActivityDtoParser.parseToRspActivityDto(activityDto);
        List<MaterialSpecificationItemContentDO> msItemContentList = this.materialSpecificationItemContentDAO.getByActivity(activityId, activityType);
        if (!CollectionUtils.isEmpty(msItemContentList)) {
            ArrayList<RspMaterialSpecificationItemContentDto> rspMsItemContentList = new ArrayList<RspMaterialSpecificationItemContentDto>(msItemContentList.size());
            for (MaterialSpecificationItemContentDO itemContentDO : msItemContentList) {
                RspMaterialSpecificationItemContentDto msItem = new RspMaterialSpecificationItemContentDto();
                BeanUtils.copyProperties((Object)itemContentDO, (Object)msItem);
                rspMsItemContentList.add(msItem);
            }
            rspActivityDto.setItemContentList(rspMsItemContentList);
        }
        return rspActivityDto;
    }

    @Override
    public Boolean changeActivityPlanEnable(Long activityId, Integer activityType, Integer enableStatus) throws TuiaMediaException {
        if (0 != enableStatus && 1 != enableStatus) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        ActivityDto activityDto = new ActivityDto();
        activityDto.setActivityId(activityId);
        activityDto.setActivityType(activityType);
        activityDto.setIsEnable(enableStatus);
        return this.activityDAO.update(activityDto) == 1;
    }

    @Override
    public Boolean deleteActivityPlan(Long activityId, Integer activityType) throws TuiaMediaException {
        ActivityDto activityDto = new ActivityDto();
        activityDto.setActivityId(activityId);
        activityDto.setActivityType(activityType);
        activityDto.setIsPublish(0);
        return this.activityDAO.update(activityDto) == 1;
    }

    @Override
    public List<RspActivityDto> getActivityByIds(List<Long> ids) throws TuiaMediaException {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        List<ActivityDto> result = this.activityDAO.getByIds(ids);
        ArrayList<RspActivityDto> list = new ArrayList<RspActivityDto>();
        for (ActivityDto activityDto : result) {
            list.add(ActivityDtoParser.parseToRspActivityDto(activityDto));
        }
        return list;
    }

    @Override
    public Boolean insertActivity(ActivityDto activityDto) throws TuiaMediaException {
        return this.activityDAO.insert(activityDto) == 1;
    }

    @Override
    public Boolean updateActivity(ActivityDto activityDto) throws TuiaMediaException {
        return this.activityDAO.update(activityDto) == 1;
    }

    @Override
    public Boolean deleteActivity(Long activityId, Integer activityType) throws TuiaMediaException {
        ActivityDto activityDto = new ActivityDto();
        activityDto.setActivityId(activityId);
        activityDto.setActivityType(activityType);
        activityDto.setIsDelete(1);
        return this.activityDAO.update(activityDto) == 1;
    }

    @Override
    public String getActivityName(Long activityId, Integer activityType) throws TuiaMediaException {
        ActivityDto activityDto = this.activityDAO.getDetail(activityId, activityType);
        if (activityDto != null) {
            return activityDto.getActivityName();
        }
        return null;
    }
}

