/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.tuia.media.api.dto.req.ReqActivitySlotDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivitySlotDto;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivitySlotDAO;
import cn.com.duiba.tuia.media.dao.SlotDAO;
import cn.com.duiba.tuia.media.dataobject.ActivitySlotDO;
import cn.com.duiba.tuia.media.service.ActivitySlotService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="activitySlotService")
public class ActivitySlotServiceImpl
implements ActivitySlotService {
    @Autowired
    private ActivitySlotDAO activitySlotDAO;
    @Autowired
    private SlotDAO slotDAO;

    @Override
    public Boolean addSlots(List<Long> slotIds) throws TuiaMediaException {
        if (CollectionUtils.isEmpty(slotIds)) {
            return true;
        }
        ArrayList<ActivitySlotDO> list = new ArrayList<ActivitySlotDO>(slotIds.size());
        for (Long slotId : slotIds) {
            ActivitySlotDO activitySlotDO = new ActivitySlotDO();
            activitySlotDO.setSlotId(slotId);
            list.add(activitySlotDO);
        }
        this.activitySlotDAO.insertBatch(list);
        return null;
    }

    @Override
    public Boolean deleteSlot(Long slotId) throws TuiaMediaException {
        return this.activitySlotDAO.delete(slotId) == 1;
    }

    @Override
    public List<RspActivitySlotDto> getList(ReqActivitySlotDto req) throws TuiaMediaException {
        ArrayList<Long> slotIds = new ArrayList<Long>();
        if (StringUtils.isNotEmpty((String)req.getName())) {
            List<Long> ids = this.slotDAO.selectIdsByName(req.getName());
            if (CollectionUtils.isEmpty(ids)) {
                return Lists.newArrayList();
            }
            slotIds.addAll(ids);
        }
        if (req.getId() != null) {
            slotIds.add(req.getId());
        }
        req.setIdList(slotIds);
        return this.activitySlotDAO.getList(req);
    }
}

