/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.tuia.media.api.dto.SlotDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqActivitySort;
import cn.com.duiba.tuia.media.api.dto.req.ReqIdAndType;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.common.utils.CollectionUtil;
import cn.com.duiba.tuia.media.dao.ActivityDAO;
import cn.com.duiba.tuia.media.dao.ActivitySortDAO;
import cn.com.duiba.tuia.media.domain.ActivitySortDto;
import cn.com.duiba.tuia.media.service.ActivityService;
import cn.com.duiba.tuia.media.service.ActivitySortService;
import cn.com.duiba.tuia.media.service.SlotService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class ActivitySortServiceImpl
implements ActivitySortService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long SORT_STEP = 1000000L;
    @Autowired
    private ActivityDAO activityDAO;
    @Autowired
    private ActivitySortDAO activitySortDAO;
    @Autowired
    private SlotService slotService;
    @Autowired
    private ActivityService activityService;

    @Override
    public boolean insertBatchActivitySort(List<ActivitySortDto> activitySortDtoList) throws TuiaMediaException {
        return this.activitySortDAO.insertBatch(activitySortDtoList) > 0;
    }

    @Override
    public List<ActivitySortDto> selectByCondition(ReqActivitySort reqActivitySort) throws TuiaMediaException {
        if (!StringUtils.isEmpty((Object)reqActivitySort.getName()) || reqActivitySort.getType() != null) {
            // empty if block
        }
        return this.activitySortDAO.selectByCondition(reqActivitySort);
    }

    @Override
    public int selectByConditionAmount(ReqActivitySort reqActivitySort) throws TuiaMediaException {
        return this.activitySortDAO.selectByConditionAmount(reqActivitySort);
    }

    @Override
    @Transactional
    public boolean deleteActivity(Long activityAppId, Long activityId, Integer activityType) throws TuiaMediaException {
        Long actAppId = activityAppId;
        if (actAppId == null || activityId == null || activityType == null) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        if (actAppId.equals(0L)) {
            actAppId = null;
        }
        return this.activitySortDAO.deleteActivity(actAppId, activityId, activityType) > 0;
    }

    @Override
    public ActivitySortDto getMaxSortValueActivitySortDto(Long activityAppId) throws TuiaMediaException {
        if (activityAppId == null) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        ReqActivitySort reqActivitySort = new ReqActivitySort();
        reqActivitySort.setAppId(activityAppId);
        reqActivitySort.setSort("activity_sort desc,gmt_modified asc");
        reqActivitySort.setRowStart(0);
        reqActivitySort.setPageSize(Integer.valueOf(1));
        List<ActivitySortDto> result = this.activitySortDAO.selectByCondition(reqActivitySort);
        if (result.isEmpty()) {
            return null;
        }
        return result.get(0);
    }

    @Override
    public boolean sort(Long activityAppId, Long activityId, Integer activityType, int location) throws TuiaMediaException {
        if (activityAppId == null || activityId == null || location <= 0) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        if (location == 1) {
            ActivitySortDto firstSortActivity = this.getFirstSortActivity(activityAppId);
            if (firstSortActivity.getActivityId() == activityId) {
                return true;
            }
            ReqActivitySort reqActivitySort = new ReqActivitySort();
            reqActivitySort.setAppId(activityAppId);
            reqActivitySort.setId(activityId);
            List<ActivitySortDto> result = this.activitySortDAO.selectByCondition(reqActivitySort);
            if (result.isEmpty()) {
                throw new TuiaMediaException(ErrorCode.E0501001);
            }
            ActivitySortDto activitySortDto = result.get(0);
            activitySortDto.setActivitySort(firstSortActivity.getActivitySort() - 1000000L);
            this.activitySortDAO.update(activitySortDto);
            return true;
        }
        List<ActivitySortDto> result = this.getLocationSortActivity(activityAppId, location);
        if (result.size() < 2) {
            throw new TuiaMediaException(ErrorCode.E0501002);
        }
        ReqActivitySort reqActivitySort = new ReqActivitySort();
        reqActivitySort.setAppId(activityAppId);
        reqActivitySort.setId(activityId);
        reqActivitySort.setType(activityType);
        List<ActivitySortDto> rst = this.activitySortDAO.selectByCondition(reqActivitySort);
        if (rst.isEmpty()) {
            throw new TuiaMediaException(ErrorCode.E0501001);
        }
        ActivitySortDto activitySortDto = rst.get(0);
        if (result.get(1).getActivitySort().equals(activitySortDto.getActivitySort()) && result.get(1).getActivityType().equals(activitySortDto.getActivityType())) {
            return true;
        }
        if (result.get(0).getActivitySort().equals(activitySortDto.getActivitySort()) && result.get(0).getActivityType().equals(activitySortDto.getActivityType())) {
            if (result.size() == 2) {
                activitySortDto.setActivitySort(result.get(1).getActivitySort() + 1000000L);
            } else {
                activitySortDto.setActivitySort((result.get(1).getActivitySort() + result.get(2).getActivitySort()) / 2L);
            }
        } else if (result.size() == 2) {
            if (activitySortDto.getActivitySort() < result.get(1).getActivitySort()) {
                activitySortDto.setActivitySort(result.get(1).getActivitySort() + 1000000L);
            } else {
                activitySortDto.setActivitySort(result.get(1).getActivitySort() - 1000000L);
            }
        } else if (activitySortDto.getActivitySort() < result.get(2).getActivitySort()) {
            activitySortDto.setActivitySort((result.get(1).getActivitySort() + result.get(2).getActivitySort()) / 2L);
        } else {
            activitySortDto.setActivitySort((result.get(0).getActivitySort() + result.get(1).getActivitySort()) / 2L);
        }
        this.activitySortDAO.update(activitySortDto);
        return true;
    }

    @Override
    public List<ActivitySortDto> getActivityForRecommendByApp(Long appId) throws TuiaMediaException {
        if (appId == null) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        return this.activitySortDAO.getActivityForRecommend(appId);
    }

    @Override
    public List<RspActivityDto> getActivityForRecommendBySlot(Long slotId) throws TuiaMediaException {
        if (slotId == null) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        try {
            SlotDto slot = this.slotService.selectById(slotId);
            if (slot == null) {
                this.logger.error("Not found slot, slotId=" + slotId);
                throw new TuiaMediaException(ErrorCode.E0001005);
            }
            List<ActivitySortDto> sortList = this.activitySortDAO.getActivityForRecommendBySlot(slotId);
            ArrayList<RspActivityDto> result = new ArrayList<RspActivityDto>();
            for (ActivitySortDto activitySortDto : sortList) {
                RspActivityDto rspActivityDto = this.activityService.getActivityPlanDetail(activitySortDto.getActivityId(), activitySortDto.getActivityType());
                result.add(rspActivityDto);
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendServiceImpl.getActivityMapByApp is error");
            throw new TuiaMediaException(ErrorCode.E9999999, (Throwable)e);
        }
    }

    @Override
    public boolean addActivitySort(Long activityAppId, List<ReqIdAndType> idAndTypes) {
        try {
            Long sort = new Date().getTime();
            ActivitySortDto result = this.getMaxSortValueActivitySortDto(activityAppId);
            if (result != null && result.getActivitySort() >= sort) {
                sort = result.getActivitySort() + 1000000L;
            }
            ReqActivitySort reqActivitySort = new ReqActivitySort();
            reqActivitySort.setAppId(activityAppId);
            List<ActivitySortDto> existList = this.selectByCondition(reqActivitySort);
            HashSet<String> existActivity = new HashSet<String>(existList.size());
            for (ActivitySortDto activitySortDto : existList) {
                existActivity.add(activitySortDto.getActivityId() + "-" + activitySortDto.getActivityType());
            }
            List<RspActivityDto> activityDtoList = this.activityService.getActivityByIds(CollectionUtil.getFieldList(idAndTypes, (String)"id"));
            ArrayList<ActivitySortDto> activitySortDtoList = new ArrayList<ActivitySortDto>();
            for (RspActivityDto activityDto : activityDtoList) {
                ReqIdAndType reqIdAndType = new ReqIdAndType();
                reqIdAndType.setId(activityDto.getId());
                reqIdAndType.setType(activityDto.getType());
                if (existActivity.contains(activityDto.getId() + "-" + activityDto.getType())) continue;
                ActivitySortDto activitySortDto = new ActivitySortDto();
                activitySortDto.setActivityAppId(activityAppId);
                activitySortDto.setActivityId(activityDto.getId());
                activitySortDto.setActivityType(activityDto.getType());
                activitySortDto.setActivitySort(sort);
                sort = sort + 1000000L;
                activitySortDtoList.add(activitySortDto);
            }
            if (!activitySortDtoList.isEmpty()) {
                this.insertBatchActivitySort(activitySortDtoList);
            }
            return true;
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendServiceImpl.addActivitySort is error", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean addDefaultActivitySort(Long activityAppId) {
        try {
            ArrayList<ReqIdAndType> idAndTypes = new ArrayList<ReqIdAndType>();
            ReqActivitySort condition = new ReqActivitySort();
            condition.setAppId(Long.valueOf(0L));
            condition.setSort("activity_sort asc,gmt_modified desc");
            List<ActivitySortDto> needList = this.selectByCondition(condition);
            for (ActivitySortDto activitySortDto : needList) {
                ReqIdAndType idAndType = new ReqIdAndType();
                idAndType.setId(activitySortDto.getActivityId());
                idAndType.setType(activitySortDto.getActivityType());
                idAndTypes.add(idAndType);
            }
            return this.addActivitySort(activityAppId, idAndTypes);
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendServiceImpl.addDefaultActivitySort is error", (Throwable)e);
            return false;
        }
    }

    private ActivitySortDto getFirstSortActivity(Long activityAppId) throws TuiaMediaException {
        ReqActivitySort reqActivitySort = new ReqActivitySort();
        reqActivitySort.setAppId(activityAppId);
        reqActivitySort.setRowStart(0);
        reqActivitySort.setPageSize(Integer.valueOf(1));
        reqActivitySort.setSort("activity_sort asc,gmt_modified desc");
        List<ActivitySortDto> result = this.activitySortDAO.selectByCondition(reqActivitySort);
        if (!result.isEmpty()) {
            return result.get(0);
        }
        return null;
    }

    private List<ActivitySortDto> getLocationSortActivity(Long activityAppId, int location) throws TuiaMediaException {
        ReqActivitySort reqActivitySort = new ReqActivitySort();
        reqActivitySort.setAppId(activityAppId);
        reqActivitySort.setRowStart(location - 2);
        reqActivitySort.setPageSize(Integer.valueOf(3));
        reqActivitySort.setSort("activity_sort asc,gmt_modified desc");
        return this.activitySortDAO.selectByCondition(reqActivitySort);
    }

    private ActivitySortDto resetActivitySort(Long slotId, ActivitySortDto startSort) throws TuiaMediaException {
        this.activitySortDAO.updateSortBatch(slotId, startSort.getActivitySort(), 1000000L);
        return this.activitySortDAO.select(slotId, startSort.getActivityId(), startSort.getActivityType());
    }

    private List<ActivitySortDto> getActivitySortAround(Long slotId, int location) throws TuiaMediaException {
        ReqActivitySort reqActivitySort = new ReqActivitySort();
        reqActivitySort.setSlotId(slotId);
        reqActivitySort.setPageSize(Integer.valueOf(2));
        reqActivitySort.setRowStart(location);
        reqActivitySort.setSort("activity_sort asc,gmt_modified desc");
        return this.activitySortDAO.selectByCondition(reqActivitySort);
    }

    private int getActivitySortLocation(Long slotId, Long activityId, Integer activityType) throws TuiaMediaException {
        ActivitySortDto activitySort = this.activitySortDAO.select(slotId, activityId, activityType);
        return this.activitySortDAO.selectSortLocation(slotId, activitySort.getActivitySort());
    }

    private long getActivitySortValue(Long slotId, List<ActivitySortDto> aroundSortList) throws TuiaMediaException {
        if (aroundSortList.size() == 1) {
            ActivitySortDto aroundSortMin = aroundSortList.get(0);
            return aroundSortMin.getActivitySort() + 1000000L;
        }
        ActivitySortDto aroundSortMin = aroundSortList.get(0);
        ActivitySortDto aroundSortMax = aroundSortList.get(1);
        if (aroundSortMax.getActivitySort() - aroundSortMin.getActivitySort() < 2L) {
            aroundSortMax = this.resetActivitySort(slotId, aroundSortMax);
        }
        return (aroundSortMax.getActivitySort() + aroundSortMin.getActivitySort()) / 2L;
    }

    @Override
    public boolean sortActivity(Long slotId, Long activityId, Integer activityType, int destLocation) throws TuiaMediaException {
        if (slotId == null || activityId == null || activityType == null || destLocation <= 0) {
            return false;
        }
        int origLocation = this.getActivitySortLocation(slotId, activityId, activityType);
        if (origLocation <= 0 || destLocation == origLocation) {
            return false;
        }
        int offset = destLocation < origLocation ? -1 : 0;
        List<ActivitySortDto> aroundSortList = this.getActivitySortAround(slotId, destLocation + offset);
        if (aroundSortList.isEmpty()) {
            return false;
        }
        long sort = this.getActivitySortValue(slotId, aroundSortList);
        return this.activitySortDAO.updateSort(slotId, activityId, activityType, sort) > 0;
    }
}

