/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ShieldStrategyDAO;
import cn.com.duiba.tuia.media.domain.ShieldStrategyDto;
import cn.com.duiba.tuia.media.model.req.ReqShieldListStrategy;
import cn.com.duiba.tuia.media.model.req.ReqStrategyPageQuery;
import cn.com.duiba.tuia.media.model.rsp.RspIdAndValue;
import cn.com.duiba.tuia.media.model.rsp.RspPageResult;
import cn.com.duiba.tuia.media.model.rsp.RspShieldStrategy;
import cn.com.duiba.tuia.media.model.rsp.RspStrategyList;
import cn.com.duiba.tuia.media.service.StrategyService;
import cn.com.duiba.tuia.media.service.impl.SlotCacheService;
import cn.com.duiba.tuia.media.utils.RemoveDuplicateTool;
import cn.com.duiba.tuia.media.utils.StringTool;
import cn.com.duiba.wolf.redis.RedisClient;
import com.alibaba.dubbo.common.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StrategyServiceImpl
implements StrategyService {
    @Autowired
    private ShieldStrategyDAO shieldStrategyDAO;
    @Autowired
    private RedisClient redisClient;
    @Autowired
    private SlotCacheService slotCacheService;

    @Override
    public RspPageResult<RspStrategyList> getPageList(ReqStrategyPageQuery req) throws TuiaMediaException {
        int amount = this.shieldStrategyDAO.selectAmountByPage(req);
        ArrayList<RspStrategyList> strategies = null;
        if (amount > 0 && amount >= req.getRowStart()) {
            List<ShieldStrategyDto> strategyDtos = this.shieldStrategyDAO.selectListByPage(req);
            strategies = new ArrayList<RspStrategyList>(strategyDtos.size());
            for (ShieldStrategyDto strategyDto : strategyDtos) {
                RspStrategyList rspStrategy = new RspStrategyList();
                rspStrategy.setId(strategyDto.getId());
                rspStrategy.setStrategyName(strategyDto.getStrategyName());
                rspStrategy.setCreateDate(new DateTime((Object)strategyDto.getGmtCreate()).toString("yyyy-MM-dd"));
                rspStrategy.setIndustryFlag(StringUtils.isNotBlank((CharSequence)strategyDto.getShieldIndustries()));
                rspStrategy.setAdvertTagNums(StringUtils.isNotBlank((CharSequence)strategyDto.getAdvertTagNums()));
                rspStrategy.setAdvertiserFlag(StringUtils.isNotBlank((CharSequence)strategyDto.getShieldUrls()));
                strategies.add(rspStrategy);
            }
        }
        return new RspPageResult<RspStrategyList>(amount, strategies, req.getPageSize());
    }

    @Override
    public Boolean delete(Long mediaId, Long strategyId) throws TuiaMediaException {
        if (this.isBelongMedia(strategyId, mediaId)) {
            this.shieldStrategyDAO.delete(strategyId);
        }
        this.slotCacheService.deleteStrategyCache(strategyId);
        return true;
    }

    private boolean isBelongMedia(Long strategyId, Long mediaId) throws TuiaMediaException {
        ShieldStrategyDto shieldStrategy = this.shieldStrategyDAO.selectById(strategyId);
        if (shieldStrategy == null) {
            throw new TuiaMediaException(ErrorCode.E0304002);
        }
        if (shieldStrategy.getMediaId() == null || mediaId.longValue() != shieldStrategy.getMediaId().longValue()) {
            throw new TuiaMediaException(ErrorCode.E0304001);
        }
        return true;
    }

    @Override
    public Boolean create(ReqShieldListStrategy param, Long mediaId) throws TuiaMediaException {
        ShieldStrategyDto req = new ShieldStrategyDto();
        req.setStrategyName(param.getStrategyName());
        req.setShieldIndustries(StringTool.getStringByList(param.getShieldIndustries()));
        req.setShieldUrls(this.getShieldUrls(param.getShieldAdvertisers()));
        req.setMediaId(mediaId);
        if (this.shieldStrategyDAO.isNotExist(null, mediaId, req.getStrategyName())) {
            this.shieldStrategyDAO.insert(req);
            this.slotCacheService.updateStrategyById(req.getId());
        }
        return true;
    }

    @Override
    public Boolean update(ReqShieldListStrategy param, Long mediaId) throws TuiaMediaException {
        ShieldStrategyDto req = new ShieldStrategyDto();
        Long id = param.getId();
        req.setId(id);
        req.setStrategyName(param.getStrategyName());
        req.setShieldIndustries(StringTool.getStringByList(param.getShieldIndustries()));
        req.setShieldUrls(this.getShieldUrls(param.getShieldAdvertisers()));
        if (this.isBelongMedia(id, mediaId) && this.shieldStrategyDAO.isNotExist(id, mediaId, req.getStrategyName())) {
            this.shieldStrategyDAO.update(req);
            this.slotCacheService.updateStrategyById(id);
        }
        return true;
    }

    private String getShieldUrls(List<String> shieldAdvertisers) {
        ArrayList<String> shieldUrls = null;
        if (CollectionUtils.isNotEmpty(shieldAdvertisers)) {
            shieldUrls = new ArrayList<String>(shieldAdvertisers.size());
            for (String shieldAdvertiser : shieldAdvertisers) {
                if (!StringUtils.isNotBlank((CharSequence)shieldAdvertiser)) continue;
                shieldUrls.add(shieldAdvertiser.trim());
            }
        }
        return StringTool.getStringByList(RemoveDuplicateTool.doRemoveDuplicateUrl(shieldUrls));
    }

    @Override
    public Boolean updateByManager(ShieldStrategyDto strategyDto) throws TuiaMediaException {
        this.shieldStrategyDAO.updateByManager(strategyDto);
        this.slotCacheService.updateStrategyById(strategyDto.getId());
        return true;
    }

    @Override
    public List<RspIdAndValue> getListByMediaId(Long mediaId) throws TuiaMediaException {
        List<ShieldStrategyDto> strategyDtos = this.shieldStrategyDAO.selectListByMediaId(mediaId);
        ArrayList<RspIdAndValue> rspIdAndValue = new ArrayList<RspIdAndValue>(strategyDtos.size());
        for (ShieldStrategyDto strategyDto : strategyDtos) {
            RspIdAndValue dto = new RspIdAndValue();
            dto.setId(Long.toString(strategyDto.getId()));
            dto.setValue(strategyDto.getStrategyName());
            rspIdAndValue.add(dto);
        }
        return rspIdAndValue;
    }

    @Override
    public RspShieldStrategy getDetail(Long strategyId) throws TuiaMediaException {
        ShieldStrategyDto shield = this.shieldStrategyDAO.selectById(strategyId);
        RspShieldStrategy shieldStrategy = null;
        if (shield != null) {
            shieldStrategy = new RspShieldStrategy();
            shieldStrategy.setId(strategyId);
            shieldStrategy.setIndustryFlag(StringUtils.isNotBlank((CharSequence)shield.getShieldIndustries()));
            shieldStrategy.setAdvertiserFlag(StringUtils.isNotBlank((CharSequence)shield.getShieldUrls()));
            shieldStrategy.setAdvertTagNumsFlag(StringUtils.isNotBlank((CharSequence)shield.getAdvertTagNums()));
            shieldStrategy.setShieldIndustries(StringTool.getStringListByStr(shield.getShieldIndustries()));
            shieldStrategy.setAdvertTagNums(StringTool.getStringListByStr(shield.getAdvertTagNums()));
            shieldStrategy.setShieldAdvertisers(StringTool.getStringListByStr(shield.getShieldUrls()));
            shieldStrategy.setStrategyName(shield.getStrategyName());
        }
        return shieldStrategy;
    }
}

