/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.utils;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.model.Result;
import cn.com.duiba.tuia.media.model.ResultPage;
import java.util.List;

public class ResultUtil {
    public static <T> Result<T> fail(String errorCode, String desc) {
        Result result = new Result();
        result.setCode(errorCode);
        result.setDesc(desc);
        return result;
    }

    public static <T> Result<T> fail(ErrorCode code) {
        Result result = new Result();
        result.setCode(code.getErrorCode());
        result.setDesc(code.getDesc());
        return result;
    }

    public static <T> Result<T> success(T t) {
        Result<T> result = new Result<T>();
        result.setCode(ErrorCode.E0000000.getErrorCode());
        result.setData(t);
        result.setDesc(ErrorCode.E0000000.getDesc());
        return result;
    }

    public static <T> Result<T> success() {
        Result result = new Result();
        result.setCode(ErrorCode.E0000000.getErrorCode());
        result.setDesc(ErrorCode.E0000000.getDesc());
        return result;
    }

    public static <T> ResultPage<T> success(long count, List<T> list) {
        ResultPage<T> result = new ResultPage<T>();
        result.setCode(ErrorCode.E0000000.getErrorCode());
        result.setData(list);
        result.setCount(count);
        return result;
    }
}

