/**
 * Project Name:media-deploy<br>
 * File Name:TagController.java<br>
 * Package Name:cn.com.duiba.tuia.media.web.controller<br>
 * Date:2016年9月27日下午7:06:06<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import com.alibaba.fastjson.JSONObject;
import cn.com.duiba.tuia.core.api.dto.TagLevel;
import cn.com.duiba.tuia.core.api.remoteservice.RemoteTagBackendService;
import cn.com.duiba.tuia.media.model.Result;

/**
 * ClassName: TagController <br/>
 * Function: 标签. <br/>
 * date: 2016年9月27日 下午7:06:06 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
@Controller
@RequestMapping("/tag")
@Api("标签相关api")
public class TagController extends BaseController {

    /** 活动标签库来源. */
    // private static final int ACTIVITY_TAG_LIBRARY = 1;

    /** 广告标签库来源. */
    // private static final int ADVERT_TAG_LIBRARY = 2;

    /** 屏蔽标签库来源. */
    // private static final int BANNED_TAG_LIBRARY = 3;

    /** The remote tag backend service. */
    @Autowired
    private RemoteTagBackendService remoteTagBackendService;

    @Value("${media.tag.msg}")
    private String                  targetTags;

    /**
     * getTagLibrary:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param type the type
     * @return the tag library
     * @author ZFZ
     * @since JDK 1.6
     */
    @ResponseBody
    @ApiOperation(value = "查询标签库", httpMethod = "GET", notes = "查询标签库接口")
    @RequestMapping(value = "getTagLibrary", method = RequestMethod.GET)
    public Result<List<TagLevel>> getTagLibrary(@RequestParam Integer type) {
        try {
            // 之前：屏蔽策略中，屏蔽行业是广告标签库中的所有行业标签。
            /*
             * if (type == null) { throw new TuiaMediaException(ErrorCode.E0001005); } DubboResult<List<TagLevel>>
             * dubboResult; if (ADVERT_TAG_LIBRARY == type) { dubboResult =
             * remoteTagBackendService.getAdvertTagLibrary(); } else if (ACTIVITY_TAG_LIBRARY == type) { dubboResult =
             * remoteTagBackendService.getActivityTagLibrary(); } else if (BANNED_TAG_LIBRARY == type) { dubboResult =
             * remoteTagBackendService.getBannedTagLibrary(); } else { throw new TuiaMediaException(ErrorCode.E0001005);
             * } doTuiaCoreException(dubboResult, "remoteTagBackendService.getAdvertTagLibrary"); return
             * successResult(dubboResult.getResult());
             */
            // 期望：选择行业屏蔽中的一些敏感行业分类。
            List<TagLevel> tags = JSONObject.parseArray(targetTags, TagLevel.class);
            return successResult(tags);
        } catch (Exception e) {
            logger.error("BaseController.getTagLibrary error!");
            return failResult(e);
        }
    }

}
