/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl;

import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public final class TtlRunnable
implements Runnable {
    private final AtomicReference<Map<TransmittableThreadLocal<?>, Object>> copiedRef = new AtomicReference(TransmittableThreadLocal.copy());
    private final Runnable runnable;
    private final boolean releaseTtlValueReferenceAfterRun;

    private TtlRunnable(Runnable runnable, boolean releaseTtlValueReferenceAfterRun) {
        this.runnable = runnable;
        this.releaseTtlValueReferenceAfterRun = releaseTtlValueReferenceAfterRun;
    }

    @Override
    public void run() {
        Map<TransmittableThreadLocal<?>, Object> copied = this.copiedRef.get();
        if (copied == null || this.releaseTtlValueReferenceAfterRun && !this.copiedRef.compareAndSet(copied, null)) {
            throw new IllegalStateException("TTL value reference is released after run!");
        }
        Map<TransmittableThreadLocal<?>, Object> backup = TransmittableThreadLocal.backupAndSetToCopied(copied);
        try {
            this.runnable.run();
        }
        finally {
            TransmittableThreadLocal.restoreBackup(backup);
        }
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    public static TtlRunnable get(Runnable runnable) {
        return TtlRunnable.get(runnable, false, false);
    }

    public static TtlRunnable get(Runnable runnable, boolean releaseTtlValueReferenceAfterRun) {
        return TtlRunnable.get(runnable, releaseTtlValueReferenceAfterRun, false);
    }

    public static TtlRunnable get(Runnable runnable, boolean releaseTtlValueReferenceAfterRun, boolean idempotent) {
        if (null == runnable) {
            return null;
        }
        if (runnable instanceof TtlRunnable) {
            if (idempotent) {
                return (TtlRunnable)runnable;
            }
            throw new IllegalStateException("Already TtlRunnable!");
        }
        return new TtlRunnable(runnable, releaseTtlValueReferenceAfterRun);
    }

    public static List<TtlRunnable> gets(Collection<? extends Runnable> tasks) {
        return TtlRunnable.gets(tasks, false, false);
    }

    public static List<TtlRunnable> gets(Collection<? extends Runnable> tasks, boolean releaseTtlValueReferenceAfterRun) {
        return TtlRunnable.gets(tasks, releaseTtlValueReferenceAfterRun, false);
    }

    public static List<TtlRunnable> gets(Collection<? extends Runnable> tasks, boolean releaseTtlValueReferenceAfterRun, boolean idempotent) {
        if (null == tasks) {
            return Collections.emptyList();
        }
        ArrayList<TtlRunnable> copy = new ArrayList<TtlRunnable>();
        for (Runnable runnable : tasks) {
            copy.add(TtlRunnable.get(runnable, releaseTtlValueReferenceAfterRun, idempotent));
        }
        return copy;
    }
}

