/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.web.controller;

import cn.com.duiba.tuia.media.api.dto.MediaAppDto;
import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqCreatMediaAppDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.model.Result;
import cn.com.duiba.tuia.media.model.req.ReqPageQueryMediaApp;
import cn.com.duiba.tuia.media.model.req.ReqUpdateMediaApp;
import cn.com.duiba.tuia.media.model.rsp.RspIdAndValue;
import cn.com.duiba.tuia.media.model.rsp.RspMediaApp;
import cn.com.duiba.tuia.media.service.MediaAppService;
import cn.com.duiba.tuia.media.utils.RequestLocal;
import cn.com.duiba.tuia.media.web.aop.LogWrite;
import cn.com.duiba.tuia.media.web.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/mediaApp/"})
@Api(value="\u5a92\u4f53\u76f8\u5173api")
public class MediaAppController
extends BaseController {
    @Autowired
    MediaAppService mediaAppService;

    @ResponseBody
    @ApiOperation(value="\u67e5\u8be2\u5a92\u4f53\u4fe1\u606f\u5217\u8868", httpMethod="GET", notes="\u67e5\u8be2\u5a92\u4f53\u4fe1\u606f\u5217\u8868\u63a5\u53e3")
    @RequestMapping(value={"getList"}, method={RequestMethod.GET})
    public Result<PageResultDto<RspMediaApp>> getList(@ModelAttribute ReqPageQueryMediaApp param) {
        try {
            param.setMediaId(RequestLocal.get().getCid());
            return this.successResult(this.mediaAppService.getMediaAppList(param));
        }
        catch (TuiaMediaException e) {
            this.logger.info("MediaAppController.getList error! the param=[{}]", (Object)param);
            return this.failResult((Exception)((Object)e));
        }
    }

    @LogWrite(modelName="\u5a92\u4f53\u6a21\u5757", option="\u521b\u5efa\u5a92\u4f53")
    @ResponseBody
    @ApiOperation(value="\u65b0\u589e\u5a92\u4f53\u4fe1\u606f", httpMethod="POST", notes="\u65b0\u589e\u5a92\u4f53\u4fe1\u606f\u63a5\u53e3")
    @RequestMapping(value={"create"}, method={RequestMethod.POST})
    public Result<Boolean> create(@Valid @RequestBody ReqCreatMediaAppDto param, BindingResult result) {
        try {
            this.checkParam(result);
            param.setMediaId(RequestLocal.get().getCid());
            return this.successResult(this.mediaAppService.createMediaApp(param));
        }
        catch (TuiaMediaException e) {
            this.logger.error("MediaAppController.create error! the param=[{}]", (Object)param);
            return this.failResult((Exception)((Object)e));
        }
    }

    @LogWrite(modelName="\u5a92\u4f53\u6a21\u5757", option="\u4fee\u6539\u5a92\u4f53\u4fe1\u606f")
    @ResponseBody
    @ApiOperation(value="\u4fee\u6539\u5a92\u4f53\u4fe1\u606f", httpMethod="POST", notes="\u4fee\u6539\u5a92\u4f53\u4fe1\u606f\u63a5\u53e3")
    @RequestMapping(value={"update"}, method={RequestMethod.POST})
    public Result<Boolean> update(@Valid @RequestBody ReqUpdateMediaApp param, BindingResult result) {
        try {
            this.checkParam(result);
            return this.successResult(this.mediaAppService.updateMediaApp(param));
        }
        catch (TuiaMediaException e) {
            this.logger.error("MediaAppController.update error! the param=[{}]", (Object)param);
            return this.failResult((Exception)((Object)e));
        }
    }

    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u5a92\u4f53\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6\u5a92\u4f53\u4fe1\u606f\u63a5\u53e3")
    @RequestMapping(value={"getMediaApp"}, method={RequestMethod.GET})
    public Result<MediaAppDto> getMediaApp(@RequestParam Long appId) {
        try {
            if (appId == null) {
                throw new TuiaMediaException(ErrorCode.E0401002);
            }
            return this.successResult(this.mediaAppService.getMediaAppDto(appId));
        }
        catch (TuiaMediaException e) {
            this.logger.error("MediaAppController.getMediaApp error! the appId=[{}]", (Object)appId);
            return this.failResult((Exception)((Object)e));
        }
    }

    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u7684\u5a92\u4f53\u7528\u6237appId\u548capp\u540d\u79f0", httpMethod="GET", notes="\u83b7\u53d6\u6240\u6709\u5a92\u4f53\u7528\u6237appId\u548capp\u540d\u79f0\u4fe1\u606f\u63a5\u53e3")
    @RequestMapping(value={"getAllAppIdAndName"}, method={RequestMethod.GET})
    public Result<List<RspIdAndValue>> getAllAppIdAndName() {
        try {
            return this.successResult(this.mediaAppService.selectAppIdAndNameByMediaId(RequestLocal.get().getCid()));
        }
        catch (TuiaMediaException e) {
            this.logger.error("MediaAppController.getAllAppIdAndName error! the mediaId=[{}]", (Object)RequestLocal.get().getCid());
            return this.failResult((Exception)((Object)e));
        }
    }
}

