/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.tdc.parser;

import com.taobao.api.ApiException;
import com.taobao.api.internal.tdc.CsvMetaData;
import com.taobao.api.internal.tdc.CsvTdcResponse;
import com.taobao.api.internal.tdc.parser.CsvReader;
import com.taobao.api.internal.tdc.parser.TdcParser;
import java.io.IOException;
import java.util.ArrayList;

public class TdcCsvParser
implements TdcParser {
    public CsvTdcResponse parse(String rsp) throws ApiException {
        CsvTdcResponse csvRsp = new CsvTdcResponse();
        CsvReader cr = CsvReader.parse(rsp);
        CsvMetaData metaData = new CsvMetaData();
        ArrayList<String[]> csvResult = new ArrayList<String[]>();
        try {
            boolean hasReadHeader = false;
            while (cr.readRecord()) {
                if (!hasReadHeader) {
                    String[] headers;
                    for (String header : headers = cr.getValues()) {
                        int index = header.indexOf(".");
                        if (index == -1) {
                            if (header.equals("error_response")) {
                                this.errorRecord(cr, csvRsp, rsp, headers);
                                return csvRsp;
                            }
                            metaData.addMetaData(null, null, header);
                            continue;
                        }
                        metaData.addMetaData(header.substring(0, index), header.substring(index + 1, header.length()), header);
                    }
                    hasReadHeader = true;
                    continue;
                }
                String[] values = cr.getValues();
                csvResult.add(values);
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        csvRsp.setMetaData(metaData);
        csvRsp.setCsvResult(csvResult);
        csvRsp.setBody(rsp);
        return csvRsp;
    }

    private void errorRecord(CsvReader cr, CsvTdcResponse csvRsp, String rsp, String[] headers) throws IOException {
        cr.readRecord();
        String[] errorMsg = cr.getValues();
        if (null == errorMsg || errorMsg.length == 0) {
            return;
        }
        for (int i = 1; i < errorMsg.length; ++i) {
            if (headers[i].equals("msg")) {
                csvRsp.setMsg(errorMsg[i]);
            }
            if (headers[i].equals("code")) {
                csvRsp.setErrorCode(errorMsg[i]);
            }
            if (headers[i].equals("sub_code")) {
                csvRsp.setSubCode(errorMsg[i]);
            }
            if (!headers[i].equals("sub_msg")) continue;
            csvRsp.setSubMsg(errorMsg[i]);
        }
        csvRsp.setBody(rsp);
    }
}

