/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.top.link.embedded.websocket.impl;

import com.taobao.top.link.embedded.websocket.HttpHeader;
import com.taobao.top.link.embedded.websocket.WebSocket;
import com.taobao.top.link.embedded.websocket.exception.ErrorCode;
import com.taobao.top.link.embedded.websocket.exception.WebSocketException;
import com.taobao.top.link.embedded.websocket.frame.Frame;
import com.taobao.top.link.embedded.websocket.frame.FrameParser;
import com.taobao.top.link.embedded.websocket.frame.draft76.BinaryFrame;
import com.taobao.top.link.embedded.websocket.handler.PacketDumpStreamHandler;
import com.taobao.top.link.embedded.websocket.handler.SSLStreamHandler;
import com.taobao.top.link.embedded.websocket.handler.StreamHandlerAdapter;
import com.taobao.top.link.embedded.websocket.handler.StreamHandlerChain;
import com.taobao.top.link.embedded.websocket.handler.WebSocketHandler;
import com.taobao.top.link.embedded.websocket.handler.WebSocketPipeline;
import com.taobao.top.link.embedded.websocket.handler.WebSocketStreamHandler;
import com.taobao.top.link.embedded.websocket.handshake.Handshake;
import com.taobao.top.link.embedded.websocket.handshake.ProxyHandshake;
import com.taobao.top.link.embedded.websocket.handshake.SSLHandshake;
import com.taobao.top.link.embedded.websocket.proxy.Proxy;
import com.taobao.top.link.embedded.websocket.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebSocketBase
implements WebSocket {
    private static Logger log = Logger.getLogger(WebSocketBase.class.getName());
    protected URI location;
    protected String path;
    protected boolean useSsl = false;
    protected SSLHandshake sslHandshake;
    protected InetSocketAddress endpointAddress;
    protected Proxy proxy;
    protected int connectionTimeout = 60000;
    protected int connectionReadTimeout = 0;
    private boolean blockingMode = true;
    private int packetDumpMode;
    protected volatile boolean quit;
    protected String[] protocols;
    protected String[] serverProtocols;
    protected int bufferSize;
    protected ByteBuffer upstreamBuffer;
    protected ByteBuffer downstreamBuffer;
    protected String origin;
    protected BlockingQueue<ByteBuffer> upstreamQueue;
    protected WebSocketHandler handler;
    protected WebSocketPipeline pipeline;
    protected SocketChannel socket;
    protected Selector selector;
    private Handshake handshake;
    private FrameParser frameParser;
    protected HttpHeader responseHeader;
    protected HttpHeader requestHeader;
    protected int responseStatus;
    protected volatile State state = State.CLOSED;
    protected CountDownLatch closeLatch;
    protected CountDownLatch handshakeLatch;
    protected ExecutorService executorService;
    private AtomicInteger executorThreadNumber = new AtomicInteger(0);
    private String executorThreadName;

    public WebSocketBase(String url, String origin, WebSocketHandler handler, String ... protocols) throws WebSocketException {
        this.origin = origin;
        this.protocols = protocols;
        this.handler = handler;
        this.init(url);
    }

    public WebSocketBase(String url, WebSocketHandler handler, String ... protocols) throws WebSocketException {
        this.protocols = protocols;
        this.handler = handler;
        this.init(url);
        this.origin = this.location.getHost() + (this.location.getPort() > 0 ? ":" + this.location.getPort() : "");
    }

    public WebSocketBase(String url, String origin, Proxy proxy, WebSocketHandler handler, String ... protocols) throws WebSocketException {
        this.origin = origin;
        this.protocols = protocols;
        this.handler = handler;
        this.proxy = proxy;
        this.init(url);
    }

    public WebSocketBase(String url, Proxy proxy, WebSocketHandler handler, String ... protocols) throws WebSocketException {
        this.protocols = protocols;
        this.handler = handler;
        this.proxy = proxy;
        this.init(url);
        this.origin = this.location.getHost() + ":" + this.location.getPort();
    }

    protected void init(String url) throws WebSocketException {
        this.initializeProperties();
        this.parseUrl(url);
        this.initializePipeline();
    }

    protected void initializeProperties() throws WebSocketException {
        this.bufferSize = Integer.getInteger("websocket.bufferSize", Short.MAX_VALUE);
        int upstreamQueueSize = Integer.getInteger("websocket.upstreamQueueSize", 500);
        this.upstreamQueue = new LinkedBlockingQueue<ByteBuffer>(upstreamQueueSize);
        this.downstreamBuffer = ByteBuffer.allocate(this.bufferSize);
        this.upstreamBuffer = ByteBuffer.allocate(this.bufferSize);
        this.packetDumpMode = Integer.getInteger("websocket.packatdump", 0);
        this.requestHeader = new HttpHeader();
    }

    protected void initializePipeline() throws WebSocketException {
        this.pipeline = new WebSocketPipeline();
        this.pipeline.addStreamHandler(new StreamHandlerAdapter(){

            public void nextUpstreamHandler(WebSocket ws, ByteBuffer buffer, Frame frame, StreamHandlerChain chain) throws WebSocketException {
                if (!WebSocketBase.this.upstreamQueue.offer(buffer)) {
                    throw new WebSocketException(ErrorCode.E3030);
                }
                WebSocketBase.this.selector.wakeup();
            }

            public void nextHandshakeUpstreamHandler(WebSocket ws, ByteBuffer buffer, StreamHandlerChain chain) throws WebSocketException {
                if (!WebSocketBase.this.upstreamQueue.offer(buffer)) {
                    throw new WebSocketException(ErrorCode.E3031);
                }
                WebSocketBase.this.selector.wakeup();
            }
        });
        if (this.useSsl) {
            this.sslHandshake = new SSLHandshake(this.endpointAddress, this);
            this.pipeline.addStreamHandler(new PacketDumpStreamHandler());
            this.pipeline.addStreamHandler(new SSLStreamHandler(this.sslHandshake, this.bufferSize));
        }
        this.initializePipeline(this.pipeline);
    }

    protected void initializePipeline(WebSocketPipeline pipeline) throws WebSocketException {
        this.pipeline.addStreamHandler(new PacketDumpStreamHandler());
        this.pipeline.addStreamHandler(new WebSocketStreamHandler(this.getHandshake(), this.getFrameParser()));
    }

    private void parseUrl(String urlStr) throws WebSocketException {
        try {
            URI uri = new URI(urlStr);
            if (!uri.getScheme().equals("ws") && !uri.getScheme().equals("wss")) {
                throw new WebSocketException(ErrorCode.E3007, uri.toString());
            }
            if (uri.getScheme().equals("wss")) {
                this.useSsl = true;
            }
            this.path = (uri.getPath().equals("") ? "/" : uri.getPath()) + (uri.getQuery() != null ? "?" + uri.getQuery() : "");
            int port = uri.getPort();
            if (port < 0) {
                if (uri.getScheme().equals("ws")) {
                    port = 80;
                } else if (uri.getScheme().equals("wss")) {
                    port = 443;
                    this.useSsl = true;
                } else {
                    throw new WebSocketException(ErrorCode.E3008, uri.toString());
                }
            }
            this.endpointAddress = new InetSocketAddress(uri.getHost(), port);
            this.location = uri;
        }
        catch (URISyntaxException e) {
            throw new WebSocketException(ErrorCode.E3009, (Throwable)e);
        }
    }

    @Override
    public URI getLocation() {
        return this.location;
    }

    @Override
    public void send(Frame frame) throws WebSocketException {
        if (!this.isConnected()) {
            throw new WebSocketException(ErrorCode.E3010);
        }
        this.pipeline.sendUpstream(this, null, frame);
    }

    public void send(Object obj) throws WebSocketException {
        this.send(this.createFrame(obj));
    }

    @Override
    public void send(ByteBuffer buffer) throws WebSocketException {
        this.send(this.createFrame(buffer));
    }

    @Override
    public void send(byte[] bytes) throws WebSocketException {
        this.send(this.createFrame(bytes));
    }

    @Override
    public void send(String str) throws WebSocketException {
        this.send(this.createFrame(str));
    }

    protected State transitionTo(State to) {
        if (this.state.canTransitionTo(to)) {
            State old = this.state;
            this.state = to;
            return old;
        }
        throw new IllegalStateException("Couldn't transtion from " + (Object)((Object)this.state) + " to " + (Object)((Object)to));
    }

    protected State state() {
        return this.state;
    }

    protected void read(SocketChannel socket, ByteBuffer buffer) throws WebSocketException {
        try {
            buffer.clear();
            if (socket.read(buffer) < 0) {
                throw new WebSocketException(ErrorCode.E3020);
            }
            buffer.flip();
        }
        catch (IOException ioe) {
            throw new WebSocketException(ErrorCode.E3021, (Throwable)ioe);
        }
    }

    protected SocketChannel createSocket() throws IOException {
        SocketChannel socket = SocketChannel.open();
        socket.configureBlocking(false);
        return socket;
    }

    @Override
    public void connect() throws WebSocketException {
        try {
            if (this.isConnected()) {
                throw new WebSocketException(ErrorCode.E3039);
            }
            if (!this.state.canTransitionTo(State.CONNECTED)) {
                throw new WebSocketException(ErrorCode.E3040, this.state.name());
            }
            this.handshakeLatch = new CountDownLatch(1);
            this.closeLatch = new CountDownLatch(1);
            ProxyHandshake proxyHandshake = null;
            if (this.proxy != null) {
                proxyHandshake = this.proxy.getProxyHandshake(this);
            }
            this.socket = SocketChannel.open();
            this.socket.configureBlocking(false);
            this.selector = Selector.open();
            this.socket.register(this.selector, 1);
            long start = System.currentTimeMillis();
            InetSocketAddress remoteAddress = this.endpointAddress;
            if (proxyHandshake != null) {
                remoteAddress = proxyHandshake.getProxyAddress();
            }
            if (this.socket.connect(remoteAddress)) {
                throw new WebSocketException(ErrorCode.E3041);
            }
            while (!this.socket.finishConnect()) {
                if (System.currentTimeMillis() - start <= (long)this.connectionTimeout) continue;
                throw new WebSocketException(ErrorCode.E3042);
            }
            this.transitionTo(State.CONNECTED);
            if (proxyHandshake != null) {
                proxyHandshake.doHandshake(this.socket);
            }
            if (this.useSsl) {
                this.sslHandshake.doHandshake(this.socket);
            }
            this.pipeline.sendHandshakeUpstream(this, null);
            this.transitionTo(State.HANDSHAKE);
            Runnable worker = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public void run() {
                    while (!WebSocketBase.this.quit) {
                        WebSocketBase.this.selector.select(100L);
                        for (SelectionKey key : WebSocketBase.this.selector.selectedKeys()) {
                            if (key.isValid() && key.isWritable() && WebSocketBase.this.upstreamQueue.peek() != null) {
                                SocketChannel channel = (SocketChannel)key.channel();
                                channel.write((ByteBuffer)WebSocketBase.this.upstreamQueue.poll());
                                WebSocketBase.this.socket.register(WebSocketBase.this.selector, 1);
                                continue;
                            }
                            if (!key.isValid() || !key.isReadable()) continue;
                            WebSocketBase.this.read(WebSocketBase.this.socket, WebSocketBase.this.downstreamBuffer);
                            switch (WebSocketBase.this.state) {
                                case HANDSHAKE: {
                                    WebSocketBase.this.pipeline.sendHandshakeDownstream(WebSocketBase.this, WebSocketBase.this.downstreamBuffer);
                                    if (!WebSocketBase.this.getHandshake().isDone()) break;
                                    WebSocketBase.this.processBuffer(WebSocketBase.this.downstreamBuffer);
                                    WebSocketBase.this.handshakeLatch.countDown();
                                    break;
                                }
                                case WAIT: 
                                case CLOSING: {
                                    WebSocketBase.this.processBuffer(WebSocketBase.this.downstreamBuffer);
                                    break;
                                }
                            }
                        }
                        if (!WebSocketBase.this.upstreamQueue.isEmpty()) {
                            if (WebSocketBase.this.state != State.CLOSED) {
                                WebSocketBase.this.socket.register(WebSocketBase.this.selector, 5);
                                continue;
                            }
                            WebSocketBase.this.socket.register(WebSocketBase.this.selector, 4);
                            continue;
                        }
                        if (WebSocketBase.this.state != State.CLOSED) continue;
                        WebSocketBase.this.quit = true;
                    }
                    Object var5_6 = null;
                    try {
                        WebSocketBase.this.socket.close();
                    }
                    catch (IOException ex) {
                        log.log(Level.INFO, "close socket error", ex);
                    }
                    try {
                        WebSocketBase.this.selector.close();
                    }
                    catch (IOException ex) {
                        log.log(Level.INFO, "close selector error", ex);
                    }
                    WebSocketBase.this.handler.onClose(WebSocketBase.this);
                    WebSocketBase.this.handshakeLatch.countDown();
                    WebSocketBase.this.closeLatch.countDown();
                    2 var6_10 = this;
                    synchronized (var6_10) {
                        if (WebSocketBase.this.executorService != null) {
                            WebSocketBase.this.executorService.shutdown();
                        }
                    }
                    {
                        catch (WebSocketException we) {
                            WebSocketBase.this.handler.onError(WebSocketBase.this, we);
                            Object var5_7 = null;
                            try {
                                WebSocketBase.this.socket.close();
                            }
                            catch (IOException ex) {
                                log.log(Level.INFO, "close socket error", ex);
                            }
                            try {
                                WebSocketBase.this.selector.close();
                            }
                            catch (IOException ex) {
                                log.log(Level.INFO, "close selector error", ex);
                            }
                            WebSocketBase.this.handler.onClose(WebSocketBase.this);
                            WebSocketBase.this.handshakeLatch.countDown();
                            WebSocketBase.this.closeLatch.countDown();
                            2 var6_11 = this;
                            synchronized (var6_11) {
                                if (WebSocketBase.this.executorService != null) {
                                    WebSocketBase.this.executorService.shutdown();
                                }
                            }
                        }
                        catch (Exception e) {
                            WebSocketBase.this.handler.onError(WebSocketBase.this, new WebSocketException(ErrorCode.E3043, (Throwable)e));
                            Object var5_8 = null;
                            try {
                                WebSocketBase.this.socket.close();
                            }
                            catch (IOException ex) {
                                log.log(Level.INFO, "close socket error", ex);
                            }
                            try {
                                WebSocketBase.this.selector.close();
                            }
                            catch (IOException ex) {
                                log.log(Level.INFO, "close selector error", ex);
                            }
                            WebSocketBase.this.handler.onClose(WebSocketBase.this);
                            WebSocketBase.this.handshakeLatch.countDown();
                            WebSocketBase.this.closeLatch.countDown();
                            2 var6_12 = this;
                            synchronized (var6_12) {
                                if (WebSocketBase.this.executorService != null) {
                                    WebSocketBase.this.executorService.shutdown();
                                }
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_9 = null;
                        try {
                            WebSocketBase.this.socket.close();
                        }
                        catch (IOException ex) {
                            log.log(Level.INFO, "close socket error", ex);
                        }
                        try {
                            WebSocketBase.this.selector.close();
                        }
                        catch (IOException ex) {
                            log.log(Level.INFO, "close selector error", ex);
                        }
                        WebSocketBase.this.handler.onClose(WebSocketBase.this);
                        WebSocketBase.this.handshakeLatch.countDown();
                        WebSocketBase.this.closeLatch.countDown();
                        2 var6_13 = this;
                        synchronized (var6_13) {
                            if (WebSocketBase.this.executorService != null) {
                                WebSocketBase.this.executorService.shutdown();
                            }
                        }
                        throw throwable;
                    }
                }
            };
            this.quit = false;
            if (this.blockingMode) {
                worker.run();
            } else {
                this.executorThreadName = "WebSocket-Executor-" + this.executorThreadNumber.incrementAndGet();
                this.executorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

                    public Thread newThread(Runnable r) {
                        Thread t = new Thread(r, WebSocketBase.this.executorThreadName);
                        t.setDaemon(true);
                        return t;
                    }
                });
                this.executorService.submit(worker);
                this.executorService.shutdown();
                this.handshakeLatch.await();
            }
        }
        catch (Exception e) {
            try {
                this.socket.close();
            }
            catch (IOException ex) {
                log.log(Level.INFO, "close socket error", ex);
            }
            try {
                this.selector.close();
            }
            catch (IOException ex) {
                log.log(Level.INFO, "close selector error", ex);
            }
            throw new WebSocketException(ErrorCode.E3044, (Throwable)e);
        }
    }

    protected void processBuffer(ByteBuffer buffer) throws WebSocketException {
        while (buffer.hasRemaining()) {
            this.pipeline.sendDownstream(this, buffer, null);
        }
    }

    @Override
    public boolean isConnected() {
        return this.state.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        try {
            WebSocketBase webSocketBase;
            if (this.state != State.WAIT) return;
            this.closeWebSocket();
            this.selector.wakeup();
            if (Thread.currentThread().getName().equals(this.executorThreadName)) return;
            try {
                this.closeLatch.await(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this.executorService == null) return;
            try {
                try {
                    this.executorService.shutdown();
                    this.executorService.awaitTermination(30L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Object var3_5 = null;
                    WebSocketBase webSocketBase3 = this;
                    synchronized (webSocketBase3) {
                        this.executorService = null;
                        return;
                    }
                }
                Object var3_4 = null;
                webSocketBase = this;
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                WebSocketBase webSocketBase2 = this;
                synchronized (webSocketBase2) {
                    this.executorService = null;
                    throw throwable;
                }
            }
            synchronized (webSocketBase) {
                this.executorService = null;
                return;
            }
        }
        catch (WebSocketException e) {
            this.handler.onError(this, e);
        }
    }

    protected void awaitTermination(int timeout, TimeUnit unit) throws InterruptedException {
        if (this.executorService != null) {
            this.executorService.awaitTermination(timeout, unit);
        }
    }

    @Override
    public void awaitClose() throws InterruptedException {
        this.closeLatch.await();
    }

    protected void closeWebSocket() throws WebSocketException {
        this.quit = true;
        this.transitionTo(State.CLOSED);
    }

    @Override
    public Frame createFrame(Object obj) throws WebSocketException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            byte[] bodyData = baos.toByteArray();
            return new BinaryFrame(bodyData);
        }
        catch (Exception e) {
            throw new WebSocketException(ErrorCode.E3550, (Throwable)e);
        }
    }

    @Override
    public Frame createFrame(ByteBuffer buffer) throws WebSocketException {
        byte[] bytes = new byte[buffer.limit()];
        buffer.get(bytes);
        return this.createFrame(bytes);
    }

    @Override
    public abstract Frame createFrame(byte[] var1) throws WebSocketException;

    @Override
    public abstract Frame createFrame(String var1) throws WebSocketException;

    protected static String join(String delim, Collection<String> collections) {
        return StringUtil.join(delim, collections);
    }

    protected static String join(String delim, String ... strings) {
        return StringUtil.join(delim, strings);
    }

    protected static String join(String delim, int start, int end, String ... strings) {
        return StringUtil.join(delim, start, end, strings);
    }

    protected static void addHeader(StringBuilder sb, String key, String value) {
        StringUtil.addHeader(sb, key, value);
    }

    protected abstract int getWebSocketVersion();

    protected abstract Handshake newHandshakeInstance();

    protected synchronized Handshake getHandshake() {
        if (this.handshake == null) {
            this.handshake = this.newHandshakeInstance();
        }
        return this.handshake;
    }

    protected abstract FrameParser newFrameParserInstance();

    protected synchronized FrameParser getFrameParser() {
        if (this.frameParser == null) {
            this.frameParser = this.newFrameParserInstance();
        }
        return this.frameParser;
    }

    @Override
    public boolean isBlockingMode() {
        return this.blockingMode;
    }

    @Override
    public void setBlockingMode(boolean blockingMode) {
        this.blockingMode = blockingMode;
    }

    public String[] getServerProtocols() {
        return this.serverProtocols;
    }

    public void setServerProtocols(String[] serverProtocols) {
        this.serverProtocols = serverProtocols;
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public InetSocketAddress getEndpoint() {
        return this.endpointAddress;
    }

    public String[] getProtocols() {
        return this.protocols;
    }

    public String getOrigin() {
        return this.origin;
    }

    public HttpHeader getResponseHeader() {
        return this.responseHeader;
    }

    public HttpHeader getRequestHeader() {
        return this.requestHeader;
    }

    public int getResponseStatus() {
        return this.responseStatus;
    }

    @Override
    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout * 1000;
    }

    public int getConnectionReadTimeout() {
        return this.connectionReadTimeout;
    }

    public void setConnectionReadTimeout(int connectionReadTimeout) {
        this.connectionReadTimeout = connectionReadTimeout * 1000;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    public int getPacketDumpMode() {
        return this.packetDumpMode;
    }

    public void setPacketDumpMode(int packetDumpMode) {
        this.packetDumpMode = packetDumpMode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        CONNECTED,
        HANDSHAKE,
        WAIT,
        CLOSING,
        CLOSED;

        private static EnumMap<State, EnumSet<State>> stateMap;

        boolean canTransitionTo(State state) {
            EnumSet<State> set = stateMap.get((Object)this);
            if (set == null) {
                return false;
            }
            return set.contains((Object)state);
        }

        boolean isConnected() {
            switch (this) {
                case CONNECTED: 
                case HANDSHAKE: 
                case WAIT: {
                    return true;
                }
            }
            return false;
        }

        static {
            stateMap = new EnumMap(State.class);
            stateMap.put(CONNECTED, EnumSet.of(HANDSHAKE, CLOSED));
            stateMap.put(HANDSHAKE, EnumSet.of(WAIT, CLOSED));
            stateMap.put(WAIT, EnumSet.of(WAIT, CLOSING, CLOSED));
            stateMap.put(CLOSING, EnumSet.of(CLOSED));
            stateMap.put(CLOSED, EnumSet.of(CONNECTED, CLOSED));
        }
    }
}

