/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.bo.impl;

import cn.com.duiba.activity.center.api.dto.activity.AdvActivityDto;
import cn.com.duiba.activity.center.api.remoteservice.activity.RemoteOperatingActivityServiceNew;
import cn.com.duiba.tuia.media.api.constant.ActivityTypeConstant;
import cn.com.duiba.tuia.media.api.dto.BaseActivityDataDto;
import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqGetActivityData;
import cn.com.duiba.tuia.media.api.dto.rsp.RspGetActivityData;
import cn.com.duiba.tuia.media.api.dto.rsp.RspGetActivityDetailData;
import cn.com.duiba.tuia.media.bo.ActivityStatisticsDayBO;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.common.tool.DataTool;
import cn.com.duiba.tuia.media.domain.ActivityStatisticsDayDto;
import cn.com.duiba.tuia.media.model.IdAndName;
import cn.com.duiba.tuia.media.model.req.ReqActivityData;
import cn.com.duiba.tuia.media.service.ActivityStatisticsDayService;
import cn.com.duiba.tuia.media.service.MediaAppService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityStatisticsDayBOImpl
implements ActivityStatisticsDayBO {
    private static final int ACTIVITY_CENTER_MAX_BACTCH_LENGTH = 20;
    private Logger logger = LoggerFactory.getLogger(ActivityStatisticsDayBOImpl.class);
    @Autowired
    private ActivityStatisticsDayService activityStatisticsDayService;
    @Autowired
    private RemoteOperatingActivityServiceNew remoteOperatingActivityServiceNew;
    @Autowired
    private MediaAppService mediaAppService;

    @Override
    public PageResultDto<RspGetActivityData> getActivityDataByPage(ReqGetActivityData req) throws TuiaMediaException {
        ReqActivityData queryParam = this.buildReqActivityData(req);
        ArrayList<RspGetActivityData> resultActivityDatas = null;
        int totalAmount = this.activityStatisticsDayService.selectAmountByPage(queryParam);
        if (totalAmount > 0 && totalAmount >= queryParam.getRowStart()) {
            List<ActivityStatisticsDayDto> activityDataList = this.activityStatisticsDayService.selectListByPage(queryParam);
            Map<Long, String> activityNameMap = this.buildActivityNameMap(activityDataList);
            resultActivityDatas = new ArrayList<RspGetActivityData>(activityDataList.size());
            for (ActivityStatisticsDayDto activityData : activityDataList) {
                RspGetActivityData rspGetActivityData = new RspGetActivityData();
                resultActivityDatas.add(rspGetActivityData);
                rspGetActivityData.setActivityId(activityData.getDuibaActivityId());
                rspGetActivityData.setActivityName(activityNameMap.get(activityData.getDuibaActivityId()));
                rspGetActivityData.setActivityType(activityData.getDuibaActivityType());
                rspGetActivityData.setActivityTypeName(ActivityTypeConstant.getTypeText((Integer)activityData.getDuibaActivityType()));
                this.buidBaseActivityData((BaseActivityDataDto)rspGetActivityData, activityData);
            }
        }
        return new PageResultDto(totalAmount, resultActivityDatas, queryParam.getPageSize().intValue());
    }

    private ReqActivityData buildReqActivityData(ReqGetActivityData req) {
        ReqActivityData queryParam = new ReqActivityData(req.getActivityType(), req.getActivityId(), req.getStartTime(), req.getEndTime());
        queryParam.setPageSize(req.getPageSize() == null ? 20 : req.getPageSize());
        queryParam.setRowStart((req.getCurrentPage() - 1) * req.getPageSize());
        queryParam.setOrder(req.getOrder());
        queryParam.setSort(req.getSort());
        return queryParam;
    }

    private void buidBaseActivityData(BaseActivityDataDto baseActivityDataDto, ActivityStatisticsDayDto activityData) {
        baseActivityDataDto.setActivityUv(activityData.getActivityUv());
        baseActivityDataDto.setClickAdvertCount(activityData.getClickAdvertCount());
        baseActivityDataDto.setClickCount(activityData.getClickCount());
        baseActivityDataDto.setConsumeTotal(activityData.getConsumeTotal());
        baseActivityDataDto.setInvolveCounts(activityData.getInvolveCounts());
        baseActivityDataDto.setParticipantCounts(activityData.getParticipantCounts());
        long exposureCount = activityData.getExposureCount();
        baseActivityDataDto.setExposureCount(exposureCount);
        long launchAdvertCount = activityData.getLaunchAdvertCount();
        baseActivityDataDto.setLaunchAdvertCount(launchAdvertCount);
        baseActivityDataDto.seteCPM(DataTool.calculateEcpm((Long)activityData.getConsumeTotal(), (Long)exposureCount));
        baseActivityDataDto.setExposureCTR(DataTool.extendHundred((Float)DataTool.calculateRatio((Long)activityData.getClickCount(), (Long)exposureCount)));
        baseActivityDataDto.setLaunchRate(DataTool.extendHundred((Float)DataTool.calculateRatio((Long)launchAdvertCount, (Long)activityData.getInvolveCounts())));
        baseActivityDataDto.setPerParticipate(DataTool.calculateAveragePrice((Long)activityData.getInvolveCounts(), (Long)activityData.getParticipantCounts()));
        baseActivityDataDto.setRate(DataTool.extendHundred((Float)DataTool.calculateRatio((Long)activityData.getParticipantCounts(), (Long)activityData.getActivityUv())));
        baseActivityDataDto.setSpm(DataTool.calculateEcpm((Long)launchAdvertCount, (Long)exposureCount));
    }

    private Map<Long, String> buildActivityNameMap(List<ActivityStatisticsDayDto> activityDataList) throws TuiaMediaException {
        int size = activityDataList.size();
        ArrayList<Long> activityIds = new ArrayList<Long>(size);
        for (ActivityStatisticsDayDto activityData : activityDataList) {
            activityIds.add(activityData.getDuibaActivityId());
        }
        HashMap<Long, String> activityNameMap = new HashMap<Long, String>(size);
        ArrayList<AdvActivityDto> advActivityDtoList = new ArrayList<AdvActivityDto>(size);
        int j = 0;
        for (int i = 1; i <= size; ++i) {
            if (i % 20 != 0 && i != size) continue;
            List<AdvActivityDto> activityDtos = this.doGetAdvActivtyDto(activityIds.subList(j, i));
            if (CollectionUtils.isNotEmpty(activityDtos)) {
                advActivityDtoList.addAll(activityDtos);
            }
            j = i;
        }
        if (CollectionUtils.isNotEmpty(advActivityDtoList)) {
            for (AdvActivityDto advActivityDto : advActivityDtoList) {
                activityNameMap.put(advActivityDto.getOperatingActiivtyId(), advActivityDto.getName());
            }
        }
        return activityNameMap;
    }

    private List<AdvActivityDto> doGetAdvActivtyDto(List<Long> activityIds) throws TuiaMediaException {
        DubboResult dubboResult = this.remoteOperatingActivityServiceNew.batchQueryAdvActivty(activityIds);
        if (dubboResult.isResultSuccess()) {
            this.logger.error("[AC] remoteOperatingActivityServiceNew.batchQueryAdvActivty error!, the reason=[{}]", (Object)dubboResult.getMsg());
            throw new TuiaMediaException(ErrorCode.E9999999);
        }
        return (List)dubboResult.getResult();
    }

    private Map<Long, String> buildAppNameMap(List<ActivityStatisticsDayDto> activityDataList) throws TuiaMediaException {
        int size = activityDataList.size();
        ArrayList<Long> appIds = new ArrayList<Long>(size);
        for (ActivityStatisticsDayDto activityData : activityDataList) {
            appIds.add(activityData.getAppId());
        }
        List<IdAndName> appList = this.mediaAppService.selectAppIdAndName(appIds);
        HashMap<Long, String> appNameMap = new HashMap<Long, String>(size);
        for (IdAndName app : appList) {
            appNameMap.put(app.getId(), app.getName());
        }
        return appNameMap;
    }

    @Override
    public PageResultDto<RspGetActivityDetailData> getActivityDetailDataByPage(ReqGetActivityData req) throws TuiaMediaException {
        ReqActivityData queryParam = this.buildReqActivityData(req);
        ArrayList<RspGetActivityDetailData> resultActivityDatas = null;
        int totalAmount = this.activityStatisticsDayService.selectAmountByDetail(queryParam);
        if (totalAmount > 0 && totalAmount >= queryParam.getRowStart()) {
            List<ActivityStatisticsDayDto> activityDataList = this.activityStatisticsDayService.selectListByDetail(queryParam);
            Map<Long, String> appNameMap = this.buildAppNameMap(activityDataList);
            resultActivityDatas = new ArrayList<RspGetActivityDetailData>(activityDataList.size());
            for (ActivityStatisticsDayDto activityData : activityDataList) {
                RspGetActivityDetailData rspGetActivityDetailData = new RspGetActivityDetailData();
                resultActivityDatas.add(rspGetActivityDetailData);
                rspGetActivityDetailData.setAppName(appNameMap.get(activityData.getAppId()));
                rspGetActivityDetailData.setAppId(activityData.getAppId());
                this.buidBaseActivityData((BaseActivityDataDto)rspGetActivityDetailData, activityData);
            }
        }
        return new PageResultDto(totalAmount, resultActivityDatas, queryParam.getPageSize().intValue());
    }

    @Override
    public List<RspGetActivityData> getActivityDataList(ReqGetActivityData req) throws TuiaMediaException {
        ReqActivityData queryParam = new ReqActivityData(req.getActivityType(), req.getActivityId(), req.getStartTime(), req.getEndTime());
        queryParam.setPageSize(10000);
        List<ActivityStatisticsDayDto> activityDataList = this.activityStatisticsDayService.selectListByPage(queryParam);
        Map<Long, String> activityNameMap = this.buildActivityNameMap(activityDataList);
        ArrayList<RspGetActivityData> resultActivityDatas = new ArrayList<RspGetActivityData>(activityDataList.size());
        for (ActivityStatisticsDayDto activityData : activityDataList) {
            RspGetActivityData rspGetActivityData = new RspGetActivityData();
            resultActivityDatas.add(rspGetActivityData);
            rspGetActivityData.setActivityId(activityData.getDuibaActivityId());
            rspGetActivityData.setActivityName(activityNameMap.get(activityData.getDuibaActivityId()));
            rspGetActivityData.setActivityType(activityData.getDuibaActivityType());
            rspGetActivityData.setActivityTypeName(ActivityTypeConstant.getTypeText((Integer)activityData.getDuibaActivityType()));
            this.buidBaseActivityData((BaseActivityDataDto)rspGetActivityData, activityData);
        }
        return resultActivityDatas;
    }

    @Override
    public List<RspGetActivityDetailData> getActivityDetailDataList(ReqGetActivityData req) throws TuiaMediaException {
        ReqActivityData queryParam = new ReqActivityData(req.getActivityType(), req.getActivityId(), req.getStartTime(), req.getEndTime());
        queryParam.setPageSize(10000);
        List<ActivityStatisticsDayDto> activityDataList = this.activityStatisticsDayService.selectListByDetail(queryParam);
        Map<Long, String> appNameMap = this.buildAppNameMap(activityDataList);
        ArrayList<RspGetActivityDetailData> resultActivityDatas = new ArrayList<RspGetActivityDetailData>(activityDataList.size());
        for (ActivityStatisticsDayDto activityData : activityDataList) {
            RspGetActivityDetailData rspGetActivityDetailData = new RspGetActivityDetailData();
            resultActivityDatas.add(rspGetActivityDetailData);
            rspGetActivityDetailData.setAppName(appNameMap.get(activityData.getAppId()));
            rspGetActivityDetailData.setAppId(activityData.getAppId());
            this.buidBaseActivityData((BaseActivityDataDto)rspGetActivityDetailData, activityData);
        }
        return resultActivityDatas;
    }
}

