/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.dao.impl;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.dao.MaterialSpecificationItemContentDAO;
import cn.com.duiba.tuia.media.dataobject.MaterialSpecificationItemContentDO;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository(value="materialSpecificationItemContentDAO")
public class MaterialSpecificationItemContentDAOImpl
extends BaseDAO
implements MaterialSpecificationItemContentDAO {
    @Override
    public int insertBatch(List<MaterialSpecificationItemContentDO> list) throws TuiaMediaException {
        try {
            if (CollectionUtils.isEmpty(list)) {
                return 0;
            }
            return this.getSqlSession().insert(this.getStamentNameSpace("insertBatch"), list);
        }
        catch (Exception e) {
            this.logger.error("MaterialSpecificationItemContentDAO.insertBatch happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int delete(Long activityId, Integer activityType) throws TuiaMediaException {
        try {
            HashMap<String, Number> map = new HashMap<String, Number>();
            map.put("activityId", activityId);
            map.put("activityType", activityType);
            return this.getSqlSession().delete(this.getStamentNameSpace("delete"), map);
        }
        catch (Exception e) {
            this.logger.error("MaterialSpecificationItemContentDAO.delete happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public MaterialSpecificationItemContentDO hasItemContent(Long activityId, Integer activityType) throws TuiaMediaException {
        try {
            HashMap<String, Number> map = new HashMap<String, Number>();
            map.put("activityId", activityId);
            map.put("activityType", activityType);
            return (MaterialSpecificationItemContentDO)this.getSqlSession().selectOne(this.getStamentNameSpace("hasItemContent"), map);
        }
        catch (Exception e) {
            this.logger.error("MaterialSpecificationItemContentDAO.hasItemContent happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<MaterialSpecificationItemContentDO> getByActivity(Long activityId, Integer activityType) throws TuiaMediaException {
        try {
            HashMap<String, Number> map = new HashMap<String, Number>();
            map.put("activityId", activityId);
            map.put("activityType", activityType);
            return this.getSqlSession().selectList(this.getStamentNameSpace("getByActivity"), map);
        }
        catch (Exception e) {
            this.logger.error("MaterialSpecificationItemContentDAO.getByActivity happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }
}

