/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.util.ResourceSet;
import org.apache.catalina.webresources.AbstractResourceSet;
import org.apache.catalina.webresources.EmptyResource;
import org.apache.catalina.webresources.JarResourceRoot;

public abstract class AbstractArchiveResourceSet
extends AbstractResourceSet {
    private final HashMap<String, JarEntry> jarFileEntries = new HashMap();
    private URL baseUrl;
    private String baseUrlString;
    private Manifest manifest;
    private JarFile archive = null;
    private final Object archiveLock = new Object();
    private long archiveUseCount = 0L;

    protected final void setManifest(Manifest manifest) {
        this.manifest = manifest;
    }

    protected final Manifest getManifest() {
        return this.manifest;
    }

    protected final void setBaseUrl(URL baseUrl) {
        this.baseUrl = baseUrl;
        this.baseUrlString = baseUrl == null ? null : baseUrl.toString();
    }

    @Override
    public final URL getBaseUrl() {
        return this.baseUrl;
    }

    protected final String getBaseUrlString() {
        return this.baseUrlString;
    }

    protected final HashMap<String, JarEntry> getJarFileEntries() {
        return this.jarFileEntries;
    }

    @Override
    public final String[] list(String path) {
        this.checkPath(path);
        String webAppMount = this.getWebAppMount();
        ArrayList<String> result = new ArrayList<String>();
        if (path.startsWith(webAppMount)) {
            String pathInJar = this.getInternalPath() + path.substring(webAppMount.length());
            if (pathInJar.length() > 0 && pathInJar.charAt(0) == '/') {
                pathInJar = pathInJar.substring(1);
            }
            for (String name : this.jarFileEntries.keySet()) {
                if (name.length() <= pathInJar.length() || !name.startsWith(pathInJar) || (name = name.charAt(name.length() - 1) == '/' ? name.substring(pathInJar.length(), name.length() - 1) : name.substring(pathInJar.length())).length() == 0) continue;
                if (name.charAt(0) == '/') {
                    name = name.substring(1);
                }
                if (name.length() <= 0 || name.lastIndexOf(47) != -1) continue;
                result.add(name);
            }
        } else {
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            if (webAppMount.startsWith(path)) {
                int i = webAppMount.indexOf(47, path.length());
                if (i == -1) {
                    return new String[]{webAppMount.substring(path.length())};
                }
                return new String[]{webAppMount.substring(path.length(), i)};
            }
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public final Set<String> listWebAppPaths(String path) {
        this.checkPath(path);
        String webAppMount = this.getWebAppMount();
        ResourceSet<String> result = new ResourceSet<String>();
        if (path.startsWith(webAppMount)) {
            String pathInJar = this.getInternalPath() + path.substring(webAppMount.length());
            if (pathInJar.length() > 0) {
                if (pathInJar.charAt(pathInJar.length() - 1) != '/') {
                    pathInJar = pathInJar.substring(1) + '/';
                }
                if (pathInJar.charAt(0) == '/') {
                    pathInJar = pathInJar.substring(1);
                }
            }
            for (String name : this.jarFileEntries.keySet()) {
                int nextSlash;
                if (name.length() <= pathInJar.length() || !name.startsWith(pathInJar) || (nextSlash = name.indexOf(47, pathInJar.length())) != -1 && nextSlash != name.length() - 1 || !name.startsWith(pathInJar)) continue;
                result.add(webAppMount + '/' + name.substring(this.getInternalPath().length()));
            }
        } else {
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            if (webAppMount.startsWith(path)) {
                int i = webAppMount.indexOf(47, path.length());
                if (i == -1) {
                    result.add(webAppMount + "/");
                } else {
                    result.add(webAppMount.substring(0, i + 1));
                }
            }
        }
        result.setLocked(true);
        return result;
    }

    @Override
    public final boolean mkdir(String path) {
        this.checkPath(path);
        return false;
    }

    @Override
    public final boolean write(String path, InputStream is, boolean overwrite) {
        this.checkPath(path);
        if (is == null) {
            throw new NullPointerException(sm.getString("dirResourceSet.writeNpe"));
        }
        return false;
    }

    @Override
    public final WebResource getResource(String path) {
        this.checkPath(path);
        String webAppMount = this.getWebAppMount();
        WebResourceRoot root = this.getRoot();
        if (path.startsWith(webAppMount)) {
            String pathInJar = this.getInternalPath() + path.substring(webAppMount.length(), path.length());
            if (pathInJar.length() > 0 && pathInJar.charAt(0) == '/') {
                pathInJar = pathInJar.substring(1);
            }
            if (pathInJar.equals("")) {
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                return new JarResourceRoot(root, new File(this.getBase()), this.baseUrlString, path);
            }
            JarEntry jarEntry = null;
            if (pathInJar.charAt(pathInJar.length() - 1) != '/' && (jarEntry = this.jarFileEntries.get(pathInJar + '/')) != null) {
                path = path + '/';
            }
            if (jarEntry == null) {
                jarEntry = this.jarFileEntries.get(pathInJar);
            }
            if (jarEntry == null) {
                return new EmptyResource(root, path);
            }
            return this.createArchiveResource(jarEntry, path, this.manifest);
        }
        return new EmptyResource(root, path);
    }

    protected abstract WebResource createArchiveResource(JarEntry var1, String var2, Manifest var3);

    @Override
    public final boolean isReadOnly() {
        return true;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        if (readOnly) {
            return;
        }
        throw new IllegalArgumentException(sm.getString("abstractArchiveResourceSet.setReadOnlyFalse"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JarFile openJarFile() throws IOException {
        Object object = this.archiveLock;
        synchronized (object) {
            if (this.archive == null) {
                this.archive = new JarFile(this.getBase());
            }
            ++this.archiveUseCount;
            return this.archive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeJarFile() {
        Object object = this.archiveLock;
        synchronized (object) {
            --this.archiveUseCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void gc() {
        Object object = this.archiveLock;
        synchronized (object) {
            if (this.archive != null && this.archiveUseCount == 0L) {
                try {
                    this.archive.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.archive = null;
            }
        }
    }
}

