/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.dao.impl;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivityManualPlanDAO;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.dataobject.ActivityManualPlanDO;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository(value="activityManualPlanDAO")
public class ActivityManualPlanDAOImpl
extends BaseDAO
implements ActivityManualPlanDAO {
    @Override
    public boolean insert(ActivityManualPlanDO manualPlan) throws TuiaMediaException {
        try {
            return this.getSqlSession().insert(this.getStamentNameSpace("insert"), (Object)manualPlan) > 0;
        }
        catch (Exception e) {
            this.logger.error("ActivityManualPlanDAOImpl.insert happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<ActivityManualPlanDO> selectForList(Long slotId) throws TuiaMediaException {
        try {
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectForList"), (Object)slotId);
        }
        catch (Exception e) {
            this.logger.error("ActivityManualPlanDAOImpl.selectForList happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public boolean update(ActivityManualPlanDO manualPlan) throws TuiaMediaException {
        try {
            return this.getSqlSession().update(this.getStamentNameSpace("update"), (Object)manualPlan) > 0;
        }
        catch (Exception e) {
            this.logger.error("ActivityManualPlanDAOImpl.update happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public boolean updateStatus(ActivityManualPlanDO manualPlan, int status) throws TuiaMediaException {
        try {
            HashMap<String, Number> map = new HashMap<String, Number>();
            map.put("slotId", manualPlan.getSlotId());
            map.put("activityId", manualPlan.getActivityId());
            map.put("activityType", manualPlan.getActivityType());
            map.put("status", status);
            return this.getSqlSession().update(this.getStamentNameSpace("updateStatus"), map) > 0;
        }
        catch (Exception e) {
            this.logger.error("ActivityManualPlanDAOImpl.updateStatus happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public boolean updateStatusBefore(ActivityManualPlanDO manualPlan, int status) throws TuiaMediaException {
        try {
            HashMap<String, Comparable<Long>> map = new HashMap<String, Comparable<Long>>();
            map.put("slotId", manualPlan.getSlotId());
            map.put("releaseTime", manualPlan.getReleaseTime());
            map.put("status", Integer.valueOf(status));
            return this.getSqlSession().update(this.getStamentNameSpace("updateStatusBefore"), map) > 0;
        }
        catch (Exception e) {
            this.logger.error("ActivityManualPlanDAOImpl.updateStatus happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public boolean delete(ActivityManualPlanDO manualPlan) throws TuiaMediaException {
        try {
            return this.getSqlSession().delete(this.getStamentNameSpace("delete"), (Object)manualPlan) > 0;
        }
        catch (Exception e) {
            this.logger.error("MediaAppMsDAO.insertBatch happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }
}

