/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.dao.impl;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.dao.MaterialSpecificationItemDAO;
import cn.com.duiba.tuia.media.dataobject.MaterialSpecificationItemDO;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository(value="materialSpecificationItemDAO")
public class MaterialSpecificationItemDAOImpl
extends BaseDAO
implements MaterialSpecificationItemDAO {
    @Override
    public int insertBatch(List<MaterialSpecificationItemDO> list) throws TuiaMediaException {
        try {
            if (CollectionUtils.isEmpty(list)) {
                return 0;
            }
            return this.getSqlSession().insert(this.getStamentNameSpace("insertBatch"), list);
        }
        catch (Exception e) {
            this.logger.error("MaterialSpecificationItemDAO.insertBatch happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<MaterialSpecificationItemDO> getByMsId(Long msId) throws TuiaMediaException {
        try {
            return this.getSqlSession().selectList(this.getStamentNameSpace("getByMsId"), (Object)msId);
        }
        catch (Exception e) {
            this.logger.error("MaterialSpecificationItemDAO.getByMsId happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int update(MaterialSpecificationItemDO materialSpecificationItemDO) throws TuiaMediaException {
        try {
            return this.getSqlSession().update(this.getStamentNameSpace("update"), (Object)materialSpecificationItemDO);
        }
        catch (Exception e) {
            this.logger.error("MaterialSpecificationItemDAO.update happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }
}

