/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.remoteservice;

import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqActivitySort;
import cn.com.duiba.tuia.media.api.dto.req.ReqIdAndType;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteActivitySortBackendService;
import cn.com.duiba.tuia.media.domain.ActivitySortDto;
import cn.com.duiba.tuia.media.remoteservice.BaseRemoteService;
import cn.com.duiba.tuia.media.service.ActivityService;
import cn.com.duiba.tuia.media.service.ActivitySortService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class RemoteActivitySortBackendServiceImpl
extends BaseRemoteService
implements RemoteActivitySortBackendService {
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ActivitySortService activitySortService;

    public DubboResult<PageResultDto<RspActivityDto>> getByCondition(ReqActivitySort reqActivitySort) {
        try {
            int amount = this.activitySortService.selectByConditionAmount(reqActivitySort);
            reqActivitySort.setSort("activity_sort asc,gmt_modified desc");
            reqActivitySort.setRowStart(reqActivitySort.getPageSize() * (reqActivitySort.getCurrentPage() - 1));
            List<ActivitySortDto> result = this.activitySortService.selectByCondition(reqActivitySort);
            ArrayList<RspActivityDto> list = new ArrayList<RspActivityDto>();
            for (ActivitySortDto activitySortDto : result) {
                list.add(this.activityService.getActivityPlanDetail(activitySortDto.getActivityId(), activitySortDto.getActivityType()));
            }
            return DubboResult.successResult((Object)new PageResultDto(amount, list, reqActivitySort.getPageSize().intValue()));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendService.getByCondition is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> addActivitySort(Long slotId, List<ReqIdAndType> idAndTypes) {
        try {
            DubboResult result = new DubboResult();
            result.setSuccess(true);
            result.setReturnCode("0");
            int successRecord = this.activitySortService.addActivitySort(slotId, idAndTypes);
            result.setMsg("\u6210\u529f\u6dfb\u52a0" + successRecord + "\u4e2a\u6d3b\u52a8");
            return result;
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendService.addActivitySort is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> addDefaultActivitySort(Long slotId) {
        try {
            DubboResult result = new DubboResult();
            result.setSuccess(true);
            result.setReturnCode("0");
            int successRecord = this.activitySortService.addDefaultActivitySort(slotId);
            result.setMsg("\u6210\u529f\u6dfb\u52a0" + successRecord + "\u4e2a\u6d3b\u52a8");
            return result;
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendService.addDefaultActivitySort is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> removeActivity(Long slotId, Long activityId, Integer activityType) {
        try {
            return DubboResult.successResult((Object)this.activitySortService.deleteActivity(activityId, activityType, slotId));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendService.removeActivity is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> sort(Long slotId, Long activityId, Integer activityType, int location) {
        try {
            return DubboResult.successResult((Object)this.activitySortService.sortActivity(slotId, activityId, activityType, location));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendService.sort is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<RspActivityDto>> getActivityByApp(Long appId) {
        try {
            return DubboResult.successResult(this.activitySortService.getActivityForRecommendByApp(appId));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendService.getActivityByApp is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<RspActivityDto>> getActivityBySlot(Long slotId) {
        try {
            return DubboResult.successResult(this.activitySortService.getActivityForRecommendBySlot(slotId));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendService.getActivityBySlot is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }
}

