/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.remoteservice;

import cn.com.duiba.tuia.media.api.dto.MediaAppDto;
import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqMaterialSpecificationDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspMaterialSpecificationDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteMaterialSpecificationBackendService;
import cn.com.duiba.tuia.media.model.IdAndName;
import cn.com.duiba.tuia.media.parser.IdAndNameParser;
import cn.com.duiba.tuia.media.remoteservice.BaseRemoteService;
import cn.com.duiba.tuia.media.service.MaterialSpecificationService;
import cn.com.duiba.tuia.media.service.MediaAppMsService;
import cn.com.duiba.tuia.media.service.MediaAppService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class RemoteMaterialSpecificationBackendServiceImpl
extends BaseRemoteService
implements RemoteMaterialSpecificationBackendService {
    @Autowired
    private MaterialSpecificationService materialSpecificationService;
    @Autowired
    private MediaAppMsService mediaAppMsService;
    @Autowired
    MediaAppService mediaAppService;

    public DubboResult<PageResultDto<RspMaterialSpecificationDto>> getMaterialSpecificationList(ReqMaterialSpecificationDto req) {
        try {
            return DubboResult.successResult((Object)new PageResultDto(this.materialSpecificationService.getMaterialSpecificationAmount(req), this.materialSpecificationService.getMaterialSpecificationList(req), req.getPageSize().intValue()));
        }
        catch (Exception e) {
            this.logger.error("RemoteMaterialSpecificationBackendService.getMaterialSpecificationList is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> deleteMaterialSpecification(Long id) {
        try {
            return DubboResult.successResult((Object)this.materialSpecificationService.deleteMaterialSpecification(id));
        }
        catch (Exception e) {
            this.logger.error("RemoteMaterialSpecificationBackendService.deleteMaterialSpecification is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<RspMaterialSpecificationDto> getMaterialSpecificationDetail(Long msId) {
        try {
            return DubboResult.successResult((Object)this.materialSpecificationService.getMaterialSpecificationDetail(msId));
        }
        catch (Exception e) {
            this.logger.error("RemoteMaterialSpecificationBackendService.getMaterialSpecificationDetail is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> addMaterialSpecification(ReqMaterialSpecificationDto req) {
        try {
            return DubboResult.successResult((Object)this.materialSpecificationService.addMaterialSpecification(req));
        }
        catch (Exception e) {
            this.logger.error("RemoteMaterialSpecificationBackendService.addMaterialSpecification is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> msDirectToMediaApp(Long msId, List<Long> appIds, Integer directStatus) {
        try {
            return DubboResult.successResult((Object)this.mediaAppMsService.msDirectToMediaApp(msId, appIds, directStatus));
        }
        catch (Exception e) {
            this.logger.error("RemoteMaterialSpecificationBackendService.msDirectToMediaApp is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<MediaAppDto>> getMsDirectedMediaApp(Long msId) {
        try {
            List<Long> list = this.mediaAppMsService.getMsDirectedMediaApp(msId);
            ArrayList<MediaAppDto> result = new ArrayList<MediaAppDto>();
            if (!CollectionUtils.isEmpty(list)) {
                List<IdAndName> apps = this.mediaAppService.selectAppIdAndName(list);
                for (IdAndName idAndName : apps) {
                    result.add(IdAndNameParser.parseToMediaAppDto(idAndName));
                }
            }
            return DubboResult.successResult(result);
        }
        catch (Exception e) {
            this.logger.error("RemoteMaterialSpecificationBackendService.getMsDirectedMediaApp is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Map<Long, String>> getMsNameByIds(List<Long> ids) {
        try {
            return DubboResult.successResult(this.materialSpecificationService.getMsNameByIds(ids));
        }
        catch (Exception e) {
            this.logger.error("RemoteMaterialSpecificationBackendService.getMsNameByIds is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }
}

